/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.compress.utils;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicBoolean;

public class FixedLengthBlockOutputStream
extends OutputStream
implements WritableByteChannel {
    private final WritableByteChannel out;
    private final int blockSize;
    private final ByteBuffer buffer;
    private final AtomicBoolean closed = new AtomicBoolean();

    public FixedLengthBlockOutputStream(OutputStream outputStream, int n2) {
        if (outputStream instanceof FileOutputStream) {
            FileOutputStream fileOutputStream = (FileOutputStream)outputStream;
            this.out = fileOutputStream.getChannel();
            this.buffer = ByteBuffer.allocateDirect(n2);
        } else {
            this.out = new BufferAtATimeOutputChannel(outputStream);
            this.buffer = ByteBuffer.allocate(n2);
        }
        this.blockSize = n2;
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.flushBlock();
            }
            finally {
                this.out.close();
            }
        }
    }

    public void flushBlock() throws IOException {
        if (this.buffer.position() != 0) {
            this.padBlock();
            this.writeBlock();
        }
    }

    @Override
    public boolean isOpen() {
        if (!this.out.isOpen()) {
            this.closed.set(true);
        }
        return !this.closed.get();
    }

    private void maybeFlush() throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.writeBlock();
        }
    }

    private void padBlock() {
        this.buffer.order(ByteOrder.nativeOrder());
        int n2 = this.buffer.remaining();
        if (n2 > 8) {
            int n3 = this.buffer.position() & 7;
            if (n3 != 0) {
                int n4 = 8 - n3;
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.buffer.put((byte)0);
                }
                n2 -= n4;
            }
            while (n2 >= 8) {
                this.buffer.putLong(0L);
                n2 -= 8;
            }
        }
        while (this.buffer.hasRemaining()) {
            this.buffer.put((byte)0);
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        int n4 = n2;
        int n5 = n3;
        while (n5 > 0) {
            int n6 = Math.min(n5, this.buffer.remaining());
            this.buffer.put(byArray, n4, n6);
            this.maybeFlush();
            n5 -= n6;
            n4 += n6;
        }
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        int n2 = byteBuffer.remaining();
        if (n2 < this.buffer.remaining()) {
            this.buffer.put(byteBuffer);
        } else {
            int n3 = n2;
            int n4 = byteBuffer.limit();
            if (this.buffer.position() != 0) {
                int n5 = this.buffer.remaining();
                byteBuffer.limit(byteBuffer.position() + n5);
                this.buffer.put(byteBuffer);
                this.writeBlock();
                n3 -= n5;
            }
            while (n3 >= this.blockSize) {
                byteBuffer.limit(byteBuffer.position() + this.blockSize);
                this.out.write(byteBuffer);
                n3 -= this.blockSize;
            }
            byteBuffer.limit(n4);
            this.buffer.put(byteBuffer);
        }
        return n2;
    }

    @Override
    public void write(int n2) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        this.buffer.put((byte)n2);
        this.maybeFlush();
    }

    private void writeBlock() throws IOException {
        this.buffer.flip();
        int n2 = this.out.write(this.buffer);
        boolean bl2 = this.buffer.hasRemaining();
        if (n2 != this.blockSize || bl2) {
            String string = String.format("Failed to write %,d bytes atomically. Only wrote  %,d", this.blockSize, n2);
            throw new IOException(string);
        }
        this.buffer.clear();
    }

    private static final class BufferAtATimeOutputChannel
    implements WritableByteChannel {
        private final OutputStream out;
        private final AtomicBoolean closed = new AtomicBoolean();

        private BufferAtATimeOutputChannel(OutputStream outputStream) {
            this.out = outputStream;
        }

        @Override
        public void close() throws IOException {
            if (this.closed.compareAndSet(false, true)) {
                this.out.close();
            }
        }

        @Override
        public boolean isOpen() {
            return !this.closed.get();
        }

        @Override
        public int write(ByteBuffer byteBuffer) throws IOException {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!byteBuffer.hasArray()) {
                throw new IOException("Direct buffer somehow written to BufferAtATimeOutputChannel");
            }
            try {
                int n2 = byteBuffer.position();
                int n3 = byteBuffer.limit() - n2;
                this.out.write(byteBuffer.array(), byteBuffer.arrayOffset() + n2, n3);
                byteBuffer.position(byteBuffer.limit());
                return n3;
            }
            catch (IOException iOException) {
                try {
                    this.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                throw iOException;
            }
        }
    }
}

