/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.util.CharsetUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpVersion
implements Comparable<HttpVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\S+)/(\\d+)\\.(\\d+)");
    public static final HttpVersion HTTP_1_0 = new HttpVersion("HTTP", 1, 0, false, true);
    public static final HttpVersion HTTP_1_1 = new HttpVersion("HTTP", 1, 1, true, true);
    private final String protocolName;
    private final int majorVersion;
    private final int minorVersion;
    private final String text;
    private final boolean keepAliveDefault;
    private final byte[] bytes;

    static HttpVersion valueOf(String string, boolean bl2) {
        ObjectUtil.checkNotNull(string, "text");
        if (string == "HTTP/1.1") {
            return HTTP_1_1;
        }
        if (string == "HTTP/1.0") {
            return HTTP_1_0;
        }
        if ((string = string.trim()).isEmpty()) {
            throw new IllegalArgumentException("text is empty (possibly HTTP/0.9)");
        }
        HttpVersion httpVersion = HttpVersion.version0(string);
        if (httpVersion == null) {
            httpVersion = new HttpVersion(string, bl2, true);
        }
        return httpVersion;
    }

    private static HttpVersion version0(String string) {
        if ("HTTP/1.1".equals(string)) {
            return HTTP_1_1;
        }
        if ("HTTP/1.0".equals(string)) {
            return HTTP_1_0;
        }
        return null;
    }

    HttpVersion(String string, boolean bl2, boolean bl3) {
        string = ObjectUtil.checkNonEmptyAfterTrim(string, "text").toUpperCase();
        if (bl2) {
            if (string.length() != 8 || !string.startsWith("HTTP/") || string.charAt(6) != '.') {
                throw new IllegalArgumentException("invalid version format: " + string);
            }
            this.protocolName = "HTTP";
            this.majorVersion = HttpVersion.toDecimal(string.charAt(5));
            this.minorVersion = HttpVersion.toDecimal(string.charAt(7));
        } else {
            Matcher matcher = VERSION_PATTERN.matcher(string);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("invalid version format: " + string);
            }
            this.protocolName = matcher.group(1);
            this.majorVersion = Integer.parseInt(matcher.group(2));
            this.minorVersion = Integer.parseInt(matcher.group(3));
        }
        this.text = this.protocolName + '/' + this.majorVersion + '.' + this.minorVersion;
        this.keepAliveDefault = bl3;
        this.bytes = null;
    }

    private static int toDecimal(int n2) {
        if (n2 < 48 || n2 > 57) {
            throw new IllegalArgumentException("Invalid version number, only 0-9 (0x30-0x39) allowed, but received a '" + (char)n2 + "' (0x" + Integer.toHexString(n2) + ")");
        }
        return n2 - 48;
    }

    private HttpVersion(String string, int n2, int n3, boolean bl2, boolean bl3) {
        string = ObjectUtil.checkNonEmptyAfterTrim(string, "protocolName").toUpperCase();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (!Character.isISOControl(string.charAt(i2)) && !Character.isWhitespace(string.charAt(i2))) continue;
            throw new IllegalArgumentException("invalid character in protocolName");
        }
        ObjectUtil.checkPositiveOrZero(n2, "majorVersion");
        ObjectUtil.checkPositiveOrZero(n3, "minorVersion");
        this.protocolName = string;
        this.majorVersion = n2;
        this.minorVersion = n3;
        this.text = string + '/' + n2 + '.' + n3;
        this.keepAliveDefault = bl2;
        this.bytes = (byte[])(bl3 ? this.text.getBytes(CharsetUtil.US_ASCII) : null);
    }

    public String protocolName() {
        return this.protocolName;
    }

    public int majorVersion() {
        return this.majorVersion;
    }

    public int minorVersion() {
        return this.minorVersion;
    }

    public String text() {
        return this.text;
    }

    public boolean isKeepAliveDefault() {
        return this.keepAliveDefault;
    }

    public String toString() {
        return this.text();
    }

    public int hashCode() {
        return (this.protocolName().hashCode() * 31 + this.majorVersion()) * 31 + this.minorVersion();
    }

    public boolean equals(Object object) {
        if (!(object instanceof HttpVersion)) {
            return false;
        }
        HttpVersion httpVersion = (HttpVersion)object;
        return this.minorVersion() == httpVersion.minorVersion() && this.majorVersion() == httpVersion.majorVersion() && this.protocolName().equals(httpVersion.protocolName());
    }

    @Override
    public int compareTo(HttpVersion httpVersion) {
        int n2 = this.protocolName().compareTo(httpVersion.protocolName());
        if (n2 != 0) {
            return n2;
        }
        n2 = this.majorVersion() - httpVersion.majorVersion();
        if (n2 != 0) {
            return n2;
        }
        return this.minorVersion() - httpVersion.minorVersion();
    }

    void encode(ByteBuf byteBuf) {
        if (this.bytes == null) {
            byteBuf.writeCharSequence(this.text, CharsetUtil.US_ASCII);
        } else {
            byteBuf.writeBytes(this.bytes);
        }
    }
}

