/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.channel.socket.nio;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.channel.Channel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelException;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelFuture;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelOption;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelOutboundBuffer;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.channel.FileRegion;
import com.gradle.maven.extension.internal.dep.io.netty.channel.RecvByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.channel.nio.AbstractNioByteChannel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.nio.AbstractNioChannel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.nio.NioEventLoop;
import com.gradle.maven.extension.internal.dep.io.netty.channel.socket.DefaultSocketChannelConfig;
import com.gradle.maven.extension.internal.dep.io.netty.channel.socket.InternetProtocolFamily;
import com.gradle.maven.extension.internal.dep.io.netty.channel.socket.SocketChannel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.socket.SocketChannelConfig;
import com.gradle.maven.extension.internal.dep.io.netty.channel.socket.nio.NioChannelOption;
import com.gradle.maven.extension.internal.dep.io.netty.channel.socket.nio.SelectorProviderUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.GlobalEventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.SocketUtils;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.Executor;

public class NioSocketChannel
extends AbstractNioByteChannel
implements SocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioSocketChannel.class);
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private static final Method OPEN_SOCKET_CHANNEL_WITH_FAMILY = SelectorProviderUtil.findOpenMethod("openSocketChannel");
    private final SocketChannelConfig config;

    private static java.nio.channels.SocketChannel newChannel(SelectorProvider selectorProvider, InternetProtocolFamily internetProtocolFamily) {
        try {
            java.nio.channels.SocketChannel socketChannel = (java.nio.channels.SocketChannel)SelectorProviderUtil.newChannel(OPEN_SOCKET_CHANNEL_WITH_FAMILY, selectorProvider, internetProtocolFamily);
            return socketChannel == null ? selectorProvider.openSocketChannel() : socketChannel;
        }
        catch (IOException iOException) {
            throw new ChannelException("Failed to open a socket.", iOException);
        }
    }

    public NioSocketChannel() {
        this(DEFAULT_SELECTOR_PROVIDER);
    }

    public NioSocketChannel(SelectorProvider selectorProvider) {
        this(selectorProvider, null);
    }

    public NioSocketChannel(SelectorProvider selectorProvider, InternetProtocolFamily internetProtocolFamily) {
        this(NioSocketChannel.newChannel(selectorProvider, internetProtocolFamily));
    }

    public NioSocketChannel(java.nio.channels.SocketChannel socketChannel) {
        this(null, socketChannel);
    }

    public NioSocketChannel(Channel channel, java.nio.channels.SocketChannel socketChannel) {
        super(channel, socketChannel);
        this.config = new NioSocketChannelConfig(this, socketChannel.socket());
    }

    @Override
    public SocketChannelConfig config() {
        return this.config;
    }

    @Override
    protected java.nio.channels.SocketChannel javaChannel() {
        return (java.nio.channels.SocketChannel)super.javaChannel();
    }

    @Override
    public boolean isActive() {
        java.nio.channels.SocketChannel socketChannel = this.javaChannel();
        return socketChannel.isOpen() && socketChannel.isConnected();
    }

    public boolean isInputShutdown() {
        return this.javaChannel().socket().isInputShutdown() || !this.isActive();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    protected final void doShutdownOutput() throws Exception {
        if (PlatformDependent.javaVersion() >= 7) {
            this.javaChannel().shutdownOutput();
        } else {
            this.javaChannel().socket().shutdownOutput();
        }
    }

    @Override
    public ChannelFuture shutdownInput() {
        return this.shutdownInput(this.newPromise());
    }

    @Override
    protected boolean isInputShutdown0() {
        return this.isInputShutdown();
    }

    public ChannelFuture shutdownInput(final ChannelPromise channelPromise) {
        NioEventLoop nioEventLoop = this.eventLoop();
        if (nioEventLoop.inEventLoop()) {
            this.shutdownInput0(channelPromise);
        } else {
            nioEventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    NioSocketChannel.this.shutdownInput0(channelPromise);
                }
            });
        }
        return channelPromise;
    }

    private void shutdownInput0(ChannelPromise channelPromise) {
        try {
            this.shutdownInput0();
            channelPromise.setSuccess();
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
    }

    private void shutdownInput0() throws Exception {
        if (PlatformDependent.javaVersion() >= 7) {
            this.javaChannel().shutdownInput();
        } else {
            this.javaChannel().socket().shutdownInput();
        }
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.javaChannel().socket().getLocalSocketAddress();
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.javaChannel().socket().getRemoteSocketAddress();
    }

    @Override
    protected void doBind(SocketAddress socketAddress) throws Exception {
        this.doBind0(socketAddress);
    }

    private void doBind0(SocketAddress socketAddress) throws Exception {
        if (PlatformDependent.javaVersion() >= 7) {
            SocketUtils.bind(this.javaChannel(), socketAddress);
        } else {
            SocketUtils.bind(this.javaChannel().socket(), socketAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) throws Exception {
        if (socketAddress2 != null) {
            this.doBind0(socketAddress2);
        }
        boolean bl2 = false;
        try {
            boolean bl3 = SocketUtils.connect(this.javaChannel(), socketAddress);
            if (!bl3) {
                this.selectionKey().interestOps(8);
            }
            bl2 = true;
            boolean bl4 = bl3;
            return bl4;
        }
        finally {
            if (!bl2) {
                this.doClose();
            }
        }
    }

    @Override
    protected void doFinishConnect() throws Exception {
        if (!this.javaChannel().finishConnect()) {
            throw new Error();
        }
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    @Override
    protected void doClose() throws Exception {
        super.doClose();
        this.javaChannel().close();
    }

    @Override
    protected int doReadBytes(ByteBuf byteBuf) throws Exception {
        RecvByteBufAllocator.Handle handle = this.unsafe().recvBufAllocHandle();
        handle.attemptedBytesRead(byteBuf.writableBytes());
        return byteBuf.writeBytes(this.javaChannel(), handle.attemptedBytesRead());
    }

    @Override
    protected int doWriteBytes(ByteBuf byteBuf) throws Exception {
        int n2 = byteBuf.readableBytes();
        return byteBuf.readBytes(this.javaChannel(), n2);
    }

    @Override
    protected long doWriteFileRegion(FileRegion fileRegion) throws Exception {
        long l2 = fileRegion.transferred();
        return fileRegion.transferTo(this.javaChannel(), l2);
    }

    private void adjustMaxBytesPerGatheringWrite(int n2, int n3, int n4) {
        if (n2 == n3) {
            if (n2 << 1 > n4) {
                ((NioSocketChannelConfig)this.config).setMaxBytesPerGatheringWrite(n2 << 1);
            }
        } else if (n2 > 4096 && n3 < n2 >>> 1) {
            ((NioSocketChannelConfig)this.config).setMaxBytesPerGatheringWrite(n2 >>> 1);
        }
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) throws Exception {
        java.nio.channels.SocketChannel socketChannel = this.javaChannel();
        int n2 = this.config().getWriteSpinCount();
        do {
            if (channelOutboundBuffer.isEmpty()) {
                this.clearOpWrite();
                return;
            }
            int n3 = ((NioSocketChannelConfig)this.config).getMaxBytesPerGatheringWrite();
            ByteBuffer[] byteBufferArray = channelOutboundBuffer.nioBuffers(1024, n3);
            int n4 = channelOutboundBuffer.nioBufferCount();
            switch (n4) {
                case 0: {
                    n2 -= this.doWrite0(channelOutboundBuffer);
                    break;
                }
                case 1: {
                    ByteBuffer byteBuffer = byteBufferArray[0];
                    int n5 = byteBuffer.remaining();
                    int n6 = socketChannel.write(byteBuffer);
                    if (n6 <= 0) {
                        this.incompleteWrite(true);
                        return;
                    }
                    this.adjustMaxBytesPerGatheringWrite(n5, n6, n3);
                    channelOutboundBuffer.removeBytes(n6);
                    --n2;
                    break;
                }
                default: {
                    long l2 = channelOutboundBuffer.nioBufferSize();
                    long l3 = socketChannel.write(byteBufferArray, 0, n4);
                    if (l3 <= 0L) {
                        this.incompleteWrite(true);
                        return;
                    }
                    this.adjustMaxBytesPerGatheringWrite((int)l2, (int)l3, n3);
                    channelOutboundBuffer.removeBytes(l3);
                    --n2;
                    break;
                }
            }
        } while (n2 > 0);
        this.incompleteWrite(n2 < 0);
    }

    @Override
    protected AbstractNioChannel.AbstractNioUnsafe newUnsafe() {
        return new NioSocketChannelUnsafe();
    }

    private final class NioSocketChannelConfig
    extends DefaultSocketChannelConfig {
        private volatile int maxBytesPerGatheringWrite;

        private NioSocketChannelConfig(NioSocketChannel nioSocketChannel2, Socket socket) {
            super(nioSocketChannel2, socket);
            this.maxBytesPerGatheringWrite = Integer.MAX_VALUE;
            this.calculateMaxBytesPerGatheringWrite();
        }

        @Override
        protected void autoReadCleared() {
            NioSocketChannel.this.clearReadPending();
        }

        @Override
        public NioSocketChannelConfig setSendBufferSize(int n2) {
            super.setSendBufferSize(n2);
            this.calculateMaxBytesPerGatheringWrite();
            return this;
        }

        @Override
        public <T> boolean setOption(ChannelOption<T> channelOption, T t2) {
            if (PlatformDependent.javaVersion() >= 7 && channelOption instanceof NioChannelOption) {
                return NioChannelOption.setOption(this.jdkChannel(), (NioChannelOption)channelOption, t2);
            }
            return super.setOption(channelOption, t2);
        }

        @Override
        public <T> T getOption(ChannelOption<T> channelOption) {
            if (PlatformDependent.javaVersion() >= 7 && channelOption instanceof NioChannelOption) {
                return NioChannelOption.getOption(this.jdkChannel(), (NioChannelOption)channelOption);
            }
            return super.getOption(channelOption);
        }

        void setMaxBytesPerGatheringWrite(int n2) {
            this.maxBytesPerGatheringWrite = n2;
        }

        int getMaxBytesPerGatheringWrite() {
            return this.maxBytesPerGatheringWrite;
        }

        private void calculateMaxBytesPerGatheringWrite() {
            int n2 = this.getSendBufferSize() << 1;
            if (n2 > 0) {
                this.setMaxBytesPerGatheringWrite(n2);
            }
        }

        private java.nio.channels.SocketChannel jdkChannel() {
            return ((NioSocketChannel)this.channel).javaChannel();
        }
    }

    private final class NioSocketChannelUnsafe
    extends AbstractNioByteChannel.NioByteUnsafe {
        private NioSocketChannelUnsafe() {
        }

        @Override
        protected Executor prepareToClose() {
            try {
                if (NioSocketChannel.this.javaChannel().isOpen() && NioSocketChannel.this.config().getSoLinger() > 0) {
                    NioSocketChannel.this.doDeregister();
                    return GlobalEventExecutor.INSTANCE;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }
}

