/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.channel;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.AbstractReferenceCountedByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufHolder;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.Unpooled;
import com.gradle.maven.extension.internal.dep.io.netty.channel.AbstractChannel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.Channel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPipeline;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelProgressivePromise;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.channel.DefaultChannelProgressivePromise;
import com.gradle.maven.extension.internal.dep.io.netty.channel.DefaultChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.channel.FileRegion;
import com.gradle.maven.extension.internal.dep.io.netty.channel.VoidChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.util.Recycler;
import com.gradle.maven.extension.internal.dep.io.netty.util.ReferenceCountUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.FastThreadLocal;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.InternalThreadLocalMap;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectPool;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PromiseNotificationUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public final class ChannelOutboundBuffer {
    static final int CHANNEL_OUTBOUND_BUFFER_ENTRY_OVERHEAD = SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.transport.outboundBufferEntrySizeOverhead", 96);
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelOutboundBuffer.class);
    private static final FastThreadLocal<ByteBuffer[]> NIO_BUFFERS = new FastThreadLocal<ByteBuffer[]>(){

        @Override
        protected ByteBuffer[] initialValue() throws Exception {
            return new ByteBuffer[1024];
        }
    };
    private final Channel channel;
    private Entry flushedEntry;
    private Entry unflushedEntry;
    private Entry tailEntry;
    private int flushed;
    private int nioBufferCount;
    private long nioBufferSize;
    private boolean inFail;
    private static final AtomicLongFieldUpdater<ChannelOutboundBuffer> TOTAL_PENDING_SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(ChannelOutboundBuffer.class, "totalPendingSize");
    private volatile long totalPendingSize;
    private static final AtomicIntegerFieldUpdater<ChannelOutboundBuffer> UNWRITABLE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ChannelOutboundBuffer.class, "unwritable");
    private volatile int unwritable;
    private volatile Runnable fireChannelWritabilityChangedTask;

    ChannelOutboundBuffer(AbstractChannel abstractChannel) {
        this.channel = abstractChannel;
    }

    public void addMessage(Object object, int n2, ChannelPromise channelPromise) {
        Entry entry = Entry.newInstance(object, n2, ChannelOutboundBuffer.total(object), channelPromise);
        if (this.tailEntry == null) {
            this.flushedEntry = null;
        } else {
            Entry entry2 = this.tailEntry;
            entry2.next = entry;
        }
        this.tailEntry = entry;
        if (this.unflushedEntry == null) {
            this.unflushedEntry = entry;
        }
        if (object instanceof AbstractReferenceCountedByteBuf) {
            ((AbstractReferenceCountedByteBuf)object).touch();
        } else {
            ReferenceCountUtil.touch(object);
        }
        this.incrementPendingOutboundBytes(entry.pendingSize, false);
    }

    public void addFlush() {
        Entry entry = this.unflushedEntry;
        if (entry != null) {
            if (this.flushedEntry == null) {
                this.flushedEntry = entry;
            }
            do {
                ++this.flushed;
                if (entry.promise.setUncancellable()) continue;
                int n2 = entry.cancel();
                this.decrementPendingOutboundBytes(n2, false, true);
            } while ((entry = entry.next) != null);
            this.unflushedEntry = null;
        }
    }

    void incrementPendingOutboundBytes(long l2) {
        this.incrementPendingOutboundBytes(l2, true);
    }

    private void incrementPendingOutboundBytes(long l2, boolean bl2) {
        if (l2 == 0L) {
            return;
        }
        long l3 = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, l2);
        if (l3 > (long)this.channel.config().getWriteBufferHighWaterMark()) {
            this.setUnwritable(bl2);
        }
    }

    void decrementPendingOutboundBytes(long l2) {
        this.decrementPendingOutboundBytes(l2, true, true);
    }

    private void decrementPendingOutboundBytes(long l2, boolean bl2, boolean bl3) {
        if (l2 == 0L) {
            return;
        }
        long l3 = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, -l2);
        if (bl3 && l3 < (long)this.channel.config().getWriteBufferLowWaterMark()) {
            this.setWritable(bl2);
        }
    }

    private static long total(Object object) {
        if (object instanceof ByteBuf) {
            return ((ByteBuf)object).readableBytes();
        }
        if (object instanceof FileRegion) {
            return ((FileRegion)object).count();
        }
        if (object instanceof ByteBufHolder) {
            return ((ByteBufHolder)object).content().readableBytes();
        }
        return -1L;
    }

    public Object current() {
        Entry entry = this.flushedEntry;
        if (entry == null) {
            return null;
        }
        return entry.msg;
    }

    public void progress(long l2) {
        long l3;
        Entry entry = this.flushedEntry;
        assert (entry != null);
        ChannelPromise channelPromise = entry.promise;
        entry.progress = l3 = entry.progress + l2;
        assert (channelPromise != null);
        Class<?> clazz = channelPromise.getClass();
        if (clazz == VoidChannelPromise.class || clazz == DefaultChannelPromise.class) {
            return;
        }
        if (channelPromise instanceof DefaultChannelProgressivePromise) {
            ((DefaultChannelProgressivePromise)channelPromise).tryProgress(l3, entry.total);
        } else if (channelPromise instanceof ChannelProgressivePromise) {
            ((ChannelProgressivePromise)channelPromise).tryProgress(l3, entry.total);
        }
    }

    public boolean remove() {
        Entry entry = this.flushedEntry;
        if (entry == null) {
            this.clearNioBuffers();
            return false;
        }
        Object object = entry.msg;
        ChannelPromise channelPromise = entry.promise;
        int n2 = entry.pendingSize;
        this.removeEntry(entry);
        if (!entry.cancelled) {
            if (object instanceof AbstractReferenceCountedByteBuf) {
                try {
                    ((AbstractReferenceCountedByteBuf)object).release();
                }
                catch (Throwable throwable) {
                    logger.warn("Failed to release a ByteBuf: {}", object, (Object)throwable);
                }
            } else {
                ReferenceCountUtil.safeRelease(object);
            }
            ChannelOutboundBuffer.safeSuccess(channelPromise);
            this.decrementPendingOutboundBytes(n2, false, true);
        }
        entry.unguardedRecycle();
        return true;
    }

    public boolean remove(Throwable throwable) {
        return this.remove0(throwable, true);
    }

    private boolean remove0(Throwable throwable, boolean bl2) {
        Entry entry = this.flushedEntry;
        if (entry == null) {
            this.clearNioBuffers();
            return false;
        }
        Object object = entry.msg;
        ChannelPromise channelPromise = entry.promise;
        int n2 = entry.pendingSize;
        this.removeEntry(entry);
        if (!entry.cancelled) {
            ReferenceCountUtil.safeRelease(object);
            ChannelOutboundBuffer.safeFail(channelPromise, throwable);
            this.decrementPendingOutboundBytes(n2, false, bl2);
        }
        entry.unguardedRecycle();
        return true;
    }

    private void removeEntry(Entry entry) {
        if (--this.flushed == 0) {
            this.flushedEntry = null;
            if (entry == this.tailEntry) {
                this.tailEntry = null;
                this.unflushedEntry = null;
            }
        } else {
            this.flushedEntry = entry.next;
        }
    }

    public void removeBytes(long l2) {
        block5: {
            int n2;
            ByteBuf byteBuf;
            while (true) {
                Object object;
                if (!((object = this.current()) instanceof ByteBuf)) {
                    assert (l2 == 0L);
                    break block5;
                }
                byteBuf = (ByteBuf)object;
                n2 = byteBuf.readerIndex();
                int n3 = byteBuf.writerIndex() - n2;
                if ((long)n3 > l2) break;
                if (l2 != 0L) {
                    this.progress(n3);
                    l2 -= (long)n3;
                }
                this.remove();
            }
            if (l2 != 0L) {
                byteBuf.readerIndex(n2 + (int)l2);
                this.progress(l2);
            }
        }
        this.clearNioBuffers();
    }

    private void clearNioBuffers() {
        int n2 = this.nioBufferCount;
        if (n2 > 0) {
            this.nioBufferCount = 0;
            Arrays.fill(NIO_BUFFERS.get(), 0, n2, null);
        }
    }

    public ByteBuffer[] nioBuffers(int n2, long l2) {
        assert (n2 > 0);
        assert (l2 > 0L);
        long l3 = 0L;
        int n3 = 0;
        InternalThreadLocalMap internalThreadLocalMap = InternalThreadLocalMap.get();
        ByteBuffer[] byteBufferArray = NIO_BUFFERS.get(internalThreadLocalMap);
        Entry entry = this.flushedEntry;
        while (this.isFlushedEntry(entry) && entry.msg instanceof ByteBuf) {
            if (!entry.cancelled) {
                ByteBuf byteBuf = (ByteBuf)entry.msg;
                int n4 = byteBuf.readerIndex();
                int n5 = byteBuf.writerIndex() - n4;
                if (n5 > 0) {
                    int n6;
                    if (l2 - (long)n5 < l3 && n3 != 0) break;
                    l3 += (long)n5;
                    int n7 = entry.count;
                    if (n7 == -1) {
                        entry.count = n7 = byteBuf.nioBufferCount();
                    }
                    if ((n6 = Math.min(n2, n3 + n7)) > byteBufferArray.length) {
                        byteBufferArray = ChannelOutboundBuffer.expandNioBufferArray(byteBufferArray, n6, n3);
                        NIO_BUFFERS.set(internalThreadLocalMap, byteBufferArray);
                    }
                    if (n7 == 1) {
                        ByteBuffer byteBuffer = entry.buf;
                        if (byteBuffer == null) {
                            entry.buf = byteBuffer = byteBuf.internalNioBuffer(n4, n5);
                        }
                        byteBufferArray[n3++] = byteBuffer;
                    } else {
                        n3 = ChannelOutboundBuffer.nioBuffers(entry, byteBuf, byteBufferArray, n3, n2);
                    }
                    if (n3 >= n2) break;
                }
            }
            entry = entry.next;
        }
        this.nioBufferCount = n3;
        this.nioBufferSize = l3;
        return byteBufferArray;
    }

    private static int nioBuffers(Entry entry, ByteBuf byteBuf, ByteBuffer[] byteBufferArray, int n2, int n3) {
        ByteBuffer byteBuffer;
        ByteBuffer[] byteBufferArray2 = entry.bufs;
        if (byteBufferArray2 == null) {
            entry.bufs = byteBufferArray2 = byteBuf.nioBuffers();
        }
        for (int i2 = 0; i2 < byteBufferArray2.length && n2 < n3 && (byteBuffer = byteBufferArray2[i2]) != null; ++i2) {
            if (!byteBuffer.hasRemaining()) continue;
            byteBufferArray[n2++] = byteBuffer;
        }
        return n2;
    }

    private static ByteBuffer[] expandNioBufferArray(ByteBuffer[] byteBufferArray, int n2, int n3) {
        int n4 = byteBufferArray.length;
        do {
            if ((n4 <<= 1) >= 0) continue;
            throw new IllegalStateException();
        } while (n2 > n4);
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n4];
        System.arraycopy(byteBufferArray, 0, byteBufferArray2, 0, n3);
        return byteBufferArray2;
    }

    public int nioBufferCount() {
        return this.nioBufferCount;
    }

    public long nioBufferSize() {
        return this.nioBufferSize;
    }

    public boolean isWritable() {
        return this.unwritable == 0;
    }

    private void setWritable(boolean bl2) {
        block1: {
            int n2;
            int n3;
            while (!UNWRITABLE_UPDATER.compareAndSet(this, n3 = this.unwritable, n2 = n3 & 0xFFFFFFFE)) {
            }
            if (n3 == 0 || n2 != 0) break block1;
            this.fireChannelWritabilityChanged(bl2);
        }
    }

    private void setUnwritable(boolean bl2) {
        block1: {
            int n2;
            int n3;
            while (!UNWRITABLE_UPDATER.compareAndSet(this, n3 = this.unwritable, n2 = n3 | 1)) {
            }
            if (n3 != 0) break block1;
            this.fireChannelWritabilityChanged(bl2);
        }
    }

    private void fireChannelWritabilityChanged(boolean bl2) {
        final ChannelPipeline channelPipeline = this.channel.pipeline();
        if (bl2) {
            Runnable runnable = this.fireChannelWritabilityChangedTask;
            if (runnable == null) {
                this.fireChannelWritabilityChangedTask = runnable = new Runnable(){

                    @Override
                    public void run() {
                        channelPipeline.fireChannelWritabilityChanged();
                    }
                };
            }
            this.channel.eventLoop().execute(runnable);
        } else {
            channelPipeline.fireChannelWritabilityChanged();
        }
    }

    public boolean isEmpty() {
        return this.flushed == 0;
    }

    void failFlushed(Throwable throwable, boolean bl2) {
        if (this.inFail) {
            return;
        }
        try {
            this.inFail = true;
            while (this.remove0(throwable, bl2)) {
            }
        }
        finally {
            this.inFail = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(final Throwable throwable, final boolean bl2) {
        if (this.inFail) {
            this.channel.eventLoop().execute(new Runnable(){

                @Override
                public void run() {
                    ChannelOutboundBuffer.this.close(throwable, bl2);
                }
            });
            return;
        }
        this.inFail = true;
        if (!bl2 && this.channel.isOpen()) {
            throw new IllegalStateException("close() must be invoked after the channel is closed.");
        }
        if (!this.isEmpty()) {
            throw new IllegalStateException("close() must be invoked after all flushed writes are handled.");
        }
        try {
            for (Entry entry = this.unflushedEntry; entry != null; entry = entry.unguardedRecycleAndGetNext()) {
                int n2 = entry.pendingSize;
                TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, -n2);
                if (entry.cancelled) continue;
                ReferenceCountUtil.safeRelease(entry.msg);
                ChannelOutboundBuffer.safeFail(entry.promise, throwable);
            }
        }
        finally {
            this.inFail = false;
        }
        this.clearNioBuffers();
    }

    void close(ClosedChannelException closedChannelException) {
        this.close(closedChannelException, false);
    }

    private static void safeSuccess(ChannelPromise channelPromise) {
        PromiseNotificationUtil.trySuccess(channelPromise, null, channelPromise instanceof VoidChannelPromise ? null : logger);
    }

    private static void safeFail(ChannelPromise channelPromise, Throwable throwable) {
        PromiseNotificationUtil.tryFailure(channelPromise, throwable, channelPromise instanceof VoidChannelPromise ? null : logger);
    }

    public long totalPendingWriteBytes() {
        return this.totalPendingSize;
    }

    private boolean isFlushedEntry(Entry entry) {
        return entry != null && entry != this.unflushedEntry;
    }

    static final class Entry {
        private static final ObjectPool<Entry> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<Entry>(){

            @Override
            public Entry newObject(ObjectPool.Handle<Entry> handle) {
                return new Entry(handle);
            }
        });
        private final Recycler.EnhancedHandle<Entry> handle;
        Entry next;
        Object msg;
        ByteBuffer[] bufs;
        ByteBuffer buf;
        ChannelPromise promise;
        long progress;
        long total;
        int pendingSize;
        int count = -1;
        boolean cancelled;

        private Entry(ObjectPool.Handle<Entry> handle) {
            this.handle = (Recycler.EnhancedHandle)handle;
        }

        static Entry newInstance(Object object, int n2, long l2, ChannelPromise channelPromise) {
            Entry entry = RECYCLER.get();
            entry.msg = object;
            entry.pendingSize = n2 + CHANNEL_OUTBOUND_BUFFER_ENTRY_OVERHEAD;
            entry.total = l2;
            entry.promise = channelPromise;
            return entry;
        }

        int cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                int n2 = this.pendingSize;
                ReferenceCountUtil.safeRelease(this.msg);
                this.msg = Unpooled.EMPTY_BUFFER;
                this.pendingSize = 0;
                this.total = 0L;
                this.progress = 0L;
                this.bufs = null;
                this.buf = null;
                return n2;
            }
            return 0;
        }

        void unguardedRecycle() {
            this.next = null;
            this.bufs = null;
            this.buf = null;
            this.msg = null;
            this.promise = null;
            this.progress = 0L;
            this.total = 0L;
            this.pendingSize = 0;
            this.count = -1;
            this.cancelled = false;
            this.handle.unguardedRecycle(this);
        }

        Entry unguardedRecycleAndGetNext() {
            Entry entry = this.next;
            this.unguardedRecycle();
            return entry;
        }
    }
}

