/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Strings;
import com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.DirectExecutor;
import com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.LazyLogger;
import com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.ListenableFuture;
import com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.NullnessCasts;
import com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.OverflowAvoidingLockSupport;
import com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.internal.InternalFutureFailureAccess;
import com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.internal.InternalFutures;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import sun.misc.Unsafe;

public abstract class AbstractFuture<V>
extends InternalFutureFailureAccess
implements ListenableFuture<V> {
    static final boolean GENERATE_CANCELLATION_CAUSES;
    static final LazyLogger log;
    private static final AtomicHelper ATOMIC_HELPER;
    private static final Object NULL;
    private volatile Object value;
    private volatile Listener listeners;
    private volatile Waiter waiters;

    /*
     * Unable to fully structure code
     */
    private void removeWaiter(Waiter var1_1) {
        var1_1.thread = null;
        block0: while (true) {
            var2_2 = null;
            var3_3 = this.waiters;
            if (var3_3 == Waiter.TOMBSTONE) {
                return;
            }
            while (var3_3 != null) {
                var4_4 = var3_3.next;
                if (var3_3.thread != null) {
                    var2_2 = var3_3;
                } else if (var2_2 != null) {
                    var2_2.next = var4_4;
                    if (var2_2.thread == null) {
                        continue block0;
                    }
                } else {
                    if (AbstractFuture.ATOMIC_HELPER.casWaiters(this, var3_3, var4_4)) ** break;
                    continue block0;
                }
                var3_3 = var4_4;
            }
            break;
        }
    }

    protected AbstractFuture() {
    }

    @Override
    public V get(long l2, TimeUnit timeUnit) throws InterruptedException, TimeoutException, ExecutionException {
        Object object;
        Object object2;
        long l3;
        Object object3;
        long l4;
        block15: {
            long l5;
            l4 = l5 = timeUnit.toNanos(l2);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            object3 = this.value;
            if (object3 != null & !(object3 instanceof SetFuture)) {
                return this.getDoneValue(object3);
            }
            long l6 = l3 = l4 > 0L ? System.nanoTime() + l4 : 0L;
            if (l4 >= 1000L) {
                object2 = this.waiters;
                if (object2 != Waiter.TOMBSTONE) {
                    object = new Waiter();
                    do {
                        ((Waiter)object).setNext((Waiter)object2);
                        if (!ATOMIC_HELPER.casWaiters(this, (Waiter)object2, (Waiter)object)) continue;
                        do {
                            OverflowAvoidingLockSupport.parkNanos(this, l4);
                            if (Thread.interrupted()) {
                                this.removeWaiter((Waiter)object);
                                throw new InterruptedException();
                            }
                            object3 = this.value;
                            if (!(object3 != null & !(object3 instanceof SetFuture))) continue;
                            return this.getDoneValue(object3);
                        } while ((l4 = l3 - System.nanoTime()) >= 1000L);
                        this.removeWaiter((Waiter)object);
                        break block15;
                    } while ((object2 = this.waiters) != Waiter.TOMBSTONE);
                }
                return this.getDoneValue(Objects.requireNonNull(this.value));
            }
        }
        while (l4 > 0L) {
            object3 = this.value;
            if (object3 != null & !(object3 instanceof SetFuture)) {
                return this.getDoneValue(object3);
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            l4 = l3 - System.nanoTime();
        }
        object2 = this.toString();
        object = timeUnit.toString().toLowerCase(Locale.ROOT);
        String string = "Waited " + l2 + " " + timeUnit.toString().toLowerCase(Locale.ROOT);
        if (l4 + 1000L < 0L) {
            boolean bl2;
            string = string + " (plus ";
            long l7 = -l4;
            long l8 = timeUnit.convert(l7, TimeUnit.NANOSECONDS);
            long l9 = l7 - timeUnit.toNanos(l8);
            boolean bl3 = bl2 = l8 == 0L || l9 > 1000L;
            if (l8 > 0L) {
                string = string + l8 + " " + (String)object;
                if (bl2) {
                    string = string + ",";
                }
                string = string + " ";
            }
            if (bl2) {
                string = string + l9 + " nanoseconds ";
            }
            string = string + "delay)";
        }
        if (this.isDone()) {
            throw new TimeoutException(string + " but future completed as timeout expired");
        }
        throw new TimeoutException(string + " for " + (String)object2);
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.value;
        if (object != null & !(object instanceof SetFuture)) {
            return this.getDoneValue(object);
        }
        Waiter waiter = this.waiters;
        if (waiter != Waiter.TOMBSTONE) {
            Waiter waiter2 = new Waiter();
            do {
                waiter2.setNext(waiter);
                if (!ATOMIC_HELPER.casWaiters(this, waiter, waiter2)) continue;
                do {
                    LockSupport.park(this);
                    if (!Thread.interrupted()) continue;
                    this.removeWaiter(waiter2);
                    throw new InterruptedException();
                } while (!((object = this.value) != null & !(object instanceof SetFuture)));
                return this.getDoneValue(object);
            } while ((waiter = this.waiters) != Waiter.TOMBSTONE);
        }
        return this.getDoneValue(Objects.requireNonNull(this.value));
    }

    private V getDoneValue(Object object) throws ExecutionException {
        if (object instanceof Cancellation) {
            throw AbstractFuture.cancellationExceptionWithCause("Task was cancelled.", ((Cancellation)object).cause);
        }
        if (object instanceof Failure) {
            throw new ExecutionException(((Failure)object).exception);
        }
        if (object == NULL) {
            return (V)NullnessCasts.uncheckedNull();
        }
        Object object2 = object;
        return (V)object2;
    }

    @Override
    public boolean isDone() {
        Object object = this.value;
        return object != null & !(object instanceof SetFuture);
    }

    @Override
    public boolean isCancelled() {
        Object object = this.value;
        return object instanceof Cancellation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean cancel(boolean bl2) {
        Object object = this.value;
        boolean bl3 = false;
        if (!(object == null | object instanceof SetFuture)) return bl3;
        Cancellation cancellation = GENERATE_CANCELLATION_CAUSES ? new Cancellation(bl2, new CancellationException("Future.cancel() was called.")) : Objects.requireNonNull(bl2 ? Cancellation.CAUSELESS_INTERRUPTED : Cancellation.CAUSELESS_CANCELLED);
        AbstractFuture abstractFuture = this;
        while (true) {
            if (ATOMIC_HELPER.casValue(abstractFuture, object, cancellation)) {
                bl3 = true;
                AbstractFuture.complete(abstractFuture, bl2);
                if (!(object instanceof SetFuture)) return bl3;
                ListenableFuture listenableFuture = ((SetFuture)object).future;
                if (listenableFuture instanceof Trusted) {
                    AbstractFuture abstractFuture2 = (AbstractFuture)listenableFuture;
                    object = abstractFuture2.value;
                    if (!(object == null | object instanceof SetFuture)) return bl3;
                    abstractFuture = abstractFuture2;
                    continue;
                }
                listenableFuture.cancel(bl2);
                return bl3;
            }
            object = abstractFuture.value;
            if (!(object instanceof SetFuture)) return bl3;
        }
    }

    protected void interruptTask() {
    }

    protected final boolean wasInterrupted() {
        Object object = this.value;
        return object instanceof Cancellation && ((Cancellation)object).wasInterrupted;
    }

    @Override
    public void addListener(Runnable runnable, Executor executor) {
        Listener listener;
        Preconditions.checkNotNull(runnable, "Runnable was null.");
        Preconditions.checkNotNull(executor, "Executor was null.");
        if (!this.isDone() && (listener = this.listeners) != Listener.TOMBSTONE) {
            Listener listener2 = new Listener(runnable, executor);
            do {
                listener2.next = listener;
                if (!ATOMIC_HELPER.casListeners(this, listener, listener2)) continue;
                return;
            } while ((listener = this.listeners) != Listener.TOMBSTONE);
        }
        AbstractFuture.executeListener(runnable, executor);
    }

    protected boolean set(V v2) {
        Object object;
        Object object2 = object = v2 == null ? NULL : v2;
        if (ATOMIC_HELPER.casValue(this, null, object)) {
            AbstractFuture.complete(this, false);
            return true;
        }
        return false;
    }

    protected boolean setException(Throwable throwable) {
        Failure failure = new Failure(Preconditions.checkNotNull(throwable));
        if (ATOMIC_HELPER.casValue(this, null, failure)) {
            AbstractFuture.complete(this, false);
            return true;
        }
        return false;
    }

    protected boolean setFuture(ListenableFuture<? extends V> listenableFuture) {
        Preconditions.checkNotNull(listenableFuture);
        Object object = this.value;
        if (object == null) {
            if (listenableFuture.isDone()) {
                Object object2 = AbstractFuture.getFutureValue(listenableFuture);
                if (ATOMIC_HELPER.casValue(this, null, object2)) {
                    AbstractFuture.complete(this, false);
                    return true;
                }
                return false;
            }
            SetFuture<? extends V> setFuture = new SetFuture<V>(this, listenableFuture);
            if (ATOMIC_HELPER.casValue(this, null, setFuture)) {
                try {
                    listenableFuture.addListener(setFuture, DirectExecutor.INSTANCE);
                }
                catch (Throwable throwable) {
                    Failure failure;
                    try {
                        failure = new Failure(throwable);
                    }
                    catch (Error | Exception throwable2) {
                        failure = Failure.FALLBACK_INSTANCE;
                    }
                    boolean bl2 = ATOMIC_HELPER.casValue(this, setFuture, failure);
                }
                return true;
            }
            object = this.value;
        }
        if (object instanceof Cancellation) {
            listenableFuture.cancel(((Cancellation)object).wasInterrupted);
        }
        return false;
    }

    private static Object getFutureValue(ListenableFuture<?> listenableFuture) {
        boolean bl2;
        Throwable throwable;
        if (listenableFuture instanceof Trusted) {
            Object object = ((AbstractFuture)listenableFuture).value;
            if (object instanceof Cancellation) {
                Cancellation cancellation = (Cancellation)object;
                if (cancellation.wasInterrupted) {
                    object = cancellation.cause != null ? new Cancellation(false, cancellation.cause) : Cancellation.CAUSELESS_CANCELLED;
                }
            }
            return Objects.requireNonNull(object);
        }
        if (listenableFuture instanceof InternalFutureFailureAccess && (throwable = InternalFutures.tryInternalFastPathGetFailure((InternalFutureFailureAccess)((Object)listenableFuture))) != null) {
            return new Failure(throwable);
        }
        if (!GENERATE_CANCELLATION_CAUSES & (bl2 = listenableFuture.isCancelled())) {
            return Objects.requireNonNull(Cancellation.CAUSELESS_CANCELLED);
        }
        try {
            Object obj = AbstractFuture.getUninterruptibly(listenableFuture);
            if (bl2) {
                return new Cancellation(false, new IllegalArgumentException("get() did not throw CancellationException, despite reporting isCancelled() == true: " + listenableFuture));
            }
            return obj == null ? NULL : obj;
        }
        catch (ExecutionException executionException) {
            if (bl2) {
                return new Cancellation(false, new IllegalArgumentException("get() did not throw CancellationException, despite reporting isCancelled() == true: " + listenableFuture, executionException));
            }
            return new Failure(executionException.getCause());
        }
        catch (CancellationException cancellationException) {
            if (!bl2) {
                return new Failure(new IllegalArgumentException("get() threw CancellationException, despite reporting isCancelled() == false: " + listenableFuture, cancellationException));
            }
            return new Cancellation(false, cancellationException);
        }
        catch (Error | Exception throwable2) {
            return new Failure(throwable2);
        }
    }

    private static <V> V getUninterruptibly(Future<V> future) throws ExecutionException {
        boolean bl2 = false;
        while (true) {
            try {
                V v2 = future.get();
                return v2;
            }
            catch (InterruptedException interruptedException) {
                bl2 = true;
                continue;
            }
            break;
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static void complete(AbstractFuture<?> abstractFuture, boolean bl2) {
        AbstractFuture<Object> abstractFuture2 = abstractFuture;
        Listener listener = null;
        block0: while (true) {
            super.releaseWaiters();
            if (bl2) {
                abstractFuture2.interruptTask();
                bl2 = false;
            }
            abstractFuture2.afterDone();
            listener = super.clearListeners(listener);
            abstractFuture2 = null;
            while (listener != null) {
                Listener listener2 = listener;
                listener = listener.next;
                Runnable runnable = Objects.requireNonNull(listener2.task);
                if (runnable instanceof SetFuture) {
                    Object object;
                    SetFuture setFuture = (SetFuture)runnable;
                    abstractFuture2 = setFuture.owner;
                    if (abstractFuture2.value != setFuture || !ATOMIC_HELPER.casValue(abstractFuture2, setFuture, object = AbstractFuture.getFutureValue(setFuture.future))) continue;
                    continue block0;
                }
                AbstractFuture.executeListener(runnable, Objects.requireNonNull(listener2.executor));
            }
            break;
        }
    }

    protected void afterDone() {
    }

    @Override
    protected final Throwable tryInternalFastPathGetFailure() {
        Object object;
        if (this instanceof Trusted && (object = this.value) instanceof Failure) {
            return ((Failure)object).exception;
        }
        return null;
    }

    final void maybePropagateCancellationTo(Future<?> future) {
        if (future != null & this.isCancelled()) {
            future.cancel(this.wasInterrupted());
        }
    }

    private void releaseWaiters() {
        Waiter waiter;
        Waiter waiter2 = waiter = ATOMIC_HELPER.gasWaiters(this, Waiter.TOMBSTONE);
        while (waiter2 != null) {
            waiter2.unpark();
            waiter2 = waiter2.next;
        }
    }

    private Listener clearListeners(Listener listener) {
        Listener listener2 = ATOMIC_HELPER.gasListeners(this, Listener.TOMBSTONE);
        Listener listener3 = listener;
        while (listener2 != null) {
            Listener listener4 = listener2;
            listener2 = listener2.next;
            listener4.next = listener3;
            listener3 = listener4;
        }
        return listener3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getClass().getName().startsWith("com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.")) {
            stringBuilder.append(this.getClass().getSimpleName());
        } else {
            stringBuilder.append(this.getClass().getName());
        }
        stringBuilder.append('@').append(Integer.toHexString(System.identityHashCode(this))).append("[status=");
        if (this.isCancelled()) {
            stringBuilder.append("CANCELLED");
        } else if (this.isDone()) {
            this.addDoneString(stringBuilder);
        } else {
            this.addPendingString(stringBuilder);
        }
        return stringBuilder.append("]").toString();
    }

    protected String pendingToString() {
        if (this instanceof ScheduledFuture) {
            return "remaining delay=[" + ((ScheduledFuture)((Object)this)).getDelay(TimeUnit.MILLISECONDS) + " ms]";
        }
        return null;
    }

    private void addPendingString(StringBuilder stringBuilder) {
        int n2 = stringBuilder.length();
        stringBuilder.append("PENDING");
        Object object = this.value;
        if (object instanceof SetFuture) {
            stringBuilder.append(", setFuture=[");
            this.appendUserObject(stringBuilder, ((SetFuture)object).future);
            stringBuilder.append("]");
        } else {
            String string;
            try {
                string = Strings.emptyToNull(this.pendingToString());
            }
            catch (Exception | StackOverflowError throwable) {
                string = "Exception thrown from implementation: " + throwable.getClass();
            }
            if (string != null) {
                stringBuilder.append(", info=[").append(string).append("]");
            }
        }
        if (this.isDone()) {
            stringBuilder.delete(n2, stringBuilder.length());
            this.addDoneString(stringBuilder);
        }
    }

    private void addDoneString(StringBuilder stringBuilder) {
        try {
            V v2 = AbstractFuture.getUninterruptibly(this);
            stringBuilder.append("SUCCESS, result=[");
            this.appendResultObject(stringBuilder, v2);
            stringBuilder.append("]");
        }
        catch (ExecutionException executionException) {
            stringBuilder.append("FAILURE, cause=[").append(executionException.getCause()).append("]");
        }
        catch (CancellationException cancellationException) {
            stringBuilder.append("CANCELLED");
        }
        catch (Exception exception) {
            stringBuilder.append("UNKNOWN, cause=[").append(exception.getClass()).append(" thrown from get()]");
        }
    }

    private void appendResultObject(StringBuilder stringBuilder, Object object) {
        if (object == null) {
            stringBuilder.append("null");
        } else if (object == this) {
            stringBuilder.append("this future");
        } else {
            stringBuilder.append(object.getClass().getName()).append("@").append(Integer.toHexString(System.identityHashCode(object)));
        }
    }

    private void appendUserObject(StringBuilder stringBuilder, Object object) {
        try {
            if (object == this) {
                stringBuilder.append("this future");
            } else {
                stringBuilder.append(object);
            }
        }
        catch (Exception | StackOverflowError throwable) {
            stringBuilder.append("Exception thrown from implementation: ").append(throwable.getClass());
        }
    }

    private static void executeListener(Runnable runnable, Executor executor) {
        try {
            executor.execute(runnable);
        }
        catch (Exception exception) {
            log.get().log(Level.SEVERE, "RuntimeException while executing runnable " + runnable + " with executor " + executor, exception);
        }
    }

    private static CancellationException cancellationExceptionWithCause(String string, Throwable throwable) {
        CancellationException cancellationException = new CancellationException(string);
        cancellationException.initCause(throwable);
        return cancellationException;
    }

    static {
        AtomicHelper atomicHelper;
        boolean bl2;
        try {
            bl2 = Boolean.parseBoolean(System.getProperty("guava.concurrent.generate_cancellation_cause", "false"));
        }
        catch (SecurityException securityException) {
            bl2 = false;
        }
        GENERATE_CANCELLATION_CAUSES = bl2;
        log = new LazyLogger(AbstractFuture.class);
        Throwable throwable = null;
        Throwable throwable2 = null;
        try {
            atomicHelper = new UnsafeAtomicHelper();
        }
        catch (Error | Exception throwable3) {
            throwable = throwable3;
            try {
                atomicHelper = new SafeAtomicHelper(AtomicReferenceFieldUpdater.newUpdater(Waiter.class, Thread.class, "thread"), AtomicReferenceFieldUpdater.newUpdater(Waiter.class, Waiter.class, "next"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, Waiter.class, "waiters"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, Listener.class, "listeners"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, Object.class, "value"));
            }
            catch (Error | Exception throwable4) {
                throwable2 = throwable4;
                atomicHelper = new SynchronizedHelper();
            }
        }
        ATOMIC_HELPER = atomicHelper;
        Class<LockSupport> clazz = LockSupport.class;
        if (throwable2 != null) {
            log.get().log(Level.SEVERE, "UnsafeAtomicHelper is broken!", throwable);
            log.get().log(Level.SEVERE, "SafeAtomicHelper is broken!", throwable2);
        }
        NULL = new Object();
    }

    private static final class Listener {
        static final Listener TOMBSTONE = new Listener();
        final Runnable task;
        final Executor executor;
        Listener next;

        Listener(Runnable runnable, Executor executor) {
            this.task = runnable;
            this.executor = executor;
        }

        Listener() {
            this.task = null;
            this.executor = null;
        }
    }

    private static final class Waiter {
        static final Waiter TOMBSTONE = new Waiter(false);
        volatile Thread thread;
        volatile Waiter next;

        Waiter(boolean bl2) {
        }

        Waiter() {
            ATOMIC_HELPER.putThread(this, Thread.currentThread());
        }

        void setNext(Waiter waiter) {
            ATOMIC_HELPER.putNext(this, waiter);
        }

        void unpark() {
            Thread thread = this.thread;
            if (thread != null) {
                this.thread = null;
                LockSupport.unpark(thread);
            }
        }
    }

    private static abstract class AtomicHelper {
        private AtomicHelper() {
        }

        abstract void putThread(Waiter var1, Thread var2);

        abstract void putNext(Waiter var1, Waiter var2);

        abstract boolean casWaiters(AbstractFuture<?> var1, Waiter var2, Waiter var3);

        abstract boolean casListeners(AbstractFuture<?> var1, Listener var2, Listener var3);

        abstract Waiter gasWaiters(AbstractFuture<?> var1, Waiter var2);

        abstract Listener gasListeners(AbstractFuture<?> var1, Listener var2);

        abstract boolean casValue(AbstractFuture<?> var1, Object var2, Object var3);
    }

    private static final class SetFuture<V>
    implements Runnable {
        final AbstractFuture<V> owner;
        final ListenableFuture<? extends V> future;

        SetFuture(AbstractFuture<V> abstractFuture, ListenableFuture<? extends V> listenableFuture) {
            this.owner = abstractFuture;
            this.future = listenableFuture;
        }

        @Override
        public void run() {
            if (((AbstractFuture)this.owner).value != this) {
                return;
            }
            Object object = AbstractFuture.getFutureValue(this.future);
            if (ATOMIC_HELPER.casValue(this.owner, this, object)) {
                AbstractFuture.complete((AbstractFuture)this.owner, false);
            }
        }
    }

    private static final class Cancellation {
        static final Cancellation CAUSELESS_INTERRUPTED;
        static final Cancellation CAUSELESS_CANCELLED;
        final boolean wasInterrupted;
        final Throwable cause;

        Cancellation(boolean bl2, Throwable throwable) {
            this.wasInterrupted = bl2;
            this.cause = throwable;
        }

        static {
            if (GENERATE_CANCELLATION_CAUSES) {
                CAUSELESS_CANCELLED = null;
                CAUSELESS_INTERRUPTED = null;
            } else {
                CAUSELESS_CANCELLED = new Cancellation(false, null);
                CAUSELESS_INTERRUPTED = new Cancellation(true, null);
            }
        }
    }

    private static final class Failure {
        static final Failure FALLBACK_INSTANCE = new Failure(new Throwable("Failure occurred while trying to finish a future."){

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        });
        final Throwable exception;

        Failure(Throwable throwable) {
            this.exception = Preconditions.checkNotNull(throwable);
        }
    }

    static interface Trusted<V>
    extends ListenableFuture<V> {
    }

    private static final class UnsafeAtomicHelper
    extends AtomicHelper {
        static final Unsafe UNSAFE;
        static final long LISTENERS_OFFSET;
        static final long WAITERS_OFFSET;
        static final long VALUE_OFFSET;
        static final long WAITER_THREAD_OFFSET;
        static final long WAITER_NEXT_OFFSET;

        private UnsafeAtomicHelper() {
        }

        @Override
        void putThread(Waiter waiter, Thread thread) {
            UNSAFE.putObject(waiter, WAITER_THREAD_OFFSET, thread);
        }

        @Override
        void putNext(Waiter waiter, Waiter waiter2) {
            UNSAFE.putObject(waiter, WAITER_NEXT_OFFSET, waiter2);
        }

        @Override
        boolean casWaiters(AbstractFuture<?> abstractFuture, Waiter waiter, Waiter waiter2) {
            return UNSAFE.compareAndSwapObject(abstractFuture, WAITERS_OFFSET, waiter, waiter2);
        }

        @Override
        boolean casListeners(AbstractFuture<?> abstractFuture, Listener listener, Listener listener2) {
            return UNSAFE.compareAndSwapObject(abstractFuture, LISTENERS_OFFSET, listener, listener2);
        }

        @Override
        Listener gasListeners(AbstractFuture<?> abstractFuture, Listener listener) {
            return (Listener)UNSAFE.getAndSetObject(abstractFuture, LISTENERS_OFFSET, listener);
        }

        @Override
        Waiter gasWaiters(AbstractFuture<?> abstractFuture, Waiter waiter) {
            return (Waiter)UNSAFE.getAndSetObject(abstractFuture, WAITERS_OFFSET, waiter);
        }

        @Override
        boolean casValue(AbstractFuture<?> abstractFuture, Object object, Object object2) {
            return UNSAFE.compareAndSwapObject(abstractFuture, VALUE_OFFSET, object, object2);
        }

        static {
            Unsafe unsafe = null;
            try {
                unsafe = Unsafe.getUnsafe();
            }
            catch (SecurityException securityException) {
                try {
                    unsafe = AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                        @Override
                        public Unsafe run() throws Exception {
                            Class<Unsafe> clazz = Unsafe.class;
                            for (Field field : clazz.getDeclaredFields()) {
                                field.setAccessible(true);
                                Object object = field.get(null);
                                if (!clazz.isInstance(object)) continue;
                                return (Unsafe)clazz.cast(object);
                            }
                            throw new NoSuchFieldError("the Unsafe");
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw new RuntimeException("Could not initialize intrinsics", privilegedActionException.getCause());
                }
            }
            try {
                Class<AbstractFuture> clazz = AbstractFuture.class;
                WAITERS_OFFSET = unsafe.objectFieldOffset(clazz.getDeclaredField("waiters"));
                LISTENERS_OFFSET = unsafe.objectFieldOffset(clazz.getDeclaredField("listeners"));
                VALUE_OFFSET = unsafe.objectFieldOffset(clazz.getDeclaredField("value"));
                WAITER_THREAD_OFFSET = unsafe.objectFieldOffset(Waiter.class.getDeclaredField("thread"));
                WAITER_NEXT_OFFSET = unsafe.objectFieldOffset(Waiter.class.getDeclaredField("next"));
                UNSAFE = unsafe;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException);
            }
        }
    }

    private static final class SafeAtomicHelper
    extends AtomicHelper {
        final AtomicReferenceFieldUpdater<Waiter, Thread> waiterThreadUpdater;
        final AtomicReferenceFieldUpdater<Waiter, Waiter> waiterNextUpdater;
        final AtomicReferenceFieldUpdater<? super AbstractFuture<?>, Waiter> waitersUpdater;
        final AtomicReferenceFieldUpdater<? super AbstractFuture<?>, Listener> listenersUpdater;
        final AtomicReferenceFieldUpdater<? super AbstractFuture<?>, Object> valueUpdater;

        SafeAtomicHelper(AtomicReferenceFieldUpdater<Waiter, Thread> atomicReferenceFieldUpdater, AtomicReferenceFieldUpdater<Waiter, Waiter> atomicReferenceFieldUpdater2, AtomicReferenceFieldUpdater<? super AbstractFuture<?>, Waiter> atomicReferenceFieldUpdater3, AtomicReferenceFieldUpdater<? super AbstractFuture<?>, Listener> atomicReferenceFieldUpdater4, AtomicReferenceFieldUpdater<? super AbstractFuture<?>, Object> atomicReferenceFieldUpdater5) {
            this.waiterThreadUpdater = atomicReferenceFieldUpdater;
            this.waiterNextUpdater = atomicReferenceFieldUpdater2;
            this.waitersUpdater = atomicReferenceFieldUpdater3;
            this.listenersUpdater = atomicReferenceFieldUpdater4;
            this.valueUpdater = atomicReferenceFieldUpdater5;
        }

        @Override
        void putThread(Waiter waiter, Thread thread) {
            this.waiterThreadUpdater.lazySet(waiter, thread);
        }

        @Override
        void putNext(Waiter waiter, Waiter waiter2) {
            this.waiterNextUpdater.lazySet(waiter, waiter2);
        }

        @Override
        boolean casWaiters(AbstractFuture<?> abstractFuture, Waiter waiter, Waiter waiter2) {
            return this.waitersUpdater.compareAndSet(abstractFuture, waiter, waiter2);
        }

        @Override
        boolean casListeners(AbstractFuture<?> abstractFuture, Listener listener, Listener listener2) {
            return this.listenersUpdater.compareAndSet(abstractFuture, listener, listener2);
        }

        @Override
        Listener gasListeners(AbstractFuture<?> abstractFuture, Listener listener) {
            return this.listenersUpdater.getAndSet(abstractFuture, listener);
        }

        @Override
        Waiter gasWaiters(AbstractFuture<?> abstractFuture, Waiter waiter) {
            return this.waitersUpdater.getAndSet(abstractFuture, waiter);
        }

        @Override
        boolean casValue(AbstractFuture<?> abstractFuture, Object object, Object object2) {
            return this.valueUpdater.compareAndSet(abstractFuture, object, object2);
        }
    }

    private static final class SynchronizedHelper
    extends AtomicHelper {
        private SynchronizedHelper() {
        }

        @Override
        void putThread(Waiter waiter, Thread thread) {
            waiter.thread = thread;
        }

        @Override
        void putNext(Waiter waiter, Waiter waiter2) {
            waiter.next = waiter2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean casWaiters(AbstractFuture<?> abstractFuture, Waiter waiter, Waiter waiter2) {
            AbstractFuture<?> abstractFuture2 = abstractFuture;
            synchronized (abstractFuture2) {
                if (((AbstractFuture)abstractFuture).waiters == waiter) {
                    ((AbstractFuture)abstractFuture).waiters = waiter2;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean casListeners(AbstractFuture<?> abstractFuture, Listener listener, Listener listener2) {
            AbstractFuture<?> abstractFuture2 = abstractFuture;
            synchronized (abstractFuture2) {
                if (((AbstractFuture)abstractFuture).listeners == listener) {
                    ((AbstractFuture)abstractFuture).listeners = listener2;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Listener gasListeners(AbstractFuture<?> abstractFuture, Listener listener) {
            AbstractFuture<?> abstractFuture2 = abstractFuture;
            synchronized (abstractFuture2) {
                Listener listener2 = ((AbstractFuture)abstractFuture).listeners;
                if (listener2 != listener) {
                    ((AbstractFuture)abstractFuture).listeners = listener;
                }
                return listener2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Waiter gasWaiters(AbstractFuture<?> abstractFuture, Waiter waiter) {
            AbstractFuture<?> abstractFuture2 = abstractFuture;
            synchronized (abstractFuture2) {
                Waiter waiter2 = ((AbstractFuture)abstractFuture).waiters;
                if (waiter2 != waiter) {
                    ((AbstractFuture)abstractFuture).waiters = waiter;
                }
                return waiter2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean casValue(AbstractFuture<?> abstractFuture, Object object, Object object2) {
            AbstractFuture<?> abstractFuture2 = abstractFuture;
            synchronized (abstractFuture2) {
                if (((AbstractFuture)abstractFuture).value == object) {
                    ((AbstractFuture)abstractFuture).value = object2;
                    return true;
                }
                return false;
            }
        }
    }

    static abstract class TrustedFuture<V>
    extends AbstractFuture<V>
    implements Trusted<V> {
        TrustedFuture() {
        }

        @Override
        public final V get() throws InterruptedException, ExecutionException {
            return super.get();
        }

        @Override
        public final V get(long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return super.get(l2, timeUnit);
        }

        @Override
        public final boolean isDone() {
            return super.isDone();
        }

        @Override
        public final boolean isCancelled() {
            return super.isCancelled();
        }

        @Override
        public final void addListener(Runnable runnable, Executor executor) {
            super.addListener(runnable, executor);
        }

        @Override
        public final boolean cancel(boolean bl2) {
            return super.cancel(bl2);
        }
    }
}

