/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.graph;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.AbstractIterator;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.graph.BaseGraph;
import com.gradle.maven.extension.internal.dep.com.google.common.graph.Network;
import com.gradle.maven.extension.internal.dep.com.google.common.graph.SuccessorsFunction;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;

public abstract class Traverser<N> {
    private final SuccessorsFunction<N> successorFunction;

    private Traverser(SuccessorsFunction<N> successorsFunction) {
        this.successorFunction = Preconditions.checkNotNull(successorsFunction);
    }

    public static <N> Traverser<N> forTree(final SuccessorsFunction<N> successorsFunction) {
        if (successorsFunction instanceof BaseGraph) {
            Preconditions.checkArgument(((BaseGraph)successorsFunction).isDirected(), "Undirected graphs can never be trees.");
        }
        if (successorsFunction instanceof Network) {
            Preconditions.checkArgument(((Network)successorsFunction).isDirected(), "Undirected networks can never be trees.");
        }
        return new Traverser<N>(successorsFunction){

            @Override
            Traversal<N> newTraversal() {
                return Traversal.inTree(successorsFunction);
            }
        };
    }

    public final Iterable<N> depthFirstPreOrder(N n2) {
        return this.depthFirstPreOrder((Iterable<? extends N>)ImmutableSet.of(n2));
    }

    public final Iterable<N> depthFirstPreOrder(Iterable<? extends N> iterable) {
        final ImmutableSet<? extends N> immutableSet = this.validate(iterable);
        return new Iterable<N>(){
            final /* synthetic */ Traverser this$0;
            {
                this.this$0 = traverser;
            }

            @Override
            public Iterator<N> iterator() {
                return this.this$0.newTraversal().preOrder(immutableSet.iterator());
            }
        };
    }

    abstract Traversal<N> newTraversal();

    private ImmutableSet<N> validate(Iterable<? extends N> iterable) {
        ImmutableSet immutableSet = ImmutableSet.copyOf(iterable);
        for (Object e2 : immutableSet) {
            this.successorFunction.successors(e2);
        }
        return immutableSet;
    }

    private static enum InsertionOrder {
        FRONT{

            @Override
            <T> void insertInto(Deque<T> deque, T t2) {
                deque.addFirst(t2);
            }
        }
        ,
        BACK{

            @Override
            <T> void insertInto(Deque<T> deque, T t2) {
                deque.addLast(t2);
            }
        };


        abstract <T> void insertInto(Deque<T> var1, T var2);
    }

    private static abstract class Traversal<N> {
        final SuccessorsFunction<N> successorFunction;

        Traversal(SuccessorsFunction<N> successorsFunction) {
            this.successorFunction = successorsFunction;
        }

        static <N> Traversal<N> inGraph(SuccessorsFunction<N> successorsFunction) {
            final HashSet hashSet = new HashSet();
            return new Traversal<N>(successorsFunction){

                @Override
                N visitNext(Deque<Iterator<? extends N>> deque) {
                    Iterator iterator = deque.getFirst();
                    while (iterator.hasNext()) {
                        Object n2 = iterator.next();
                        Objects.requireNonNull(n2);
                        if (!hashSet.add(n2)) continue;
                        return n2;
                    }
                    deque.removeFirst();
                    return null;
                }
            };
        }

        static <N> Traversal<N> inTree(SuccessorsFunction<N> successorsFunction) {
            return new Traversal<N>((SuccessorsFunction)successorsFunction){

                @Override
                N visitNext(Deque<Iterator<? extends N>> deque) {
                    Iterator iterator = deque.getFirst();
                    if (iterator.hasNext()) {
                        return Preconditions.checkNotNull(iterator.next());
                    }
                    deque.removeFirst();
                    return null;
                }
            };
        }

        final Iterator<N> preOrder(Iterator<? extends N> iterator) {
            return this.topDown(iterator, InsertionOrder.FRONT);
        }

        private Iterator<N> topDown(Iterator<? extends N> iterator, final InsertionOrder insertionOrder) {
            final ArrayDeque<Iterator<? extends N>> arrayDeque = new ArrayDeque<Iterator<? extends N>>();
            arrayDeque.add(iterator);
            return new AbstractIterator<N>(this){
                final /* synthetic */ Traversal this$0;
                {
                    this.this$0 = traversal;
                }

                @Override
                protected N computeNext() {
                    do {
                        Object n2;
                        if ((n2 = this.this$0.visitNext(arrayDeque)) == null) continue;
                        Iterator iterator = this.this$0.successorFunction.successors(n2).iterator();
                        if (iterator.hasNext()) {
                            insertionOrder.insertInto(arrayDeque, iterator);
                        }
                        return n2;
                    } while (!arrayDeque.isEmpty());
                    return this.endOfData();
                }
            };
        }

        abstract N visitNext(Deque<Iterator<? extends N>> var1);
    }
}

