/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.CollectPreconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableBiMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.BiConsumer;

final class SingletonImmutableBiMap<K, V>
extends ImmutableBiMap<K, V> {
    final transient K singleKey;
    final transient V singleValue;
    private final transient ImmutableBiMap<V, K> inverse;
    private transient ImmutableBiMap<V, K> lazyInverse;

    SingletonImmutableBiMap(K k2, V v2) {
        CollectPreconditions.checkEntryNotNull(k2, v2);
        this.singleKey = k2;
        this.singleValue = v2;
        this.inverse = null;
    }

    private SingletonImmutableBiMap(K k2, V v2, ImmutableBiMap<V, K> immutableBiMap) {
        this.singleKey = k2;
        this.singleValue = v2;
        this.inverse = immutableBiMap;
    }

    @Override
    public V get(Object object) {
        return this.singleKey.equals(object) ? (V)this.singleValue : null;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        Preconditions.checkNotNull(biConsumer).accept(this.singleKey, this.singleValue);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.singleKey.equals(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.singleValue.equals(object);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return ImmutableSet.of(Maps.immutableEntry(this.singleKey, this.singleValue));
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return ImmutableSet.of(this.singleKey);
    }

    @Override
    public ImmutableBiMap<V, K> inverse() {
        if (this.inverse != null) {
            return this.inverse;
        }
        ImmutableBiMap<V, K> immutableBiMap = this.lazyInverse;
        if (immutableBiMap == null) {
            this.lazyInverse = new SingletonImmutableBiMap<K, V>(this.singleValue, this.singleKey, this);
            return this.lazyInverse;
        }
        return immutableBiMap;
    }
}

