/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.AbstractIterator;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.CollectPreconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ForwardingSortedSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableCollection;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Iterators;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Maps;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Multiset;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.UnmodifiableIterator;
import com.gradle.maven.extension.internal.dep.com.google.common.math.IntMath;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class Sets {
    public static <E> HashSet<E> newHashSet() {
        return new HashSet();
    }

    public static <E> HashSet<E> newHashSet(E ... EArray) {
        HashSet<E> hashSet = Sets.newHashSetWithExpectedSize(EArray.length);
        Collections.addAll(hashSet, EArray);
        return hashSet;
    }

    public static <E> HashSet<E> newHashSetWithExpectedSize(int n2) {
        return new HashSet(Maps.capacity(n2));
    }

    public static <E> SetView<E> union(final Set<? extends E> set, final Set<? extends E> set2) {
        Preconditions.checkNotNull(set, "set1");
        Preconditions.checkNotNull(set2, "set2");
        return new SetView<E>(){

            @Override
            public int size() {
                int n2 = set.size();
                for (Object e2 : set2) {
                    if (set.contains(e2)) continue;
                    ++n2;
                }
                return n2;
            }

            @Override
            public boolean isEmpty() {
                return set.isEmpty() && set2.isEmpty();
            }

            @Override
            public UnmodifiableIterator<E> iterator() {
                return new AbstractIterator<E>(){
                    final Iterator<? extends E> itr1;
                    final Iterator<? extends E> itr2;
                    {
                        this.itr1 = set.iterator();
                        this.itr2 = set2.iterator();
                    }

                    @Override
                    protected E computeNext() {
                        if (this.itr1.hasNext()) {
                            return this.itr1.next();
                        }
                        while (this.itr2.hasNext()) {
                            Object e2 = this.itr2.next();
                            if (set.contains(e2)) continue;
                            return e2;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public Stream<E> stream() {
                return Stream.concat(set.stream(), set2.stream().filter(object -> !set.contains(object)));
            }

            @Override
            public Stream<E> parallelStream() {
                return (Stream)this.stream().parallel();
            }

            @Override
            public boolean contains(Object object) {
                return set.contains(object) || set2.contains(object);
            }
        };
    }

    public static <E> SetView<E> intersection(final Set<E> set, final Set<?> set2) {
        Preconditions.checkNotNull(set, "set1");
        Preconditions.checkNotNull(set2, "set2");
        return new SetView<E>(){

            @Override
            public UnmodifiableIterator<E> iterator() {
                return new AbstractIterator<E>(){
                    final Iterator<E> itr;
                    {
                        this.itr = set.iterator();
                    }

                    @Override
                    protected E computeNext() {
                        while (this.itr.hasNext()) {
                            Object e2 = this.itr.next();
                            if (!set2.contains(e2)) continue;
                            return e2;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public Stream<E> stream() {
                return set.stream().filter(set2::contains);
            }

            @Override
            public Stream<E> parallelStream() {
                return set.parallelStream().filter(set2::contains);
            }

            @Override
            public int size() {
                int n2 = 0;
                for (Object e2 : set) {
                    if (!set2.contains(e2)) continue;
                    ++n2;
                }
                return n2;
            }

            @Override
            public boolean isEmpty() {
                return Collections.disjoint(set2, set);
            }

            @Override
            public boolean contains(Object object) {
                return set.contains(object) && set2.contains(object);
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                return set.containsAll(collection) && set2.containsAll(collection);
            }
        };
    }

    public static <E> SetView<E> difference(final Set<E> set, final Set<?> set2) {
        Preconditions.checkNotNull(set, "set1");
        Preconditions.checkNotNull(set2, "set2");
        return new SetView<E>(){

            @Override
            public UnmodifiableIterator<E> iterator() {
                return new AbstractIterator<E>(){
                    final Iterator<E> itr;
                    {
                        this.itr = set.iterator();
                    }

                    @Override
                    protected E computeNext() {
                        while (this.itr.hasNext()) {
                            Object e2 = this.itr.next();
                            if (set2.contains(e2)) continue;
                            return e2;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public Stream<E> stream() {
                return set.stream().filter(object -> !set2.contains(object));
            }

            @Override
            public Stream<E> parallelStream() {
                return set.parallelStream().filter(object -> !set2.contains(object));
            }

            @Override
            public int size() {
                int n2 = 0;
                for (Object e2 : set) {
                    if (set2.contains(e2)) continue;
                    ++n2;
                }
                return n2;
            }

            @Override
            public boolean isEmpty() {
                return set2.containsAll(set);
            }

            @Override
            public boolean contains(Object object) {
                return set.contains(object) && !set2.contains(object);
            }
        };
    }

    public static <E> Set<Set<E>> combinations(Set<E> set, final int n2) {
        final ImmutableMap<E, Integer> immutableMap = Maps.indexMap(set);
        CollectPreconditions.checkNonnegative(n2, "size");
        Preconditions.checkArgument(n2 <= immutableMap.size(), "size (%s) must be <= set.size() (%s)", n2, immutableMap.size());
        if (n2 == 0) {
            return ImmutableSet.of(ImmutableSet.of());
        }
        if (n2 == immutableMap.size()) {
            return ImmutableSet.of(immutableMap.keySet());
        }
        return new AbstractSet<Set<E>>(){

            @Override
            public boolean contains(Object object) {
                if (object instanceof Set) {
                    Set set = (Set)object;
                    return set.size() == n2 && ((AbstractCollection)((Object)immutableMap.keySet())).containsAll(set);
                }
                return false;
            }

            @Override
            public Iterator<Set<E>> iterator() {
                return new AbstractIterator<Set<E>>(){
                    final BitSet bits;
                    {
                        this.bits = new BitSet(immutableMap.size());
                    }

                    @Override
                    protected Set<E> computeNext() {
                        if (this.bits.isEmpty()) {
                            this.bits.set(0, n2);
                        } else {
                            int n2 = this.bits.nextSetBit(0);
                            int n3 = this.bits.nextClearBit(n2);
                            if (n3 == immutableMap.size()) {
                                return (Set)this.endOfData();
                            }
                            this.bits.set(0, n3 - n2 - 1);
                            this.bits.clear(n3 - n2 - 1, n3);
                            this.bits.set(n3);
                        }
                        final BitSet bitSet = (BitSet)this.bits.clone();
                        return new AbstractSet<E>(this){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            @Override
                            public boolean contains(Object object) {
                                Integer n2 = (Integer)this.this$1.immutableMap.get(object);
                                return n2 != null && bitSet.get(n2);
                            }

                            @Override
                            public Iterator<E> iterator() {
                                return new AbstractIterator<E>(){
                                    int i = -1;

                                    @Override
                                    protected E computeNext() {
                                        this.i = bitSet.nextSetBit(this.i + 1);
                                        if (this.i == -1) {
                                            return this.endOfData();
                                        }
                                        return ((ImmutableCollection)((Object)this$1.immutableMap.keySet())).asList().get(this.i);
                                    }
                                };
                            }

                            @Override
                            public int size() {
                                return this.this$1.n2;
                            }
                        };
                    }
                };
            }

            @Override
            public int size() {
                return IntMath.binomial(immutableMap.size(), n2);
            }

            @Override
            public String toString() {
                return "Sets.combinations(" + immutableMap.keySet() + ", " + n2 + ")";
            }
        };
    }

    static int hashCodeImpl(Set<?> set) {
        int n2 = 0;
        for (Object obj : set) {
            n2 += obj != null ? obj.hashCode() : 0;
            n2 = ~(~n2);
        }
        return n2;
    }

    static boolean equalsImpl(Set<?> set, Object object) {
        if (set == object) {
            return true;
        }
        if (object instanceof Set) {
            Set set2 = (Set)object;
            try {
                return set.size() == set2.size() && set.containsAll(set2);
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                return false;
            }
        }
        return false;
    }

    public static <E> NavigableSet<E> unmodifiableNavigableSet(NavigableSet<E> navigableSet) {
        if (navigableSet instanceof ImmutableCollection || navigableSet instanceof UnmodifiableNavigableSet) {
            return navigableSet;
        }
        return new UnmodifiableNavigableSet<E>(navigableSet);
    }

    static boolean removeAllImpl(Set<?> set, Iterator<?> iterator) {
        boolean bl2 = false;
        while (iterator.hasNext()) {
            bl2 |= set.remove(iterator.next());
        }
        return bl2;
    }

    static boolean removeAllImpl(Set<?> set, Collection<?> collection) {
        Preconditions.checkNotNull(collection);
        if (collection instanceof Multiset) {
            collection = ((Multiset)collection).elementSet();
        }
        if (collection instanceof Set && collection.size() > set.size()) {
            return Iterators.removeAll(set.iterator(), collection);
        }
        return Sets.removeAllImpl(set, collection.iterator());
    }

    static final class UnmodifiableNavigableSet<E>
    extends ForwardingSortedSet<E>
    implements Serializable,
    NavigableSet<E> {
        private final NavigableSet<E> delegate;
        private final SortedSet<E> unmodifiableDelegate;
        private transient UnmodifiableNavigableSet<E> descendingSet;

        UnmodifiableNavigableSet(NavigableSet<E> navigableSet) {
            this.delegate = Preconditions.checkNotNull(navigableSet);
            this.unmodifiableDelegate = Collections.unmodifiableSortedSet(navigableSet);
        }

        @Override
        protected SortedSet<E> delegate() {
            return this.unmodifiableDelegate;
        }

        @Override
        public boolean removeIf(Predicate<? super E> predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Stream<E> stream() {
            return this.delegate.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.delegate.parallelStream();
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            this.delegate.forEach(consumer);
        }

        @Override
        public E lower(E e2) {
            return this.delegate.lower(e2);
        }

        @Override
        public E floor(E e2) {
            return this.delegate.floor(e2);
        }

        @Override
        public E ceiling(E e2) {
            return this.delegate.ceiling(e2);
        }

        @Override
        public E higher(E e2) {
            return this.delegate.higher(e2);
        }

        @Override
        public E pollFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public E pollLast() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableSet<E> descendingSet() {
            UnmodifiableNavigableSet<E> unmodifiableNavigableSet = this.descendingSet;
            if (unmodifiableNavigableSet == null) {
                unmodifiableNavigableSet = this.descendingSet = new UnmodifiableNavigableSet<E>(this.delegate.descendingSet());
                unmodifiableNavigableSet.descendingSet = this;
            }
            return unmodifiableNavigableSet;
        }

        @Override
        public Iterator<E> descendingIterator() {
            return Iterators.unmodifiableIterator(this.delegate.descendingIterator());
        }

        @Override
        public NavigableSet<E> subSet(E e2, boolean bl2, E e3, boolean bl3) {
            return Sets.unmodifiableNavigableSet(this.delegate.subSet(e2, bl2, e3, bl3));
        }

        @Override
        public NavigableSet<E> headSet(E e2, boolean bl2) {
            return Sets.unmodifiableNavigableSet(this.delegate.headSet(e2, bl2));
        }

        @Override
        public NavigableSet<E> tailSet(E e2, boolean bl2) {
            return Sets.unmodifiableNavigableSet(this.delegate.tailSet(e2, bl2));
        }
    }

    public static abstract class SetView<E>
    extends AbstractSet<E> {
        private SetView() {
        }

        @Override
        @Deprecated
        public final boolean add(E e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final boolean removeIf(Predicate<? super E> predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public abstract UnmodifiableIterator<E> iterator();
    }

    static abstract class ImprovedAbstractSet<E>
    extends AbstractSet<E> {
        ImprovedAbstractSet() {
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return Sets.removeAllImpl(this, collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return super.retainAll(Preconditions.checkNotNull(collection));
        }
    }
}

