/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.WriterConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.EncodingXmlWriter;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;

public final class AsciiXmlWriter
extends EncodingXmlWriter {
    public AsciiXmlWriter(OutputStream outputStream, WriterConfig writerConfig, boolean bl2) throws IOException {
        super(outputStream, writerConfig, "US-ASCII", bl2);
    }

    @Override
    public void writeRaw(char[] cArray, int n2, int n3) throws IOException {
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        int n4 = this.mOutputPtr;
        while (n3 > 0) {
            int n5;
            int n6 = this.mOutputBuffer.length - n4;
            if (n6 < 1) {
                this.mOutputPtr = n4;
                this.flushBuffer();
                n4 = 0;
                n6 = this.mOutputBuffer.length;
            }
            if (n6 > n3) {
                n6 = n3;
            }
            if (this.mCheckContent) {
                n5 = n2 + n6;
                while (n2 < n5) {
                    char c2 = cArray[n2];
                    if (c2 < ' ') {
                        if (c2 != '\n' && c2 != '\r' && c2 != '\t') {
                            this.mOutputPtr = n4;
                            c2 = this.handleInvalidChar(c2);
                        }
                    } else if (c2 > '~') {
                        this.mOutputPtr = n4;
                        if (c2 > '\u007f') {
                            this.handleInvalidAsciiChar(c2);
                        } else if (this.mXml11) {
                            c2 = this.handleInvalidChar(c2);
                        }
                    }
                    this.mOutputBuffer[n4++] = (byte)c2;
                    ++n2;
                }
            } else {
                n5 = n2 + n6;
                while (n2 < n5) {
                    this.mOutputBuffer[n4++] = (byte)cArray[n2];
                    ++n2;
                }
            }
            n3 -= n6;
        }
        this.mOutputPtr = n4;
    }

    @Override
    public void writeRaw(String string, int n2, int n3) throws IOException {
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        int n4 = this.mOutputPtr;
        while (n3 > 0) {
            int n5;
            int n6 = this.mOutputBuffer.length - n4;
            if (n6 < 1) {
                this.mOutputPtr = n4;
                this.flushBuffer();
                n4 = 0;
                n6 = this.mOutputBuffer.length;
            }
            if (n6 > n3) {
                n6 = n3;
            }
            if (this.mCheckContent) {
                n5 = n2 + n6;
                while (n2 < n5) {
                    char c2 = string.charAt(n2);
                    if (c2 < ' ') {
                        if (c2 != '\n' && c2 != '\r' && c2 != '\t') {
                            this.mOutputPtr = n4;
                            c2 = this.handleInvalidChar(c2);
                        }
                    } else if (c2 > '~') {
                        this.mOutputPtr = n4;
                        if (c2 > '\u007f') {
                            this.handleInvalidAsciiChar(c2);
                        } else if (this.mXml11) {
                            c2 = this.handleInvalidChar(c2);
                        }
                    }
                    this.mOutputBuffer[n4++] = (byte)c2;
                    ++n2;
                }
            } else {
                n5 = n2 + n6;
                while (n2 < n5) {
                    this.mOutputBuffer[n4++] = (byte)string.charAt(n2);
                    ++n2;
                }
            }
            n3 -= n6;
        }
        this.mOutputPtr = n4;
    }

    @Override
    protected void writeAttrValue(String string) throws IOException {
        int n2 = 0;
        int n3 = string.length();
        int n4 = this.mOutputPtr;
        block0: while (n3 > 0) {
            int n5;
            int n6 = this.mOutputBuffer.length - n4;
            if (n6 < 1) {
                this.mOutputPtr = n4;
                this.flushBuffer();
                n4 = 0;
                n6 = this.mOutputBuffer.length;
            }
            if (this.mSurrogate != 0) {
                n5 = string.charAt(n2++);
                n5 = this.calcSurrogate(n5);
                this.mOutputPtr = n4;
                n4 = this.writeAsEntity(n5);
                --n3;
                continue;
            }
            if (n6 > n3) {
                n6 = n3;
            }
            n5 = n2 + n6;
            while (n2 < n5) {
                int n7;
                if ((n7 = string.charAt(n2++)) < 32) {
                    if (n7 == 13) {
                        if (!this.mEscapeCR) {
                            this.mOutputBuffer[n4++] = (byte)n7;
                            continue;
                        }
                    } else if (n7 != 10 && n7 != 9 && this.mCheckContent && (!this.mXml11 || n7 == 0)) {
                        n7 = this.handleInvalidChar(n7);
                        this.mOutputBuffer[n4++] = (byte)n7;
                        continue;
                    }
                } else if (n7 < 127) {
                    if (n7 != 60 && n7 != 38 && n7 != 34) {
                        this.mOutputBuffer[n4++] = (byte)n7;
                        continue;
                    }
                } else if (n7 >= 55296 && n7 <= 57343) {
                    this.mSurrogate = n7;
                    if (n2 == n5) break;
                    n7 = this.calcSurrogate(string.charAt(n2++));
                }
                this.mOutputPtr = n4;
                n4 = this.writeAsEntity(n7);
                n3 = string.length() - n2;
                continue block0;
            }
            n3 -= n6;
        }
        this.mOutputPtr = n4;
    }

    @Override
    protected void writeAttrValue(char[] cArray, int n2, int n3) throws IOException {
        int n4 = this.mOutputPtr;
        while (n3 > 0) {
            int n5;
            int n6 = this.mOutputBuffer.length - n4;
            if (n6 < 1) {
                this.mOutputPtr = n4;
                this.flushBuffer();
                n4 = 0;
                n6 = this.mOutputBuffer.length;
            }
            if (this.mSurrogate != 0) {
                n5 = cArray[n2++];
                n5 = this.calcSurrogate(n5);
                this.mOutputPtr = n4;
                n4 = this.writeAsEntity(n5);
                --n3;
                continue;
            }
            if (n6 > n3) {
                n6 = n3;
            }
            n5 = n2 + n6;
            while (n2 < n5) {
                int n7;
                if ((n7 = cArray[n2++]) < 32) {
                    if (n7 == 13) {
                        if (!this.mEscapeCR) {
                            this.mOutputBuffer[n4++] = (byte)n7;
                            continue;
                        }
                    } else if (n7 != 10 && n7 != 9 && this.mCheckContent && (!this.mXml11 || n7 == 0)) {
                        n7 = this.handleInvalidChar(n7);
                        this.mOutputBuffer[n4++] = (byte)n7;
                        continue;
                    }
                } else if (n7 < 127) {
                    if (n7 != 60 && n7 != 38 && n7 != 34) {
                        this.mOutputBuffer[n4++] = (byte)n7;
                        continue;
                    }
                } else if (n7 >= 55296 && n7 <= 57343) {
                    this.mSurrogate = n7;
                    if (n2 == n5) break;
                    n7 = this.calcSurrogate(cArray[n2++]);
                }
                this.mOutputPtr = n4;
                n4 = this.writeAsEntity(n7);
                n6 -= n5 - n2;
                break;
            }
            n3 -= n6;
        }
        this.mOutputPtr = n4;
    }

    @Override
    protected int writeCDataContent(String string) throws IOException {
        int n2 = 0;
        int n3 = string.length();
        if (!this.mCheckContent) {
            this.writeRaw(string, n2, n3);
            return -1;
        }
        int n4 = this.mOutputPtr;
        block0: while (n3 > 0) {
            int n5 = this.mOutputBuffer.length - n4;
            if (n5 < 1) {
                this.mOutputPtr = n4;
                this.flushBuffer();
                n4 = 0;
                n5 = this.mOutputBuffer.length;
            }
            if (n5 > n3) {
                n5 = n3;
            }
            int n6 = n2 + n5;
            while (n2 < n6) {
                char c2;
                block9: {
                    block10: {
                        block11: {
                            block8: {
                                if ((c2 = string.charAt(n2++)) >= ' ') break block8;
                                if (c2 != '\n' && c2 != '\r' && c2 != '\t') {
                                    this.mOutputPtr = n4;
                                    c2 = this.handleInvalidChar(c2);
                                }
                                break block9;
                            }
                            if (c2 <= '~') break block10;
                            this.mOutputPtr = n4;
                            if (c2 <= '\u007f') break block11;
                            this.handleInvalidAsciiChar(c2);
                            break block9;
                        }
                        if (!this.mXml11) break block9;
                        c2 = this.handleInvalidChar(c2);
                        break block9;
                    }
                    if (c2 == '>' && n2 > 2 && string.charAt(n2 - 2) == ']' && string.charAt(n2 - 3) == ']') {
                        if (!this.mFixContent) {
                            return n2 - 3;
                        }
                        this.mOutputPtr = n4;
                        this.writeCDataEnd();
                        this.writeCDataStart();
                        this.writeAscii((byte)62);
                        n4 = this.mOutputPtr;
                        n3 = string.length() - n2;
                        continue block0;
                    }
                }
                this.mOutputBuffer[n4++] = (byte)c2;
            }
            n3 -= n5;
        }
        this.mOutputPtr = n4;
        return -1;
    }

    @Override
    protected int writeCDataContent(char[] cArray, int n2, int n3) throws IOException {
        if (!this.mCheckContent) {
            this.writeRaw(cArray, n2, n3);
            return -1;
        }
        int n4 = this.mOutputPtr;
        int n5 = n2;
        while (n3 > 0) {
            int n6 = this.mOutputBuffer.length - n4;
            if (n6 < 1) {
                this.mOutputPtr = n4;
                this.flushBuffer();
                n4 = 0;
                n6 = this.mOutputBuffer.length;
            }
            if (n6 > n3) {
                n6 = n3;
            }
            int n7 = n5 + n6;
            while (n5 < n7) {
                char c2;
                block9: {
                    block10: {
                        block11: {
                            block8: {
                                if ((c2 = cArray[n5++]) >= ' ') break block8;
                                if (c2 != '\n' && c2 != '\r' && c2 != '\t') {
                                    this.mOutputPtr = n4;
                                    c2 = this.handleInvalidChar(c2);
                                }
                                break block9;
                            }
                            if (c2 <= '~') break block10;
                            this.mOutputPtr = n4;
                            if (c2 <= '\u007f') break block11;
                            this.handleInvalidAsciiChar(c2);
                            break block9;
                        }
                        if (!this.mXml11) break block9;
                        c2 = this.handleInvalidChar(c2);
                        break block9;
                    }
                    if (c2 == '>' && n5 >= n2 + 3 && cArray[n5 - 2] == ']' && cArray[n5 - 3] == ']') {
                        if (!this.mFixContent) {
                            return n5 - 3;
                        }
                        this.mOutputPtr = n4;
                        this.writeCDataEnd();
                        this.writeCDataStart();
                        this.writeAscii((byte)62);
                        n4 = this.mOutputPtr;
                        n6 -= n7 - n5;
                        break;
                    }
                }
                this.mOutputBuffer[n4++] = (byte)c2;
            }
            n3 -= n6;
        }
        this.mOutputPtr = n4;
        return -1;
    }

    @Override
    protected int writeCommentContent(String string) throws IOException {
        int n2;
        int n3;
        int n4 = 0;
        if (!this.mCheckContent) {
            this.writeRaw(string, n4, n3);
            return -1;
        }
        int n5 = this.mOutputPtr;
        block0: for (n3 = string.length(); n3 > 0; n3 -= n2) {
            n2 = this.mOutputBuffer.length - n5;
            if (n2 < 1) {
                this.mOutputPtr = n5;
                this.flushBuffer();
                n5 = 0;
                n2 = this.mOutputBuffer.length;
            }
            if (n2 > n3) {
                n2 = n3;
            }
            int n6 = n4 + n2;
            while (n4 < n6) {
                char c2;
                block10: {
                    block11: {
                        block12: {
                            block9: {
                                if ((c2 = string.charAt(n4++)) >= ' ') break block9;
                                if (c2 != '\n' && c2 != '\r' && c2 != '\t') {
                                    this.mOutputPtr = n5;
                                    c2 = this.handleInvalidChar(c2);
                                }
                                break block10;
                            }
                            if (c2 <= '~') break block11;
                            this.mOutputPtr = n5;
                            if (c2 <= '\u007f') break block12;
                            this.handleInvalidAsciiChar(c2);
                            break block10;
                        }
                        if (!this.mXml11) break block10;
                        c2 = this.handleInvalidChar(c2);
                        break block10;
                    }
                    if (c2 == '-' && n4 > 1 && string.charAt(n4 - 2) == '-') {
                        if (!this.mFixContent) {
                            return n4 - 2;
                        }
                        this.mOutputBuffer[n5++] = 32;
                        if (n5 >= this.mOutputBuffer.length) {
                            this.mOutputPtr = n5;
                            this.flushBuffer();
                            n5 = 0;
                        }
                        this.mOutputBuffer[n5++] = 45;
                        n2 -= n6 - n4;
                        continue block0;
                    }
                }
                this.mOutputBuffer[n5++] = (byte)c2;
            }
        }
        this.mOutputPtr = n5;
        return -1;
    }

    @Override
    protected int writePIData(String string) throws IOException, XMLStreamException {
        int n2;
        int n3;
        int n4 = 0;
        if (!this.mCheckContent) {
            this.writeRaw(string, n4, n3);
            return -1;
        }
        int n5 = this.mOutputPtr;
        for (n3 = string.length(); n3 > 0; n3 -= n2) {
            n2 = this.mOutputBuffer.length - n5;
            if (n2 < 1) {
                this.mOutputPtr = n5;
                this.flushBuffer();
                n5 = 0;
                n2 = this.mOutputBuffer.length;
            }
            if (n2 > n3) {
                n2 = n3;
            }
            int n6 = n4 + n2;
            while (n4 < n6) {
                char c2 = string.charAt(n4);
                if (c2 < ' ') {
                    if (c2 != '\n' && c2 != '\r' && c2 != '\t') {
                        this.mOutputPtr = n5;
                        c2 = this.handleInvalidChar(c2);
                    }
                } else if (c2 > '~') {
                    this.mOutputPtr = n5;
                    if (c2 > '\u007f') {
                        this.handleInvalidAsciiChar(c2);
                    } else if (this.mXml11) {
                        c2 = this.handleInvalidChar(c2);
                    }
                } else if (c2 == '>' && n4 > 0 && string.charAt(n4 - 1) == '?') {
                    return n4 - 2;
                }
                this.mOutputBuffer[n5++] = (byte)c2;
                ++n4;
            }
        }
        this.mOutputPtr = n5;
        return -1;
    }

    @Override
    protected void writeTextContent(String string) throws IOException {
        int n2 = 0;
        int n3 = string.length();
        block0: while (n3 > 0) {
            int n4;
            int n5 = this.mOutputBuffer.length - this.mOutputPtr;
            if (n5 < 1) {
                this.flushBuffer();
                n5 = this.mOutputBuffer.length;
            }
            if (this.mSurrogate != 0) {
                n4 = string.charAt(n2++);
                n4 = this.calcSurrogate(n4);
                this.writeAsEntity(n4);
                --n3;
                continue;
            }
            if (n5 > n3) {
                n5 = n3;
            }
            n4 = n2 + n5;
            while (n2 < n4) {
                int n6;
                if ((n6 = string.charAt(n2++)) < 32) {
                    if (n6 == 10 || n6 == 9) {
                        this.mOutputBuffer[this.mOutputPtr++] = (byte)n6;
                        continue;
                    }
                    if (n6 == 13) {
                        if (!this.mEscapeCR) {
                            this.mOutputBuffer[this.mOutputPtr++] = (byte)n6;
                            continue;
                        }
                    } else if ((!this.mXml11 || n6 == 0) && this.mCheckContent) {
                        n6 = this.handleInvalidChar(n6);
                        this.mOutputBuffer[this.mOutputPtr++] = (byte)n6;
                        continue;
                    }
                } else if (n6 < 127) {
                    if (n6 != 60 && n6 != 38 && (n6 != 62 || n2 > 1 && string.charAt(n2 - 2) != ']')) {
                        this.mOutputBuffer[this.mOutputPtr++] = (byte)n6;
                        continue;
                    }
                } else if (n6 >= 55296 && n6 <= 57343) {
                    this.mSurrogate = n6;
                    if (n2 == n4) break;
                    n6 = this.calcSurrogate(string.charAt(n2++));
                }
                this.writeAsEntity(n6);
                n3 = string.length() - n2;
                continue block0;
            }
            n3 -= n5;
        }
    }

    @Override
    protected void writeTextContent(char[] cArray, int n2, int n3) throws IOException {
        while (n3 > 0) {
            int n4;
            int n5 = this.mOutputBuffer.length - this.mOutputPtr;
            if (n5 < 1) {
                this.flushBuffer();
                n5 = this.mOutputBuffer.length;
            }
            if (this.mSurrogate != 0) {
                n4 = cArray[n2++];
                n4 = this.calcSurrogate(n4);
                this.writeAsEntity(n4);
                --n3;
                continue;
            }
            if (n5 > n3) {
                n5 = n3;
            }
            n4 = n2 + n5;
            while (n2 < n4) {
                int n6;
                if ((n6 = cArray[n2++]) < 32) {
                    if (n6 == 10 || n6 == 9) {
                        this.mOutputBuffer[this.mOutputPtr++] = (byte)n6;
                        continue;
                    }
                    if (n6 == 13) {
                        if (!this.mEscapeCR) {
                            this.mOutputBuffer[this.mOutputPtr++] = (byte)n6;
                            continue;
                        }
                    } else if ((!this.mXml11 || n6 == 0) && this.mCheckContent) {
                        n6 = this.handleInvalidChar(n6);
                        this.mOutputBuffer[this.mOutputPtr++] = (byte)n6;
                        continue;
                    }
                } else if (n6 < 127) {
                    if (n6 != 60 && n6 != 38 && (n6 != 62 || n2 > 1 && cArray[n2 - 2] != ']')) {
                        this.mOutputBuffer[this.mOutputPtr++] = (byte)n6;
                        continue;
                    }
                } else if (n6 >= 55296 && n6 <= 57343) {
                    this.mSurrogate = n6;
                    if (n2 == n4) break;
                    n6 = this.calcSurrogate(cArray[n2++]);
                }
                this.writeAsEntity(n6);
                n5 -= n4 - n2;
                break;
            }
            n3 -= n5;
        }
    }

    protected void handleInvalidAsciiChar(int n2) throws IOException {
        this.flush();
        throw new IOException("Invalid XML character (0x" + Integer.toHexString(n2) + "); can only be output using character entity when using US-ASCII encoding");
    }
}

