/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.ValidationContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.SerializationContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.BinaryBaseType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.BinaryValueType;

public class HexBinaryType
extends BinaryBaseType {
    public static final HexBinaryType theInstance = new HexBinaryType();
    private static final long serialVersionUID = 1L;

    private HexBinaryType() {
        super("hexBinary");
    }

    private static int hexToBin(char c2) {
        if ('0' <= c2 && c2 <= '9') {
            return c2 - 48;
        }
        if ('A' <= c2 && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        if ('a' <= c2 && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        return -1;
    }

    @Override
    public Object _createValue(String string, ValidationContext validationContext) {
        byte[] byArray = HexBinaryType.load(string);
        if (byArray == null) {
            return null;
        }
        return new BinaryValueType(byArray);
    }

    public static byte[] load(String string) {
        int n2 = string.length();
        if (n2 % 2 != 0) {
            return null;
        }
        byte[] byArray = new byte[n2 / 2];
        for (int i2 = 0; i2 < n2; i2 += 2) {
            int n3 = HexBinaryType.hexToBin(string.charAt(i2));
            int n4 = HexBinaryType.hexToBin(string.charAt(i2 + 1));
            if (n3 == -1 || n4 == -1) {
                return null;
            }
            byArray[i2 / 2] = (byte)(n3 * 16 + n4);
        }
        return byArray;
    }

    @Override
    protected boolean checkFormat(String string, ValidationContext validationContext) {
        int n2 = string.length();
        if (n2 % 2 != 0) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (HexBinaryType.hexToBin(string.charAt(i2)) != -1) continue;
            return false;
        }
        return true;
    }

    @Override
    public String serializeJavaObject(Object object, SerializationContext serializationContext) {
        if (!(object instanceof byte[])) {
            throw new IllegalArgumentException();
        }
        return HexBinaryType.save((byte[])object);
    }

    public static String save(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            stringBuffer.append(HexBinaryType.encode(byArray[i2] >> 4));
            stringBuffer.append(HexBinaryType.encode(byArray[i2] & 0xF));
        }
        return stringBuffer.toString();
    }

    @Override
    public String convertToLexicalValue(Object object, SerializationContext serializationContext) {
        if (!(object instanceof BinaryValueType)) {
            throw new IllegalArgumentException();
        }
        return this.serializeJavaObject(((BinaryValueType)object).rawData, serializationContext);
    }

    public static char encode(int n2) {
        if ((n2 &= 0xF) < 10) {
            return (char)(48 + n2);
        }
        return (char)(65 + (n2 - 10));
    }
}

