/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.agent.maven.cache.extension.internal.api;

import com.gradle.develocity.agent.maven.api.cache.BuildCacheApi;
import com.gradle.develocity.agent.maven.api.cache.CleanupPolicy;
import com.gradle.develocity.agent.maven.api.cache.Credentials;
import com.gradle.develocity.agent.maven.api.cache.LocalBuildCache;
import com.gradle.develocity.agent.maven.api.cache.MojoMetadataProvider;
import com.gradle.develocity.agent.maven.api.cache.NormalizationProvider;
import com.gradle.develocity.agent.maven.api.cache.RemoteBuildCache;
import com.gradle.develocity.agent.maven.api.cache.Server;
import com.gradle.maven.common.configuration.w;
import java.io.File;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DefaultBuildCacheApi
implements BuildCacheApi {
    private final w.a configuration;
    private final DefaultLocalBuildCache localBuildCache;
    private final DefaultRemoteBuildCache remoteBuildCache;
    private final List<MojoMetadataProvider> mojoMetadataProviders = new ArrayList<MojoMetadataProvider>();
    private final List<NormalizationProvider> normalizationProviders = new ArrayList<NormalizationProvider>();
    private volatile boolean locked;

    public DefaultBuildCacheApi(w.a a2) {
        this.configuration = a2;
        this.localBuildCache = new DefaultLocalBuildCache(a2.getLocal());
        this.remoteBuildCache = new DefaultRemoteBuildCache(a2.getRemote());
    }

    @Override
    public boolean isRequireClean() {
        return this.configuration.isRequireClean();
    }

    @Override
    public void setRequireClean(boolean bl2) {
        this.ifNotLocked("BuildScanApi.setRequireClean()", () -> this.configuration.setRequireClean(bl2));
    }

    @Override
    public LocalBuildCache getLocal() {
        return this.localBuildCache;
    }

    @Override
    public RemoteBuildCache getRemote() {
        return this.remoteBuildCache;
    }

    public void lock() {
        this.locked = true;
    }

    @Override
    public void registerMojoMetadataProvider(MojoMetadataProvider mojoMetadataProvider) {
        this.mojoMetadataProviders.add(Objects.requireNonNull(mojoMetadataProvider));
    }

    @Override
    public void registerNormalizationProvider(NormalizationProvider normalizationProvider) {
        this.normalizationProviders.add(Objects.requireNonNull(normalizationProvider));
    }

    public List<MojoMetadataProvider> getMojoMetadataProviders() {
        return this.mojoMetadataProviders;
    }

    public List<NormalizationProvider> getNormalizationProviders() {
        return this.normalizationProviders;
    }

    private void ifNotLocked(String string, Runnable runnable) {
        if (this.locked) {
            throw new RuntimeException("'" + string + "' called after the Maven Session has started.");
        }
        runnable.run();
    }

    private class DefaultLocalBuildCache
    implements LocalBuildCache {
        private final DefaultCleanupPolicy cleanupPolicy;
        private final w.a.a configuration;

        DefaultLocalBuildCache(w.a.a a2) {
            this.configuration = a2;
            this.cleanupPolicy = new DefaultCleanupPolicy(a2.getCleanupPolicy());
        }

        @Override
        public boolean isEnabled() {
            return this.configuration.isEnabled();
        }

        @Override
        public void setEnabled(boolean bl2) {
            DefaultBuildCacheApi.this.ifNotLocked("BuildCacheApi.getLocal().setEnabled()", () -> this.configuration.setEnabled(bl2));
        }

        @Override
        public boolean isStoreEnabled() {
            return this.configuration.isStoreEnabled();
        }

        @Override
        public void setStoreEnabled(boolean bl2) {
            DefaultBuildCacheApi.this.ifNotLocked("BuildCacheApi.getLocal().setStoreEnabled()", () -> this.configuration.setStoreEnabled(bl2));
        }

        @Override
        public File getDirectory() {
            return this.configuration.getDirectory().toFile();
        }

        @Override
        public void setDirectory(File file) {
            DefaultBuildCacheApi.this.ifNotLocked("BuildCacheApi.getLocal().setDirectory()", () -> this.configuration.setDirectory(file.toPath()));
        }

        @Override
        public CleanupPolicy getCleanupPolicy() {
            return this.cleanupPolicy;
        }
    }

    private class DefaultRemoteBuildCache
    implements RemoteBuildCache {
        private final w.a.b configuration;
        private final DefaultServer server;

        DefaultRemoteBuildCache(w.a.b b2) {
            this.configuration = b2;
            this.server = new DefaultServer(b2.getServer());
        }

        @Override
        public boolean isEnabled() {
            return this.configuration.isEnabled();
        }

        @Override
        public void setEnabled(boolean bl2) {
            DefaultBuildCacheApi.this.ifNotLocked("BuildScanApi.getRemote().setEnabled()", () -> this.configuration.setEnabled(bl2));
        }

        @Override
        public boolean isStoreEnabled() {
            return this.configuration.isStoreEnabled();
        }

        @Override
        public void setStoreEnabled(boolean bl2) {
            DefaultBuildCacheApi.this.ifNotLocked("BuildCacheApi.getRemote().setStoreEnabled()", () -> this.configuration.setStoreEnabled(bl2));
        }

        @Override
        public DefaultServer getServer() {
            return this.server;
        }
    }

    private class DefaultCredentials
    implements Credentials {
        private final w.a.b.a.a configuration;

        DefaultCredentials(w.a.b.a.a a2) {
            this.configuration = a2;
        }

        @Override
        public String getUsername() {
            return this.configuration.getUsername();
        }

        @Override
        public void setUsername(String string) {
            DefaultBuildCacheApi.this.ifNotLocked("BuildCacheApi.getRemote().getServer().getCredentials().setUsername()", () -> this.configuration.setUsername(string));
        }

        @Override
        public String getPassword() {
            return this.configuration.getPassword();
        }

        @Override
        public void setPassword(String string) {
            DefaultBuildCacheApi.this.ifNotLocked("BuildCacheApi.getRemote().getServer().getCredentials().setPassword()", () -> this.configuration.setPassword(string));
        }
    }

    private class DefaultCleanupPolicy
    implements CleanupPolicy {
        private final w.a.a.a configuration;

        DefaultCleanupPolicy(w.a.a.a a2) {
            this.configuration = a2;
        }

        @Override
        public boolean isEnabled() {
            return this.configuration.isEnabled();
        }

        @Override
        public void setEnabled(boolean bl2) {
            DefaultBuildCacheApi.this.ifNotLocked("BuildCacheApi.getLocal().getCleanupPolicy().setEnabled()", () -> this.configuration.setEnabled(bl2));
        }

        @Override
        public Duration getRetentionPeriod() {
            return this.configuration.getRetentionPeriod();
        }

        @Override
        public void setRetentionPeriod(Duration duration) {
            DefaultBuildCacheApi.this.ifNotLocked("BuildCacheApi.getLocal().getCleanupPolicy().setRetentionPeriod()", () -> this.configuration.setRetentionPeriod(duration));
        }

        @Override
        public Duration getCleanupInterval() {
            return this.configuration.getCleanupInterval();
        }

        @Override
        public void setCleanupInterval(Duration duration) {
            DefaultBuildCacheApi.this.ifNotLocked("BuildCacheApi.getLocal().getCleanupPolicy().setCleanupInterval()", () -> this.configuration.setCleanupInterval(duration));
        }
    }

    private class DefaultServer
    implements Server {
        private final DefaultCredentials credentials;
        private final w.a.b.a configuration;

        DefaultServer(w.a.b.a a2) {
            this.configuration = a2;
            this.credentials = new DefaultCredentials(a2.getCredentials());
        }

        @Override
        public boolean isAllowUntrusted() {
            return this.configuration.isAllowUntrusted();
        }

        @Override
        public void setAllowUntrusted(boolean bl2) {
            DefaultBuildCacheApi.this.ifNotLocked("BuildCacheApi.getRemote().getServer().setAllowUntrusted()", () -> this.configuration.setAllowUntrusted(bl2));
        }

        @Override
        public boolean isAllowInsecureProtocol() {
            return this.configuration.isAllowInsecureProtocol();
        }

        @Override
        public void setAllowInsecureProtocol(boolean bl2) {
            DefaultBuildCacheApi.this.ifNotLocked("BuildCacheApi.getRemote().getServer().setAllowInsecureProtocol()", () -> this.configuration.setAllowInsecureProtocol(bl2));
        }

        @Override
        public boolean isUseExpectContinue() {
            return this.configuration.isUseExpectContinue();
        }

        @Override
        public void setUseExpectContinue(boolean bl2) {
            DefaultBuildCacheApi.this.ifNotLocked("BuildCacheApi.getRemote().getServer().setUseExpectContinue()", () -> this.configuration.setUseExpectContinue(bl2));
        }

        @Override
        public String getServerId() {
            return this.configuration.getId();
        }

        @Override
        public void setServerId(String string) {
            DefaultBuildCacheApi.this.ifNotLocked("BuildCacheApi.getRemote().getServer().setServerId()", () -> this.configuration.setId(string));
        }

        @Override
        public URI getUrl() {
            return this.configuration.getUrl();
        }

        @Override
        public void setUrl(URI uRI) {
            DefaultBuildCacheApi.this.ifNotLocked("BuildCacheApi.getRemote().getServer().setUrl()", () -> this.configuration.setUrl(uRI));
        }

        @Override
        public Credentials getCredentials() {
            return this.credentials;
        }
    }
}

