/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ha" locale.
 */
public class LocalizedNamesImpl_ha extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "ZA",
        "CI",
        "IS",
        "AL",
        "DZ",
        "US",
        "AD",
        "AI",
        "AO",
        "AG",
        "AN",
        "AQ",
        "AR",
        "AM",
        "AW",
        "AX",
        "IE",
        "AZ",
        "BS",
        "BH",
        "BD",
        "VU",
        "BB",
        "BM",
        "BW",
        "VA",
        "BY",
        "BE",
        "BZ",
        "VE",
        "BJ",
        "BR",
        "GB",
        "VN",
        "BL",
        "BO",
        "BA",
        "BG",
        "BF",
        "MM",
        "BI",
        "BN",
        "BT",
        "BV",
        "TD",
        "CN",
        "CL",
        "CC",
        "CP",
        "CX",
        "DK",
        "DG",
        "DM",
        "EA",
        "EH",
        "EC",
        "SV",
        "ER",
        "EE",
        "EU",
        "FR",
        "FJ",
        "PH",
        "FI",
        "FO",
        "PF",
        "GA",
        "GM",
        "GH",
        "GG",
        "GN",
        "GW",
        "GF",
        "GQ",
        "GR",
        "GD",
        "GL",
        "GS",
        "GY",
        "GP",
        "GU",
        "GT",
        "ET",
        "HT",
        "AE",
        "HK",
        "HM",
        "NL",
        "HN",
        "HU",
        "IC",
        "IM",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IT",
        "IL",
        "JM",
        "CF",
        "CZ",
        "CD",
        "DO",
        "DE",
        "JP",
        "JE",
        "GI",
        "DJ",
        "GE",
        "JO",
        "NC",
        "CM",
        "KH",
        "CA",
        "KZ",
        "KE",
        "KG",
        "KI",
        "CO",
        "CG",
        "KP",
        "KR",
        "HR",
        "KM",
        "CR",
        "QA",
        "KW",
        "CU",
        "LB",
        "LR",
        "LV",
        "LA",
        "LS",
        "LY",
        "LI",
        "LT",
        "LU",
        "MG",
        "MX",
        "MY",
        "MW",
        "MV",
        "MD",
        "ML",
        "MT",
        "MN",
        "MS",
        "MA",
        "MQ",
        "EG",
        "MK",
        "YT",
        "ME",
        "MF",
        "FM",
        "MO",
        "MC",
        "MR",
        "MU",
        "MZ",
        "NG",
        "NA",
        "NR",
        "NP",
        "NE",
        "NI",
        "NU",
        "NO",
        "NZ",
        "OM",
        "AU",
        "AT",
        "PK",
        "PS",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PR",
        "PT",
        "QO",
        "RU",
        "RE",
        "RO",
        "RS",
        "RW",
        "SC",
        "SL",
        "WS",
        "AS",
        "VC",
        "SH",
        "KN",
        "LC",
        "SM",
        "PM",
        "CS",
        "ST",
        "SY",
        "CY",
        "SG",
        "SN",
        "ES",
        "LK",
        "SJ",
        "SO",
        "SD",
        "SK",
        "SI",
        "SR",
        "SZ",
        "SE",
        "CH",
        "TA",
        "TH",
        "TW",
        "TJ",
        "TK",
        "TO",
        "TZ",
        "TF",
        "TL",
        "TT",
        "TG",
        "VI",
        "FK",
        "KY",
        "CV",
        "CK",
        "MP",
        "MH",
        "SB",
        "VG",
        "NF",
        "TV",
        "TN",
        "TC",
        "TR",
        "TM",
        "UM",
        "UZ",
        "WF",
        "YE",
        "IO",
        "UG",
        "UA",
        "UY",
        "ZM",
        "ZW",
        "SA",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Andora");
    namesMap.put("AE", "Haɗaɗɗiyar Daular Larabawa");
    namesMap.put("AF", "Afaganistan");
    namesMap.put("AG", "Antigwa da Barbuba");
    namesMap.put("AI", "Angila");
    namesMap.put("AL", "Albaniya");
    namesMap.put("AM", "Armeniya");
    namesMap.put("AN", "Antiya Na Holan");
    namesMap.put("AR", "Arjantiniya");
    namesMap.put("AS", "Samowa Ta Amurka");
    namesMap.put("AT", "Ostiriya");
    namesMap.put("AU", "Ostareliya");
    namesMap.put("AZ", "Azarbaijan");
    namesMap.put("BA", "Bosniya Harzagobina");
    namesMap.put("BB", "Barbadas");
    namesMap.put("BD", "Bangiladas");
    namesMap.put("BE", "Belgiyom");
    namesMap.put("BG", "Bulgariya");
    namesMap.put("BH", "Baharan");
    namesMap.put("BJ", "Binin");
    namesMap.put("BM", "Barmuda");
    namesMap.put("BN", "Burune");
    namesMap.put("BO", "Bolibiya");
    namesMap.put("BR", "Birazil");
    namesMap.put("BT", "Butan");
    namesMap.put("BW", "Baswana");
    namesMap.put("BZ", "Beliz");
    namesMap.put("CA", "Kanada");
    namesMap.put("CD", "Jamhuriyar Dimokuraɗiyyar Kongo");
    namesMap.put("CF", "Jamhuriyar Afirka Ta Tsakiya");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Suwizalan");
    namesMap.put("CI", "Aibari Kwas");
    namesMap.put("CK", "Tsibiran Kuku");
    namesMap.put("CL", "Cayile");
    namesMap.put("CM", "Kamaru");
    namesMap.put("CN", "Caina, Sin");
    namesMap.put("CO", "Kolambiya");
    namesMap.put("CR", "Kwasta Rika");
    namesMap.put("CS", "Sarbiya Da Mantanegiro");
    namesMap.put("CU", "Kyuba");
    namesMap.put("CV", "Tsibiran Kap Barde");
    namesMap.put("CY", "Sifurus");
    namesMap.put("CZ", "Jamhuriyar Cak");
    namesMap.put("DE", "Jamus");
    namesMap.put("DJ", "Jibuti");
    namesMap.put("DK", "Danmark");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Jamhuriyar Dominika");
    namesMap.put("DZ", "Aljeriya");
    namesMap.put("EC", "Ekwador");
    namesMap.put("EE", "Estoniya");
    namesMap.put("EG", "Masar, Misira");
    namesMap.put("ER", "Eritireya");
    namesMap.put("ES", "Sipen");
    namesMap.put("ET", "Habasha");
    namesMap.put("FI", "Finlan");
    namesMap.put("FK", "Tsibiran Falkilan");
    namesMap.put("FM", "Mikuronesiya");
    namesMap.put("FR", "Faransa");
    namesMap.put("GB", "Birtaniya");
    namesMap.put("GD", "Girnada");
    namesMap.put("GE", "Jiwarjiya");
    namesMap.put("GF", "Gini Ta Faransa");
    namesMap.put("GH", "Gana");
    namesMap.put("GI", "Jibaraltar");
    namesMap.put("GL", "Grinlan");
    namesMap.put("GM", "Gambiya");
    namesMap.put("GN", "Gini");
    namesMap.put("GP", "Gwadaluf");
    namesMap.put("GQ", "Gini Ta Ikwaita");
    namesMap.put("GR", "Girka");
    namesMap.put("GT", "Gwatamala");
    namesMap.put("GU", "Gwam");
    namesMap.put("GW", "Gini Bisau");
    namesMap.put("HR", "Kurowaishiya");
    namesMap.put("HU", "Hungari");
    namesMap.put("ID", "Indunusiya");
    namesMap.put("IE", "Ayalan");
    namesMap.put("IL", "Izira'ila");
    namesMap.put("IN", "Indiya");
    namesMap.put("IO", "Yankin Birtaniya Na Tekun Indiya");
    namesMap.put("IQ", "Iraƙi");
    namesMap.put("IS", "Aisalan");
    namesMap.put("IT", "Italiya");
    namesMap.put("JM", "Jamaika");
    namesMap.put("KG", "Kirgizistan");
    namesMap.put("KH", "Kambodiya");
    namesMap.put("KM", "Kwamoras");
    namesMap.put("KN", "San Kiti Da Nebis");
    namesMap.put("KP", "Koreya Ta Arewa");
    namesMap.put("KR", "Koreya Ta Kudu");
    namesMap.put("KW", "Kwiyat");
    namesMap.put("KY", "Tsibiran Kaiman");
    namesMap.put("KZ", "Kazakistan");
    namesMap.put("LA", "Lawas");
    namesMap.put("LB", "Labanan");
    namesMap.put("LC", "San Lusiya");
    namesMap.put("LI", "Licansitan");
    namesMap.put("LK", "Siri Lanka");
    namesMap.put("LR", "Laberiya");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Lituweniya");
    namesMap.put("LU", "Lukusambur");
    namesMap.put("LV", "latibiya");
    namesMap.put("LY", "Libiya");
    namesMap.put("MA", "Maroko");
    namesMap.put("MC", "Monako");
    namesMap.put("MD", "Maldoba");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Tsibiran Marshal");
    namesMap.put("MK", "Masedoniya");
    namesMap.put("MM", "Burma, Miyamar");
    namesMap.put("MN", "Mangoliya");
    namesMap.put("MP", "Tsibiran Mariyana Na Arewa");
    namesMap.put("MQ", "Martinik");
    namesMap.put("MR", "Moritaniya");
    namesMap.put("MS", "Manserati");
    namesMap.put("MU", "Moritus");
    namesMap.put("MV", "Maldibi");
    namesMap.put("MX", "Makasiko");
    namesMap.put("MY", "Malaisiya");
    namesMap.put("MZ", "Mozambik");
    namesMap.put("NA", "Namibiya");
    namesMap.put("NC", "Kaledoniya Sabuwa");
    namesMap.put("NE", "Nijar");
    namesMap.put("NF", "Tsibirin Narfalk");
    namesMap.put("NG", "Najeriya");
    namesMap.put("NI", "Nikaraguwa");
    namesMap.put("NL", "Holan");
    namesMap.put("NO", "Norwe");
    namesMap.put("NP", "Nefal");
    namesMap.put("NU", "Niyu");
    namesMap.put("NZ", "Nuzilan");
    namesMap.put("PF", "Folinesiya Ta Faransa");
    namesMap.put("PG", "Papuwa Nugini");
    namesMap.put("PH", "Filipin");
    namesMap.put("PL", "Polan");
    namesMap.put("PM", "San Piyar Da Mikelan");
    namesMap.put("PN", "Pitakarin");
    namesMap.put("PR", "Porto Riko");
    namesMap.put("PS", "Palasɗinu");
    namesMap.put("PY", "Paragai");
    namesMap.put("QA", "Kwatar");
    namesMap.put("RE", "Rawuniyan");
    namesMap.put("RO", "Romaniya");
    namesMap.put("RU", "Rasha");
    namesMap.put("RW", "Ruwanda");
    namesMap.put("SA", "Ƙasar Makka");
    namesMap.put("SB", "Tsibiran Salaman");
    namesMap.put("SC", "Saishal");
    namesMap.put("SE", "Suwedan");
    namesMap.put("SG", "Singapur");
    namesMap.put("SH", "San Helena");
    namesMap.put("SI", "Sulobeniya");
    namesMap.put("SK", "Sulobakiya");
    namesMap.put("SL", "Salewo");
    namesMap.put("SN", "Sinigal");
    namesMap.put("SO", "Somaliya");
    namesMap.put("ST", "Sawo Tome Da Paransip");
    namesMap.put("SV", "El Salbador");
    namesMap.put("SY", "Sham, Siriya");
    namesMap.put("SZ", "Suwazilan");
    namesMap.put("TC", "Turkis Da Tsibiran Kaikwas");
    namesMap.put("TD", "Cadi");
    namesMap.put("TH", "Tailan");
    namesMap.put("TK", "Takelau");
    namesMap.put("TL", "Timor Ta Gabas");
    namesMap.put("TM", "Turkumenistan");
    namesMap.put("TN", "Tunisiya");
    namesMap.put("TO", "Tanga");
    namesMap.put("TR", "Turkiyya");
    namesMap.put("TT", "Tirinidad Da Tobago");
    namesMap.put("TV", "Tubalu");
    namesMap.put("TZ", "Tanzaniya");
    namesMap.put("UA", "Yukaran");
    namesMap.put("UG", "Yuganda");
    namesMap.put("US", "Amurka");
    namesMap.put("UY", "Yurugai");
    namesMap.put("UZ", "Uzubekistan");
    namesMap.put("VA", "Batikan");
    namesMap.put("VC", "San Binsan Da Girnadin");
    namesMap.put("VE", "Benezuwela");
    namesMap.put("VG", "Tsibirin Birjin Na Birtaniya");
    namesMap.put("VI", "Tsibiran Birjin Ta Amurka");
    namesMap.put("VN", "Biyetinam");
    namesMap.put("VU", "Banuwatu");
    namesMap.put("WF", "Walis Da Futuna");
    namesMap.put("WS", "Samowa");
    namesMap.put("YE", "Yamal");
    namesMap.put("YT", "Mayoti");
    namesMap.put("ZA", "Afirka Ta Kudu");
    namesMap.put("ZM", "Zambiya");
    namesMap.put("ZW", "Zimbabuwe");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Andora",
        "AE": "Haɗaɗɗiyar Daular Larabawa",
        "AF": "Afaganistan",
        "AG": "Antigwa da Barbuba",
        "AI": "Angila",
        "AL": "Albaniya",
        "AM": "Armeniya",
        "AN": "Antiya Na Holan",
        "AR": "Arjantiniya",
        "AS": "Samowa Ta Amurka",
        "AT": "Ostiriya",
        "AU": "Ostareliya",
        "AZ": "Azarbaijan",
        "BA": "Bosniya Harzagobina",
        "BB": "Barbadas",
        "BD": "Bangiladas",
        "BE": "Belgiyom",
        "BG": "Bulgariya",
        "BH": "Baharan",
        "BJ": "Binin",
        "BM": "Barmuda",
        "BN": "Burune",
        "BO": "Bolibiya",
        "BR": "Birazil",
        "BT": "Butan",
        "BW": "Baswana",
        "BZ": "Beliz",
        "CA": "Kanada",
        "CD": "Jamhuriyar Dimokuraɗiyyar Kongo",
        "CF": "Jamhuriyar Afirka Ta Tsakiya",
        "CG": "Kongo",
        "CH": "Suwizalan",
        "CI": "Aibari Kwas",
        "CK": "Tsibiran Kuku",
        "CL": "Cayile",
        "CM": "Kamaru",
        "CN": "Caina, Sin",
        "CO": "Kolambiya",
        "CR": "Kwasta Rika",
        "CS": "Sarbiya Da Mantanegiro",
        "CU": "Kyuba",
        "CV": "Tsibiran Kap Barde",
        "CY": "Sifurus",
        "CZ": "Jamhuriyar Cak",
        "DE": "Jamus",
        "DJ": "Jibuti",
        "DK": "Danmark",
        "DM": "Dominika",
        "DO": "Jamhuriyar Dominika",
        "DZ": "Aljeriya",
        "EC": "Ekwador",
        "EE": "Estoniya",
        "EG": "Masar, Misira",
        "ER": "Eritireya",
        "ES": "Sipen",
        "ET": "Habasha",
        "FI": "Finlan",
        "FK": "Tsibiran Falkilan",
        "FM": "Mikuronesiya",
        "FR": "Faransa",
        "GB": "Birtaniya",
        "GD": "Girnada",
        "GE": "Jiwarjiya",
        "GF": "Gini Ta Faransa",
        "GH": "Gana",
        "GI": "Jibaraltar",
        "GL": "Grinlan",
        "GM": "Gambiya",
        "GN": "Gini",
        "GP": "Gwadaluf",
        "GQ": "Gini Ta Ikwaita",
        "GR": "Girka",
        "GT": "Gwatamala",
        "GU": "Gwam",
        "GW": "Gini Bisau",
        "HR": "Kurowaishiya",
        "HU": "Hungari",
        "ID": "Indunusiya",
        "IE": "Ayalan",
        "IL": "Izira'ila",
        "IN": "Indiya",
        "IO": "Yankin Birtaniya Na Tekun Indiya",
        "IQ": "Iraƙi",
        "IS": "Aisalan",
        "IT": "Italiya",
        "JM": "Jamaika",
        "KG": "Kirgizistan",
        "KH": "Kambodiya",
        "KM": "Kwamoras",
        "KN": "San Kiti Da Nebis",
        "KP": "Koreya Ta Arewa",
        "KR": "Koreya Ta Kudu",
        "KW": "Kwiyat",
        "KY": "Tsibiran Kaiman",
        "KZ": "Kazakistan",
        "LA": "Lawas",
        "LB": "Labanan",
        "LC": "San Lusiya",
        "LI": "Licansitan",
        "LK": "Siri Lanka",
        "LR": "Laberiya",
        "LS": "Lesoto",
        "LT": "Lituweniya",
        "LU": "Lukusambur",
        "LV": "latibiya",
        "LY": "Libiya",
        "MA": "Maroko",
        "MC": "Monako",
        "MD": "Maldoba",
        "MG": "Madagaskar",
        "MH": "Tsibiran Marshal",
        "MK": "Masedoniya",
        "MM": "Burma, Miyamar",
        "MN": "Mangoliya",
        "MP": "Tsibiran Mariyana Na Arewa",
        "MQ": "Martinik",
        "MR": "Moritaniya",
        "MS": "Manserati",
        "MU": "Moritus",
        "MV": "Maldibi",
        "MX": "Makasiko",
        "MY": "Malaisiya",
        "MZ": "Mozambik",
        "NA": "Namibiya",
        "NC": "Kaledoniya Sabuwa",
        "NE": "Nijar",
        "NF": "Tsibirin Narfalk",
        "NG": "Najeriya",
        "NI": "Nikaraguwa",
        "NL": "Holan",
        "NO": "Norwe",
        "NP": "Nefal",
        "NU": "Niyu",
        "NZ": "Nuzilan",
        "PF": "Folinesiya Ta Faransa",
        "PG": "Papuwa Nugini",
        "PH": "Filipin",
        "PL": "Polan",
        "PM": "San Piyar Da Mikelan",
        "PN": "Pitakarin",
        "PR": "Porto Riko",
        "PS": "Palasɗinu",
        "PY": "Paragai",
        "QA": "Kwatar",
        "RE": "Rawuniyan",
        "RO": "Romaniya",
        "RU": "Rasha",
        "RW": "Ruwanda",
        "SA": "Ƙasar Makka",
        "SB": "Tsibiran Salaman",
        "SC": "Saishal",
        "SE": "Suwedan",
        "SG": "Singapur",
        "SH": "San Helena",
        "SI": "Sulobeniya",
        "SK": "Sulobakiya",
        "SL": "Salewo",
        "SN": "Sinigal",
        "SO": "Somaliya",
        "ST": "Sawo Tome Da Paransip",
        "SV": "El Salbador",
        "SY": "Sham, Siriya",
        "SZ": "Suwazilan",
        "TC": "Turkis Da Tsibiran Kaikwas",
        "TD": "Cadi",
        "TH": "Tailan",
        "TK": "Takelau",
        "TL": "Timor Ta Gabas",
        "TM": "Turkumenistan",
        "TN": "Tunisiya",
        "TO": "Tanga",
        "TR": "Turkiyya",
        "TT": "Tirinidad Da Tobago",
        "TV": "Tubalu",
        "TZ": "Tanzaniya",
        "UA": "Yukaran",
        "UG": "Yuganda",
        "US": "Amurka",
        "UY": "Yurugai",
        "UZ": "Uzubekistan",
        "VA": "Batikan",
        "VC": "San Binsan Da Girnadin",
        "VE": "Benezuwela",
        "VG": "Tsibirin Birjin Na Birtaniya",
        "VI": "Tsibiran Birjin Ta Amurka",
        "VN": "Biyetinam",
        "VU": "Banuwatu",
        "WF": "Walis Da Futuna",
        "WS": "Samowa",
        "YE": "Yamal",
        "YT": "Mayoti",
        "ZA": "Afirka Ta Kudu",
        "ZM": "Zambiya",
        "ZW": "Zimbabuwe"
    };
  }-*/;
}
