/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.collect.ImmutableMap;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.HttpApiResponse;
import com.google.genai.types.HttpOptions;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

final class HttpApiClient
extends ApiClient {
    HttpApiClient(Optional<String> apiKey, Optional<HttpOptions> httpOptions) {
        super(apiKey, httpOptions);
    }

    HttpApiClient(Optional<String> project, Optional<String> location, Optional<GoogleCredentials> credentials, Optional<HttpOptions> httpOptions) {
        super(project, location, credentials, httpOptions);
    }

    @Override
    public ApiResponse post(String path, String requestJson) throws IOException {
        if (this.isVertexAI() && !path.startsWith("projects/")) {
            path = String.format("projects/%s/locations/%s/", this.project.get(), this.location.get()) + path;
        }
        HttpPost httpPost = new HttpPost(String.format("%s/%s/%s", this.httpOptions.baseUrl().get(), this.httpOptions.apiVersion().get(), path));
        for (Map.Entry<String, String> header : this.httpOptions.headers().orElse((Map<String, String>)ImmutableMap.of()).entrySet()) {
            httpPost.setHeader(header.getKey(), header.getValue());
        }
        if (this.apiKey.isPresent()) {
            httpPost.setHeader("x-goog-api-key", (String)this.apiKey.get());
        } else {
            GoogleCredentials cred = (GoogleCredentials)this.credentials.orElseThrow(() -> new IllegalStateException("credentials is required"));
            cred.refreshIfExpired();
            httpPost.setHeader("Authorization", "Bearer " + cred.getAccessToken().getTokenValue());
        }
        httpPost.setEntity((HttpEntity)new StringEntity(requestJson));
        HttpApiResponse httpApiResponse = new HttpApiResponse(this.httpClient.execute((HttpUriRequest)httpPost));
        return httpApiResponse;
    }
}

