/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.google.genai.ApiClient;
import com.google.genai.Models;
import com.google.genai.ResponseStream;
import com.google.genai.Transformers;
import com.google.genai.types.Content;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.GenerateContentResponse;
import com.google.genai.types.GenerateImagesConfig;
import com.google.genai.types.GenerateImagesResponse;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.http.HttpException;

public final class AsyncModels {
    Models models;

    public AsyncModels(ApiClient apiClient) {
        this.models = new Models(apiClient);
    }

    public CompletableFuture<GenerateContentResponse> generateContent(String model, List<Content> contents, GenerateContentConfig config) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.models.generateContent(model, contents, config);
            }
            catch (IOException | HttpException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public CompletableFuture<ResponseStream<GenerateContentResponse>> generateContentStream(String model, List<Content> contents, GenerateContentConfig config) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.models.generateContentStream(model, contents, config);
            }
            catch (IOException | HttpException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public CompletableFuture<GenerateImagesResponse> generateImages(String model, String prompt, GenerateImagesConfig config) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.models.generateImages(model, prompt, config);
            }
            catch (IOException | HttpException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public CompletableFuture<GenerateContentResponse> generateContent(String model, Content content, GenerateContentConfig config) throws IOException, HttpException {
        return this.generateContent(model, Transformers.tContents(null, content), config);
    }

    public CompletableFuture<GenerateContentResponse> generateContent(String model, String text, GenerateContentConfig config) throws IOException, HttpException {
        return this.generateContent(model, Transformers.tContents(null, text), config);
    }

    public CompletableFuture<ResponseStream<GenerateContentResponse>> generateContentStream(String model, Content content, GenerateContentConfig config) throws IOException, HttpException {
        return this.generateContentStream(model, Transformers.tContents(null, content), config);
    }

    public CompletableFuture<ResponseStream<GenerateContentResponse>> generateContentStream(String model, String text, GenerateContentConfig config) throws IOException, HttpException {
        return this.generateContentStream(model, Transformers.tContents(null, text), config);
    }
}

