/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.genai.ApiResponse;
import com.google.genai.types.HttpOptions;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;

abstract class ApiClient {
    CloseableHttpClient httpClient;
    final Optional<String> apiKey;
    final Optional<String> project;
    final Optional<String> location;
    final Optional<GoogleCredentials> credentials;
    HttpOptions httpOptions;
    final boolean vertexAI;

    ApiClient(Optional<String> apiKey, Optional<HttpOptions> customHttpOptions) {
        Preconditions.checkNotNull(apiKey, (Object)"API Key cannot be null");
        Preconditions.checkNotNull(customHttpOptions, (Object)"customHttpOptions cannot be null");
        try {
            this.apiKey = Optional.of(apiKey.orElse(System.getenv("GOOGLE_API_KEY")));
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("API key must either be provided or set in the environment variable GOOGLE_API_KEY.", e);
        }
        this.project = Optional.empty();
        this.location = Optional.empty();
        this.credentials = Optional.empty();
        this.vertexAI = false;
        this.httpOptions = this.defaultHttpOptions(false, this.location);
        if (customHttpOptions.isPresent()) {
            this.applyHttpOptions(customHttpOptions.get());
        }
        this.httpClient = this.createHttpClient(this.httpOptions.timeout());
    }

    ApiClient(Optional<String> project, Optional<String> location, Optional<GoogleCredentials> credentials, Optional<HttpOptions> customHttpOptions) {
        Preconditions.checkNotNull(project, (Object)"project cannot be null");
        Preconditions.checkNotNull(location, (Object)"location cannot be null");
        Preconditions.checkNotNull(credentials, (Object)"credentials cannot be null");
        Preconditions.checkNotNull(customHttpOptions, (Object)"customHttpOptions cannot be null");
        try {
            this.project = Optional.of(project.orElse(System.getenv("GOOGLE_CLOUD_PROJECT")));
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Project must either be provided or set in the environment variable GOOGLE_CLOUD_PROJECT.", e);
        }
        if (this.project.get().isEmpty()) {
            throw new IllegalArgumentException("Project must not be empty.");
        }
        try {
            this.location = Optional.of(location.orElse(System.getenv("GOOGLE_CLOUD_LOCATION")));
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Location must either be provided or set in the environment variable GOOGLE_CLOUD_LOCATION.", e);
        }
        if (this.location.get().isEmpty()) {
            throw new IllegalArgumentException("Location must not be empty.");
        }
        try {
            this.credentials = Optional.of(credentials.orElse(GoogleCredentials.getApplicationDefault()));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to get application default credentials, please explicitly provide credentials.", e);
        }
        this.httpOptions = this.defaultHttpOptions(true, this.location);
        if (customHttpOptions.isPresent()) {
            this.applyHttpOptions(customHttpOptions.get());
        }
        this.apiKey = Optional.empty();
        this.vertexAI = true;
        this.httpClient = this.createHttpClient(this.httpOptions.timeout());
    }

    private CloseableHttpClient createHttpClient(Optional<Integer> timeout) {
        if (!timeout.isPresent()) {
            return HttpClients.createDefault();
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout.get().intValue()).setConnectionRequestTimeout(timeout.get().intValue()).setSocketTimeout(timeout.get().intValue()).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    public abstract ApiResponse post(String var1, String var2) throws IOException;

    String libraryVersion() {
        String libraryLabel = "google-genai-sdk/0.1.0";
        String languageLabel = "gl-java/" + System.getProperty("java.version");
        return libraryLabel + " " + languageLabel;
    }

    public boolean isVertexAI() {
        return this.vertexAI;
    }

    public String project() {
        return this.project.get();
    }

    public String location() {
        return this.location.get();
    }

    public String apiKey() {
        return this.apiKey.get();
    }

    CloseableHttpClient httpClient() {
        return this.httpClient;
    }

    private void applyHttpOptions(HttpOptions httpOptionsToApply) {
        HttpOptions.Builder mergedHttpOptionsBuilder = HttpOptions.builder();
        if (httpOptionsToApply.baseUrl().isPresent()) {
            mergedHttpOptionsBuilder.baseUrl(httpOptionsToApply.baseUrl().get());
        }
        if (httpOptionsToApply.apiVersion().isPresent()) {
            mergedHttpOptionsBuilder.apiVersion(httpOptionsToApply.apiVersion().get());
        }
        if (httpOptionsToApply.timeout().isPresent()) {
            mergedHttpOptionsBuilder.timeout(httpOptionsToApply.timeout().get());
        }
        if (httpOptionsToApply.headers().isPresent()) {
            ImmutableMap mergedHeaders = ImmutableMap.builder().putAll(httpOptionsToApply.headers().get()).putAll(this.httpOptions.headers().get()).build();
            mergedHttpOptionsBuilder.headers((Map<String, String>)mergedHeaders);
        }
        this.httpOptions = mergedHttpOptionsBuilder.build();
    }

    private HttpOptions defaultHttpOptions(Boolean isVertexAI, Optional<String> location) {
        ImmutableMap.Builder defaultHeaders = ImmutableMap.builder();
        defaultHeaders.put((Object)"Content-Type", (Object)"application/json");
        defaultHeaders.put((Object)"user-agent", (Object)this.libraryVersion());
        defaultHeaders.put((Object)"x-goog-api-client", (Object)this.libraryVersion());
        HttpOptions.Builder defaultHttpOptionsBuilder = HttpOptions.builder().headers((Map<String, String>)defaultHeaders.build());
        if (isVertexAI.booleanValue() && location.isPresent()) {
            defaultHttpOptionsBuilder.baseUrl(String.format("https://%s-aiplatform.googleapis.com/", location.get())).apiVersion("v1beta1");
        } else {
            if (isVertexAI.booleanValue() && !location.isPresent()) {
                throw new IllegalArgumentException("Location must be provided for Vertex AI APIs.");
            }
            defaultHttpOptionsBuilder.baseUrl("https://generativelanguage.googleapis.com/").apiVersion("v1beta");
        }
        return defaultHttpOptionsBuilder.build();
    }
}

