/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.VerifierFactory;
import org.apache.bcel.verifier.VerifierFactoryObserver;

public class VerifierFactoryListModel
implements VerifierFactoryObserver,
ListModel {
    private List<ListDataListener> listeners = new ArrayList<ListDataListener>();
    private Set<String> cache = new TreeSet<String>();

    public VerifierFactoryListModel() {
        VerifierFactory.attach(this);
        this.update(null);
    }

    public synchronized void update(String s) {
        int i;
        int size = this.listeners.size();
        Verifier[] verifiers = VerifierFactory.getVerifiers();
        int num_of_verifiers = verifiers.length;
        this.cache.clear();
        for (i = 0; i < num_of_verifiers; ++i) {
            this.cache.add(verifiers[i].getClassName());
        }
        for (i = 0; i < size; ++i) {
            ListDataEvent e = new ListDataEvent(this, 0, 0, num_of_verifiers - 1);
            this.listeners.get(i).contentsChanged(e);
        }
    }

    public synchronized void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    public synchronized int getSize() {
        return this.cache.size();
    }

    public synchronized String getElementAt(int index) {
        return this.cache.toArray(new String[this.cache.size()])[index];
    }
}

