/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.impl.cloudlink.enterprise.sdk.spring.validation;

import com.gluonhq.cloudlink.enterprise.sdk.spring.domain.PushNotificationTarget;
import com.gluonhq.impl.cloudlink.enterprise.sdk.spring.validation.ValidPushNotificationTarget;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class ValidPushNotificationTargetValidator
implements ConstraintValidator<ValidPushNotificationTarget, PushNotificationTarget> {
    public void initialize(ValidPushNotificationTarget constraintAnnotation) {
    }

    public boolean isValid(PushNotificationTarget target, ConstraintValidatorContext context) {
        if (target == null || target.getType() == null || target.getType() == PushNotificationTarget.Type.ALL_DEVICES) {
            return true;
        }
        PushNotificationTarget.Type type = target.getType();
        switch (type) {
            case TOPIC: {
                if (target.getTopic() != null && !target.getTopic().trim().isEmpty()) {
                    return true;
                }
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("topic").addConstraintViolation();
                return false;
            }
            case SINGLE_DEVICE: {
                if (target.getDeviceToken() != null && !target.getDeviceToken().trim().isEmpty()) {
                    return true;
                }
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addPropertyNode("deviceToken").addConstraintViolation();
                return false;
            }
        }
        return false;
    }
}

