/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.impl.cloudlink.enterprise.sdk.spring;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class ValidationExceptionMapper {
    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    @ResponseBody
    public String handle(ConstraintViolationException exception) {
        StringBuilder messageBuilder = new StringBuilder("Bean Validation failed:");
        int i = 1;
        for (ConstraintViolation violation : exception.getConstraintViolations()) {
            messageBuilder.append("\n\t").append(i++).append(". ").append("\tClass: ").append(violation.getRootBeanClass().getName());
            if (violation.getPropertyPath() != null && !violation.getPropertyPath().toString().isEmpty()) {
                messageBuilder.append("\n\t\tProperty: ").append(violation.getPropertyPath());
            }
            messageBuilder.append("\n\t\tMessage: ").append(violation.getMessage());
        }
        return messageBuilder.toString();
    }
}

