/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.impl.cloudlink.enterprise.sdk.spring;

import com.gluonhq.cloudlink.enterprise.sdk.spring.CloudLinkClientConfig;
import com.gluonhq.cloudlink.enterprise.sdk.spring.CloudLinkClientException;
import feign.FeignException;
import feign.Response;
import feign.codec.ErrorDecoder;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.logging.Level;

public class CloudLinkErrorDecoder
implements ErrorDecoder {
    private final CloudLinkClientConfig config;

    public CloudLinkErrorDecoder(CloudLinkClientConfig config) {
        this.config = config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Exception decode(String methodKey, Response response) {
        if (this.config.getLogLevel().intValue() > Level.FINE.intValue()) return new CloudLinkClientException(response.status(), response.reason());
        try (BufferedReader reader = new BufferedReader(response.body().asReader());){
            String line;
            StringBuilder body = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                body.append(line);
            }
            CloudLinkClientException cloudLinkClientException = new CloudLinkClientException(response.status(), response.reason(), body.toString());
            return cloudLinkClientException;
        }
        catch (IOException e) {
            return FeignException.errorStatus((String)methodKey, (Response)response);
        }
    }
}

