/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.cloudlink.enterprise.sdk.spring.domain;

import com.gluonhq.cloudlink.enterprise.sdk.spring.domain.PushNotificationTarget;
import com.gluonhq.impl.cloudlink.enterprise.sdk.spring.validation.MaxPushNotificationExpiration;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@MaxPushNotificationExpiration
public class PushNotification {
    private String identifier;
    private long creationDate;
    private String customIdentifier = "";
    private String title = "";
    private String body = "";
    private long deliveryDate = 0L;
    private Priority priority = Priority.NORMAL;
    private ExpirationType expirationType = ExpirationType.WEEKS;
    private int expirationAmount = 4;
    private PushNotificationTarget target = new PushNotificationTarget();
    private boolean invisible = false;

    public boolean isInvisible() {
        return this.invisible;
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    @NotNull
    public String getCustomIdentifier() {
        return this.customIdentifier;
    }

    public void setCustomIdentifier(String customIdentifier) {
        this.customIdentifier = customIdentifier;
    }

    @NotNull
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @NotNull
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    @Min(value=0L)
    public long getDeliveryDate() {
        return this.deliveryDate;
    }

    public void setDeliveryDate(long deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    @NotNull
    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    @NotNull
    public ExpirationType getExpirationType() {
        return this.expirationType;
    }

    public void setExpirationType(ExpirationType expirationType) {
        this.expirationType = expirationType;
    }

    public int getExpirationAmount() {
        return this.expirationAmount;
    }

    public void setExpirationAmount(int expirationAmount) {
        this.expirationAmount = expirationAmount;
    }

    @Valid
    @NotNull
    public PushNotificationTarget getTarget() {
        return this.target;
    }

    public void setTarget(PushNotificationTarget target) {
        this.target = target;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PushNotification that = (PushNotification)o;
        return this.identifier != null ? this.identifier.equals(that.identifier) : that.identifier == null;
    }

    public int hashCode() {
        return this.identifier != null ? this.identifier.hashCode() : 0;
    }

    public String toString() {
        return "PushNotification{identifier='" + this.identifier + '\'' + ", customIdentifier='" + this.customIdentifier + '\'' + ", title='" + this.title + '\'' + ", body='" + this.body + '\'' + ", deliveryDate=" + this.deliveryDate + ", priority=" + (Object)((Object)this.priority) + ", expirationType=" + (Object)((Object)this.expirationType) + ", expirationAmount=" + this.expirationAmount + ", target=" + this.target + ", invisible=" + this.invisible + '}';
    }

    public static enum ExpirationType {
        WEEKS(4),
        DAYS(7),
        HOURS(24),
        MINUTES(60);

        private int maxAmount;

        private ExpirationType(int maxAmount) {
            this.maxAmount = maxAmount;
        }

        public int getMaxAmount() {
            return this.maxAmount;
        }
    }

    public static enum Priority {
        HIGH,
        NORMAL;

    }
}

