/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.cloudlink.enterprise.sdk.spring;

import com.gluonhq.cloudlink.enterprise.sdk.spring.CloudLinkClientConfig;
import com.gluonhq.cloudlink.enterprise.sdk.spring.domain.ObjectData;
import com.gluonhq.cloudlink.enterprise.sdk.spring.domain.PushNotification;
import com.gluonhq.impl.cloudlink.enterprise.sdk.spring.CloudLinkAuthRequestInterceptor;
import com.gluonhq.impl.cloudlink.enterprise.sdk.spring.CloudLinkErrorDecoder;
import com.gluonhq.impl.cloudlink.enterprise.sdk.spring.FeignClient;
import com.gluonhq.impl.cloudlink.enterprise.sdk.spring.StringObject;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.Logger;
import feign.RequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.form.FormEncoder;
import feign.gson.GsonDecoder;
import feign.jaxrs.JAXRSContract;
import feign.okhttp.OkHttpClient;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@Validated
public class CloudLinkClient {
    private static final Logger LOG = new Logger.ErrorLogger();
    private static final Gson gson = new Gson();
    private final CloudLinkClientConfig config;
    private final FeignClient feignClient;

    public CloudLinkClient(CloudLinkClientConfig cloudLinkConfig) {
        this.config = Objects.requireNonNull(cloudLinkConfig);
        this.feignClient = this.buildFeignClient();
    }

    private FeignClient buildFeignClient() {
        String cloudLinkUrl = this.config.getHostname();
        if (!cloudLinkUrl.startsWith("http")) {
            cloudLinkUrl = "https://" + cloudLinkUrl;
        }
        return (FeignClient)Feign.builder().logger(LOG).logLevel(this.getLogLevel(this.config.getLogLevel())).contract((Contract)new JAXRSContract()).client((Client)new OkHttpClient()).encoder((Encoder)new FormEncoder()).decoder((Decoder)new GsonDecoder()).errorDecoder((ErrorDecoder)new CloudLinkErrorDecoder(this.config)).requestInterceptor((RequestInterceptor)new CloudLinkAuthRequestInterceptor(this.config.getServerKey())).target(FeignClient.class, cloudLinkUrl + "/3");
    }

    private Logger.Level getLogLevel(Level level) {
        if (level.intValue() <= Level.FINE.intValue()) {
            return Logger.Level.FULL;
        }
        if (level.intValue() <= Level.INFO.intValue()) {
            return Logger.Level.HEADERS;
        }
        if (level.intValue() <= Level.SEVERE.intValue()) {
            return Logger.Level.BASIC;
        }
        return Logger.Level.NONE;
    }

    private static <T> T fromJson(ObjectData objData, Class<T> objectType) {
        if (String.class.equals(objectType)) {
            return (T)((StringObject)gson.fromJson(objData.getPayload(), StringObject.class)).getV();
        }
        return (T)gson.fromJson(objData.getPayload(), objectType);
    }

    private static <T> String toJson(T target) {
        if (String.class.equals(target.getClass())) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("v", (String)target);
            return jsonObject.toString();
        }
        return gson.toJson(target);
    }

    public PushNotification sendPushNotification(@NotNull @Valid PushNotification notification) {
        Objects.requireNonNull(notification, "notification may not be null");
        return this.feignClient.sendPushNotification(notification.getCustomIdentifier(), notification.getTitle(), notification.getBody(), notification.getDeliveryDate(), notification.getPriority(), notification.getExpirationType(), notification.getExpirationAmount(), notification.getTarget().getType(), notification.getTarget().getTopic(), notification.getTarget().getDeviceToken(), notification.isInvisible());
    }

    public <T> T getObject(@NotNull @Size(min=1) String objectId, @NotNull Function<ObjectData, T> objectMapper) {
        Objects.requireNonNull(objectId, "objectId may not be null");
        Objects.requireNonNull(objectMapper, "objectMapper may not be null");
        ObjectData objData = this.feignClient.getObject(objectId);
        if (objData.getUid() == null) {
            return null;
        }
        return objectMapper.apply(objData);
    }

    public <T> T getObject(@NotNull @Size(min=1) String objectId, @NotNull Class<T> objectType) {
        Objects.requireNonNull(objectId, "objectId may not be null");
        Objects.requireNonNull(objectType, "objectType may not be null");
        ObjectData objData = this.feignClient.getObject(objectId);
        if (objData.getUid() == null) {
            return null;
        }
        return CloudLinkClient.fromJson(objData, objectType);
    }

    public <T> T addObject(@NotNull @Size(min=1) String objectId, @NotNull T target, @NotNull Function<ObjectData, T> objectMapper) {
        Objects.requireNonNull(objectId, "objectId may not be null");
        Objects.requireNonNull(target, "target may not be null");
        Objects.requireNonNull(objectMapper, "objectMapper may not be null");
        ObjectData objData = this.feignClient.addObject(objectId, CloudLinkClient.toJson(target));
        return objectMapper.apply(objData);
    }

    public <T> T addObject(@NotNull @Size(min=1) String objectId, @NotNull T target) {
        Objects.requireNonNull(objectId, "objectId may not be null");
        Objects.requireNonNull(target, "target may not be null");
        ObjectData objData = this.feignClient.addObject(objectId, CloudLinkClient.toJson(target));
        return (T)CloudLinkClient.fromJson(objData, target.getClass());
    }

    public <T> T updateObject(@NotNull @Size(min=1) String objectId, @NotNull T target, @NotNull Function<ObjectData, T> objectMapper) {
        Objects.requireNonNull(objectId, "objectId may not be null");
        Objects.requireNonNull(target, "target may not be null");
        Objects.requireNonNull(objectMapper, "objectMapper may not be null");
        ObjectData objData = this.feignClient.updateObject(objectId, CloudLinkClient.toJson(target));
        if (objData.getUid() == null) {
            return null;
        }
        return objectMapper.apply(objData);
    }

    public <T> T updateObject(@NotNull @Size(min=1) String objectId, @NotNull T target) {
        Objects.requireNonNull(objectId, "objectId may not be null");
        Objects.requireNonNull(target, "target may not be null");
        ObjectData objData = this.feignClient.updateObject(objectId, CloudLinkClient.toJson(target));
        if (objData.getUid() == null) {
            return null;
        }
        return (T)CloudLinkClient.fromJson(objData, target.getClass());
    }

    public void removeObject(@NotNull @Size(min=1) String objectId) {
        Objects.requireNonNull(objectId, "objectId may not be null");
        this.feignClient.removeObject(objectId);
    }

    public <T> List<T> getList(@NotNull @Size(min=1) String listId, @NotNull Function<ObjectData, T> objectMapper) {
        Objects.requireNonNull(listId, "listId may not be null");
        Objects.requireNonNull(objectMapper, "objectMapper may not be null");
        List<ObjectData> objDataList = this.feignClient.getList(listId);
        return objDataList.stream().map(objectMapper).collect(Collectors.toList());
    }

    public <T> List<T> getList(@NotNull @Size(min=1) String listId, @NotNull Class<T> objectType) {
        Objects.requireNonNull(listId, "listId may not be null");
        Objects.requireNonNull(objectType, "objectType may not be null");
        List<ObjectData> objDataList = this.feignClient.getList(listId);
        return objDataList.stream().map(objData -> CloudLinkClient.fromJson(objData, objectType)).collect(Collectors.toList());
    }

    public <T> T addToList(@NotNull @Size(min=1) String listId, @NotNull @Size(min=1) String objectId, @NotNull T target, @NotNull Function<ObjectData, T> objectMapper) {
        Objects.requireNonNull(listId, "listId may not be null");
        Objects.requireNonNull(objectId, "objectId may not be null");
        Objects.requireNonNull(target, "target may not be null");
        Objects.requireNonNull(objectMapper, "objectMapper may not be null");
        ObjectData objData = this.feignClient.addToList(listId, objectId, gson.toJson(target));
        return objectMapper.apply(objData);
    }

    public <T> T addToList(@NotNull @Size(min=1) String listId, @NotNull @Size(min=1) String objectId, @NotNull T target) {
        Objects.requireNonNull(listId, "listId may not be null");
        Objects.requireNonNull(objectId, "objectId may not be null");
        Objects.requireNonNull(target, "target may not be null");
        ObjectData objData = this.feignClient.addToList(listId, objectId, gson.toJson(target));
        return (T)CloudLinkClient.fromJson(objData, target.getClass());
    }

    public <T> T updateInList(@NotNull @Size(min=1) String listId, @NotNull @Size(min=1) String objectId, @NotNull T target, @NotNull Function<ObjectData, T> objectMapper) {
        Objects.requireNonNull(listId, "listId may not be null");
        Objects.requireNonNull(objectId, "objectId may not be null");
        Objects.requireNonNull(target, "target may not be null");
        Objects.requireNonNull(objectMapper, "objectMapper may not be null");
        ObjectData objData = this.feignClient.updateInList(listId, objectId, gson.toJson(target));
        if (objData.getUid() == null) {
            return null;
        }
        return objectMapper.apply(objData);
    }

    public <T> T updateInList(@NotNull @Size(min=1) String listId, @NotNull @Size(min=1) String objectId, @NotNull T target) {
        Objects.requireNonNull(listId, "listId may not be null");
        Objects.requireNonNull(objectId, "objectId may not be null");
        Objects.requireNonNull(target, "target may not be null");
        ObjectData objData = this.feignClient.updateInList(listId, objectId, gson.toJson(target));
        if (objData.getUid() == null) {
            return null;
        }
        return (T)CloudLinkClient.fromJson(objData, target.getClass());
    }

    public void removeFromList(@NotNull @Size(min=1) String listId, @NotNull @Size(min=1) String objectId) {
        Objects.requireNonNull(listId, "listId may not be null");
        Objects.requireNonNull(objectId, "objectId may not be null");
        this.feignClient.removeFromList(listId, objectId);
    }
}

