/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.base.mapper;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.MPJTableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.MPJTableInfo;
import com.baomidou.mybatisplus.core.metadata.MPJTableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.yulichang.base.mapper.wrapper.MappingQuery;
import com.github.yulichang.toolkit.LambdaUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public interface MPJDeepMapper<T>
extends BaseMapper<T> {
    default public T selectByIdDeep(Serializable id) {
        return (T)this.mpjQueryMapping(this.selectById(id), null);
    }

    default public <R> T selectByIdDeep(Serializable id, SFunction<T, R> ... property) {
        return (T)this.mpjQueryMapping(this.selectById(id), Arrays.asList(property));
    }

    default public <R> T selectByIdDeep(Serializable id, List<SFunction<T, R>> property) {
        return (T)this.mpjQueryMapping(this.selectById(id), property);
    }

    default public List<T> selectBatchIdsDeep(Collection<? extends Serializable> idList) {
        return this.mpjQueryMapping(this.selectBatchIds(idList), (List)null);
    }

    default public <R> List<T> selectBatchIdsDeep(Collection<? extends Serializable> idList, SFunction<T, R> ... property) {
        return this.mpjQueryMapping(this.selectBatchIds(idList), Arrays.asList(property));
    }

    default public <R> List<T> selectBatchIdsDeep(Collection<? extends Serializable> idList, List<SFunction<T, R>> property) {
        return this.mpjQueryMapping(this.selectBatchIds(idList), property);
    }

    default public List<T> selectByMapDeep(Map<String, Object> columnMap) {
        return this.mpjQueryMapping(this.selectByMap(columnMap), (List)null);
    }

    default public <R> List<T> selectByMapDeep(Map<String, Object> columnMap, SFunction<T, R> ... property) {
        return this.mpjQueryMapping(this.selectByMap(columnMap), Arrays.asList(property));
    }

    default public <R> List<T> selectByMapDeep(Map<String, Object> columnMap, List<SFunction<T, R>> property) {
        return this.mpjQueryMapping(this.selectByMap(columnMap), property);
    }

    default public T selectOneDeep(Wrapper<T> queryWrapper) {
        return (T)this.mpjQueryMapping(this.selectOne(queryWrapper), null);
    }

    default public <R> T selectOneDeep(Wrapper<T> queryWrapper, SFunction<T, R> ... property) {
        return (T)this.mpjQueryMapping(this.selectOne(queryWrapper), Arrays.asList(property));
    }

    default public <R> T selectOneDeep(Wrapper<T> queryWrapper, List<SFunction<T, R>> property) {
        return (T)this.mpjQueryMapping(this.selectOne(queryWrapper), property);
    }

    default public List<T> selectListDeep(Wrapper<T> queryWrapper) {
        return this.mpjQueryMapping(this.selectList(queryWrapper), (List)null);
    }

    default public <R> List<T> selectListDeep(Wrapper<T> queryWrapper, SFunction<T, R> ... property) {
        return this.mpjQueryMapping(this.selectList(queryWrapper), Arrays.asList(property));
    }

    default public <R> List<T> selectListDeep(Wrapper<T> queryWrapper, List<SFunction<T, R>> property) {
        return this.mpjQueryMapping(this.selectList(queryWrapper), property);
    }

    default public List<Map<String, Object>> selectMapsDeep(Class<T> clazz, Wrapper<T> queryWrapper) {
        return this.mpjQueryMapMapping(this.selectMaps(queryWrapper), clazz, null);
    }

    default public <R> List<Map<String, Object>> selectMapsDeep(Class<T> clazz, Wrapper<T> queryWrapper, SFunction<T, R> ... property) {
        return this.mpjQueryMapMapping(this.selectMaps(queryWrapper), clazz, Arrays.asList(property));
    }

    default public <R> List<Map<String, Object>> selectMapsDeep(Class<T> clazz, Wrapper<T> queryWrapper, List<SFunction<T, R>> property) {
        return this.mpjQueryMapMapping(this.selectMaps(queryWrapper), clazz, property);
    }

    default public <E extends IPage<T>> E selectPageDeep(E page, Wrapper<T> queryWrapper) {
        IPage e = this.selectPage(page, queryWrapper);
        this.mpjQueryMapping(e.getRecords(), (List)null);
        return (E)e;
    }

    default public <R, E extends IPage<T>> E selectPageDeep(E page, Wrapper<T> queryWrapper, SFunction<T, R> ... property) {
        IPage e = this.selectPage(page, queryWrapper);
        this.mpjQueryMapping(e.getRecords(), Arrays.asList(property));
        return (E)e;
    }

    default public <R, E extends IPage<T>> E selectPageDeep(E page, Wrapper<T> queryWrapper, List<SFunction<T, R>> property) {
        IPage e = this.selectPage(page, queryWrapper);
        this.mpjQueryMapping(e.getRecords(), property);
        return (E)e;
    }

    default public <R, E extends IPage<Map<String, Object>>> E selectMapsPageDeep(E page, Class<T> clazz, Wrapper<T> queryWrapper) {
        IPage e = this.selectMapsPage(page, queryWrapper);
        this.mpjQueryMapMapping(e.getRecords(), clazz, null);
        return (E)e;
    }

    default public <R, E extends IPage<Map<String, Object>>> E selectMapsPageDeep(E page, Class<T> clazz, Wrapper<T> queryWrapper, SFunction<T, R> ... property) {
        IPage e = this.selectMapsPage(page, queryWrapper);
        this.mpjQueryMapMapping(e.getRecords(), clazz, Arrays.asList(property));
        return (E)e;
    }

    default public <R, E extends IPage<Map<String, Object>>> E selectMapsPageDeep(E page, Class<T> clazz, Wrapper<T> queryWrapper, List<SFunction<T, R>> property) {
        IPage e = this.selectMapsPage(page, queryWrapper);
        this.mpjQueryMapMapping(e.getRecords(), clazz, property);
        return (E)e;
    }

    default public <R> T mpjQueryMapping(T t, List<SFunction<T, R>> property) {
        if (t == null) {
            return null;
        }
        MPJTableInfo tableInfo = MPJTableInfoHelper.getTableInfo(t.getClass());
        if (tableInfo.isHasMappingOrField()) {
            boolean hasProperty = CollectionUtils.isNotEmpty(property);
            List list = hasProperty ? property.stream().map(LambdaUtils::getName).collect(Collectors.toList()) : null;
            for (MPJTableFieldInfo fieldInfo : tableInfo.getFieldList()) {
                Object obj;
                if (hasProperty && !list.contains(fieldInfo.getProperty()) || (obj = fieldInfo.thisFieldGet(t)) == null) continue;
                List<?> joinList = MappingQuery.mpjQueryList(fieldInfo.getJoinMapper(), fieldInfo.isFieldIsMap(), SqlKeyword.EQ, fieldInfo.getJoinColumn(), obj, fieldInfo);
                this.mpjBindData(t, fieldInfo, joinList);
                fieldInfo.removeJoinField(joinList);
            }
        }
        return t;
    }

    default public <R> Map<String, Object> mpjQueryMapMapping(Map<String, Object> map, Class<T> clazz, List<SFunction<T, R>> property) {
        if (CollectionUtils.isEmpty(map)) {
            return map;
        }
        MPJTableInfo tableInfo = MPJTableInfoHelper.getTableInfo(clazz);
        if (tableInfo.isHasMappingOrField()) {
            boolean hasProperty = CollectionUtils.isNotEmpty(property);
            List list = hasProperty ? property.stream().map(LambdaUtils::getName).collect(Collectors.toList()) : null;
            for (MPJTableFieldInfo fieldInfo : tableInfo.getFieldList()) {
                Object obj;
                if (hasProperty && !list.contains(fieldInfo.getProperty()) || (obj = map.get(fieldInfo.getThisMapKey())) == null) continue;
                List<?> joinList = MappingQuery.mpjQueryList(fieldInfo.getJoinMapper(), fieldInfo.isFieldIsMap(), SqlKeyword.EQ, fieldInfo.getJoinColumn(), obj, fieldInfo);
                this.mpjBindMap(map, fieldInfo, joinList);
                fieldInfo.removeJoinField(joinList);
            }
        }
        return map;
    }

    default public <R> List<T> mpjQueryMapping(List<T> list, List<SFunction<T, R>> property) {
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        MPJTableInfo tableInfo = MPJTableInfoHelper.getTableInfo(list.get(0).getClass());
        if (tableInfo.isHasMappingOrField()) {
            boolean hasProperty = CollectionUtils.isNotEmpty(property);
            List listProperty = hasProperty ? property.stream().map(LambdaUtils::getName).collect(Collectors.toList()) : null;
            for (MPJTableFieldInfo fieldInfo : tableInfo.getFieldList()) {
                List itemList;
                if (hasProperty) {
                    if (!listProperty.contains(fieldInfo.getProperty())) continue;
                }
                if (CollectionUtils.isNotEmpty(itemList = list.stream().map(fieldInfo::thisFieldGet).collect(Collectors.toList()))) {
                    List<?> joinList = MappingQuery.mpjQueryList(fieldInfo.getJoinMapper(), fieldInfo.isMappingEntity() && fieldInfo.isFieldIsMap(), SqlKeyword.IN, fieldInfo.getJoinColumn(), itemList, fieldInfo);
                    list.forEach(i -> this.mpjBindData(i, fieldInfo, joinList));
                    fieldInfo.removeJoinField(joinList);
                    continue;
                }
                list.forEach(i -> fieldInfo.fieldSet(i, new ArrayList()));
            }
        }
        return list;
    }

    default public <R> List<Map<String, Object>> mpjQueryMapMapping(List<Map<String, Object>> list, Class<T> clazz, List<SFunction<T, R>> property) {
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        MPJTableInfo tableInfo = MPJTableInfoHelper.getTableInfo(clazz);
        if (tableInfo.isHasMappingOrField()) {
            boolean hasProperty = CollectionUtils.isNotEmpty(property);
            List listProperty = hasProperty ? property.stream().map(LambdaUtils::getName).collect(Collectors.toList()) : null;
            for (MPJTableFieldInfo fieldInfo : tableInfo.getFieldList()) {
                if (hasProperty && !listProperty.contains(fieldInfo.getProperty())) continue;
                List itemList = list.stream().map(m -> m.get(fieldInfo.getThisMapKey())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(itemList)) {
                    List<?> joinList = MappingQuery.mpjQueryList(fieldInfo.getJoinMapper(), fieldInfo.isMappingEntity() && fieldInfo.isFieldIsMap(), SqlKeyword.IN, fieldInfo.getJoinColumn(), itemList, fieldInfo);
                    list.forEach(i -> this.mpjBindMap((Map<String, Object>)i, fieldInfo, joinList));
                    fieldInfo.removeJoinField(joinList);
                    continue;
                }
                list.forEach(i -> i.put(fieldInfo.getField().getName(), new ArrayList()));
            }
        }
        return list;
    }

    default public void mpjBindData(T t, MPJTableFieldInfo fieldInfo, List<?> joinList) {
        if (fieldInfo.isMappingEntity()) {
            List list = joinList.stream().filter(j -> fieldInfo.joinFieldGet(j).equals(fieldInfo.thisFieldGet(t))).collect(Collectors.toList());
            MPJTableFieldInfo.bind(fieldInfo, t, list);
        }
        if (fieldInfo.isMappingField()) {
            MPJTableFieldInfo.bind(fieldInfo, t, joinList.stream().filter(j -> fieldInfo.joinFieldGet(j).equals(fieldInfo.thisFieldGet(t))).map(fieldInfo::bindFieldGet).collect(Collectors.toList()));
        }
    }

    default public void mpjBindMap(Map<String, Object> t, MPJTableFieldInfo fieldInfo, List<?> joinList) {
        List list = null;
        if (fieldInfo.isMappingEntity()) {
            list = fieldInfo.isFieldIsMap() ? joinList.stream().filter(j -> j.get(fieldInfo.getJoinMapKey()).equals(t.get(fieldInfo.getThisMapKey()))).collect(Collectors.toList()) : joinList.stream().filter(j -> fieldInfo.joinFieldGet(j).equals(t.get(fieldInfo.getThisMapKey()))).collect(Collectors.toList());
        }
        if (fieldInfo.isMappingField()) {
            list = joinList.stream().filter(j -> fieldInfo.joinFieldGet(j).equals(t.get(fieldInfo.getThisMapKey()))).map(fieldInfo::bindFieldGet).collect(Collectors.toList());
        }
        MPJTableFieldInfo.bindMap(fieldInfo, t, list);
    }
}

