/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.calendar;

import com.xkzhangsan.time.LunarDate;
import com.xkzhangsan.time.calculator.DateTimeCalculatorUtil;
import com.xkzhangsan.time.converter.DateTimeConverterUtil;
import com.xkzhangsan.time.formatter.DateTimeFormatterUtil;
import com.xkzhangsan.time.holiday.Holiday;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;

public class DayWrapper
implements Serializable {
    private static final long serialVersionUID = 5710793952115910594L;
    private Date date;
    private LocalDateTime localDateTime;
    private String dateStr;
    private int day;
    private int week;
    private String weekCnShort;
    private String weekCnLong;
    private String weekEnShort;
    private String weekEnShortUpper;
    private String weekEnLong;
    private String localHoliday;
    private LunarDate lunarDate;
    private String chineseHoliday;
    private String lunarDateStr;
    private String lunarDay;
    private String solarTerm;
    private int dateType;
    private Object obj;

    public DayWrapper(LocalDateTime localDateTime) {
        this(localDateTime, false);
    }

    public DayWrapper(LocalDateTime localDateTime, boolean includeLunarDate) {
        this(localDateTime, includeLunarDate, false, null, null);
    }

    public DayWrapper(LocalDateTime localDateTime, boolean includeLunarDate, boolean includeHoliday, Map<String, String> localHolidayMap, Map<String, String> chineseHolidayMap) {
        this(localDateTime, null, includeLunarDate, includeHoliday, localHolidayMap, chineseHolidayMap);
    }

    public DayWrapper(LocalDateTime localDateTime, Object obj, boolean includeLunarDate, boolean includeHoliday, Map<String, String> localHolidayMap, Map<String, String> chineseHolidayMap) {
        this.localDateTime = localDateTime;
        this.date = DateTimeConverterUtil.toDate(localDateTime);
        this.dateStr = DateTimeFormatterUtil.formatToDateStr(localDateTime);
        this.day = localDateTime.getDayOfMonth();
        this.week = localDateTime.getDayOfWeek().getValue();
        this.weekCnShort = DateTimeCalculatorUtil.getDayOfWeekCnShort(localDateTime);
        this.weekCnLong = DateTimeCalculatorUtil.getDayOfWeekCn(localDateTime);
        this.weekEnShort = DateTimeCalculatorUtil.getDayOfWeekEnShort(localDateTime);
        this.weekEnShortUpper = DateTimeCalculatorUtil.getDayOfWeekEnShortUpper(localDateTime);
        this.weekEnLong = DateTimeCalculatorUtil.getDayOfWeekEnLong(localDateTime);
        this.obj = obj;
        if (includeLunarDate) {
            this.lunarDate = LunarDate.from(localDateTime);
            this.lunarDateStr = this.lunarDate.getlDateCn();
            this.lunarDay = this.lunarDate.getlDayCn();
            this.solarTerm = this.lunarDate.getSolarTerm();
        }
        if (includeHoliday) {
            this.localHoliday = Holiday.getLocalHoliday(localDateTime, localHolidayMap);
            if (includeLunarDate) {
                this.chineseHoliday = Holiday.getChineseHoliday(localDateTime, chineseHolidayMap);
            }
        }
        this.dateType = DateTimeCalculatorUtil.isWorkDay(localDateTime) ? 1 : 0;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public LocalDateTime getLocalDateTime() {
        return this.localDateTime;
    }

    public void setLocalDateTime(LocalDateTime localDateTime) {
        this.localDateTime = localDateTime;
    }

    public Object getObj() {
        return this.obj;
    }

    public void setObj(Object obj) {
        this.obj = obj;
    }

    public String getDateStr() {
        return this.dateStr;
    }

    public void setDateStr(String dateStr) {
        this.dateStr = dateStr;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public String getWeekCnShort() {
        return this.weekCnShort;
    }

    public void setWeekCnShort(String weekCnShort) {
        this.weekCnShort = weekCnShort;
    }

    public String getWeekEnShort() {
        return this.weekEnShort;
    }

    public void setWeekEnShort(String weekEnShort) {
        this.weekEnShort = weekEnShort;
    }

    public String getWeekEnShortUpper() {
        return this.weekEnShortUpper;
    }

    public void setWeekEnShortUpper(String weekEnShortUpper) {
        this.weekEnShortUpper = weekEnShortUpper;
    }

    public String getWeekCnLong() {
        return this.weekCnLong;
    }

    public void setWeekCnLong(String weekCnLong) {
        this.weekCnLong = weekCnLong;
    }

    public String getWeekEnLong() {
        return this.weekEnLong;
    }

    public void setWeekEnLong(String weekEnLong) {
        this.weekEnLong = weekEnLong;
    }

    public LunarDate getLunarDate() {
        return this.lunarDate;
    }

    public void setLunarDate(LunarDate lunarDate) {
        this.lunarDate = lunarDate;
    }

    public String getLocalHoliday() {
        return this.localHoliday;
    }

    public void setLocalHoliday(String localHoliday) {
        this.localHoliday = localHoliday;
    }

    public String getChineseHoliday() {
        return this.chineseHoliday;
    }

    public void setChineseHoliday(String chineseHoliday) {
        this.chineseHoliday = chineseHoliday;
    }

    public String getSolarTerm() {
        return this.solarTerm;
    }

    public void setSolarTerm(String solarTerm) {
        this.solarTerm = solarTerm;
    }

    public String getLunarDateStr() {
        return this.lunarDateStr;
    }

    public void setLunarDateStr(String lunarDateStr) {
        this.lunarDateStr = lunarDateStr;
    }

    public int getWeek() {
        return this.week;
    }

    public void setWeek(int week) {
        this.week = week;
    }

    public int getDateType() {
        return this.dateType;
    }

    public void setDateType(int dateType) {
        this.dateType = dateType;
    }

    public String getLunarDay() {
        return this.lunarDay;
    }

    public void setLunarDay(String lunarDay) {
        this.lunarDay = lunarDay;
    }
}

