/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.utils;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ByteUtil {
    private ByteUtil() {
    }

    public static byte toByte(int data) {
        return (byte)(data & 0xFF);
    }

    public static int toUInt8(byte data) {
        return data & 0xFF;
    }

    public static int toUInt8(byte[] data) {
        return ByteUtil.toUInt8(data, 0);
    }

    public static int toUInt8(byte[] data, int offset) {
        if (data.length < 1) {
            throw new IndexOutOfBoundsException("data length < 1");
        }
        if (offset + 1 > data.length) {
            throw new IndexOutOfBoundsException("offset + 1 > data length");
        }
        return data[offset] & 0xFF;
    }

    public static int toUInt8(byte data, int startBitIndex, int bitLength) {
        if (startBitIndex < 0 || startBitIndex > 7) {
            throw new IllegalArgumentException("The start bit index can only be[0,7]");
        }
        if (startBitIndex + bitLength > 8) {
            throw new IllegalArgumentException("startBitIndex + length > 8");
        }
        return data >> startBitIndex & ((int)Math.pow(2.0, bitLength) - 1 & 0xFF);
    }

    public static String toStr(byte[] data) {
        return ByteUtil.toStr(data, 0, data.length, StandardCharsets.US_ASCII);
    }

    public static String toStr(byte[] data, int offset) {
        return ByteUtil.toStr(data, offset, data.length - offset, StandardCharsets.US_ASCII);
    }

    public static String toStr(byte[] data, int offset, int length) {
        return ByteUtil.toStr(data, offset, length, StandardCharsets.US_ASCII);
    }

    public static String toStr(byte[] data, int offset, int length, Charset charsetName) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset < 0");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (offset > data.length || offset + length > data.length) {
            throw new IllegalArgumentException("offset > data length || offset + length > data length");
        }
        return new String(data, offset, length, charsetName).trim();
    }
}

