/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.utils;

import com.github.xingshuangs.iot.protocol.s7.enums.EArea;
import com.github.xingshuangs.iot.protocol.s7.enums.EParamVariableType;
import com.github.xingshuangs.iot.protocol.s7.model.RequestItem;
import java.util.regex.Pattern;

public class AddressUtil {
    private AddressUtil() {
    }

    public static RequestItem parseByte(String address, int count) {
        return AddressUtil.parse(address, count, EParamVariableType.BYTE);
    }

    public static RequestItem parseBit(String address) {
        return AddressUtil.parse(address, 1, EParamVariableType.BIT);
    }

    public static RequestItem parse(String address, int count, EParamVariableType variableType) {
        if (address == null || address.length() == 0) {
            throw new IllegalArgumentException("address is null or empty");
        }
        if (count <= 0) {
            throw new IllegalArgumentException("count must be positive");
        }
        address = address.toUpperCase();
        String[] addList = address.split("\\.");
        RequestItem item = new RequestItem();
        item.setVariableType(variableType);
        item.setCount(count);
        item.setArea(AddressUtil.parseArea(addList));
        item.setDbNumber(AddressUtil.parseDbNumber(addList));
        item.setByteAddress(AddressUtil.parseByteAddress(addList));
        item.setBitAddress(AddressUtil.parseBitAddress(addList, variableType));
        if (item.getBitAddress() > 7) {
            throw new IllegalArgumentException("address address information format is incorrect, the bit index can only be [0-7]");
        }
        return item;
    }

    private static EArea parseArea(String[] addList) {
        switch (addList[0].substring(0, 1)) {
            case "I": {
                return EArea.INPUTS;
            }
            case "Q": {
                return EArea.OUTPUTS;
            }
            case "M": {
                return EArea.FLAGS;
            }
            case "D": 
            case "V": {
                return EArea.DATA_BLOCKS;
            }
            case "T": {
                return EArea.S7_TIMERS;
            }
            case "C": {
                return EArea.S7_COUNTERS;
            }
        }
        throw new IllegalArgumentException("The parameter passed in was incorrect and the Area could not be resolved");
    }

    private static int parseDbNumber(String[] addList) {
        switch (addList[0].substring(0, 1)) {
            case "D": {
                return AddressUtil.extractNumber(addList[0]);
            }
            case "V": {
                return 1;
            }
        }
        return 0;
    }

    private static int parseByteAddress(String[] addList) {
        switch (addList[0].substring(0, 1)) {
            case "D": {
                return addList.length >= 2 ? AddressUtil.extractNumber(addList[1]) : 0;
            }
        }
        return AddressUtil.extractNumber(addList[0]);
    }

    private static int parseBitAddress(String[] addList, EParamVariableType variableType) {
        switch (addList[0].substring(0, 1)) {
            case "D": {
                return addList.length >= 3 && variableType == EParamVariableType.BIT ? AddressUtil.extractNumber(addList[2]) : 0;
            }
        }
        return addList.length >= 2 && variableType == EParamVariableType.BIT ? AddressUtil.extractNumber(addList[1]) : 0;
    }

    public static String parseArea(RequestItem item) {
        switch (item.getArea()) {
            case DATA_BLOCKS: {
                return "DB" + item.getDbNumber();
            }
            case INPUTS: {
                return "I";
            }
            case OUTPUTS: {
                return "Q";
            }
            case FLAGS: {
                return "M";
            }
            case S7_TIMERS: {
                return "T";
            }
            case S7_COUNTERS: {
                return "C";
            }
        }
        throw new IllegalArgumentException("This area is not accessible");
    }

    public static int extractNumber(String src) {
        String number = Pattern.compile("\\D").matcher(src).replaceAll("").trim();
        return Integer.parseInt(number);
    }
}

