/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.s7.enums.EFunctionCode;
import com.github.xingshuangs.iot.protocol.s7.model.UploadAckParameter;
import com.github.xingshuangs.iot.utils.BooleanUtil;
import java.util.Arrays;

public class UploadParameter
extends UploadAckParameter {
    protected byte[] errorCode = new byte[]{0, 0};
    protected long id = 0L;

    public UploadParameter() {
        this.functionCode = EFunctionCode.UPLOAD;
    }

    @Override
    public int byteArrayLength() {
        return 8;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(8).putByte(this.functionCode.getCode()).putByte((byte)(BooleanUtil.setBit(0, this.moreDataFollowing) | BooleanUtil.setBit(1, this.errorStatus))).putBytes(this.errorCode).putInteger(this.id).getData();
    }

    public static UploadParameter fromBytes(byte[] data) {
        return UploadParameter.fromBytes(data, 0);
    }

    public static UploadParameter fromBytes(byte[] data, int offset) {
        if (data.length < 8) {
            throw new IndexOutOfBoundsException("UploadParameter\u65f6, data length < 8");
        }
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        UploadParameter res = new UploadParameter();
        res.functionCode = EFunctionCode.from(buff.getByte());
        byte b = buff.getByte();
        res.moreDataFollowing = BooleanUtil.getValue(b, 0);
        res.errorStatus = BooleanUtil.getValue(b, 1);
        res.errorCode = buff.getBytes(2);
        res.id = buff.getUInt32();
        return res;
    }

    public static UploadParameter createDefault(long uploadId) {
        UploadParameter parameter = new UploadParameter();
        parameter.id = uploadId;
        return parameter;
    }

    public byte[] getErrorCode() {
        return this.errorCode;
    }

    public long getId() {
        return this.id;
    }

    public void setErrorCode(byte[] errorCode) {
        this.errorCode = errorCode;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadParameter)) {
            return false;
        }
        UploadParameter other = (UploadParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        return Arrays.equals(this.getErrorCode(), other.getErrorCode());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UploadParameter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + Arrays.hashCode(this.getErrorCode());
        return result;
    }

    @Override
    public String toString() {
        return "UploadParameter(errorCode=" + Arrays.toString(this.getErrorCode()) + ", id=" + this.getId() + ")";
    }
}

