/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.s7.enums.EDestinationFileSystem;
import com.github.xingshuangs.iot.protocol.s7.enums.EFileBlockType;
import com.github.xingshuangs.iot.protocol.s7.enums.EFunctionCode;
import com.github.xingshuangs.iot.protocol.s7.model.DownloadParameter;
import com.github.xingshuangs.iot.utils.BooleanUtil;

public class StartUploadParameter
extends DownloadParameter {
    public StartUploadParameter() {
        this.functionCode = EFunctionCode.START_UPLOAD;
        this.errorCode = new byte[]{0, 0};
    }

    public static StartUploadParameter createDefault(EFileBlockType blockType, int blockNumber, EDestinationFileSystem destinationFileSystem) {
        StartUploadParameter parameter = new StartUploadParameter();
        parameter.blockType = blockType;
        parameter.blockNumber = blockNumber;
        parameter.destinationFileSystem = destinationFileSystem;
        return parameter;
    }

    public static StartUploadParameter fromBytes(byte[] data) {
        return StartUploadParameter.fromBytes(data, 0);
    }

    public static StartUploadParameter fromBytes(byte[] data, int offset) {
        if (data.length < 18) {
            throw new IndexOutOfBoundsException("DownloadParameter, data length < 18");
        }
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        StartUploadParameter res = new StartUploadParameter();
        res.functionCode = EFunctionCode.from(buff.getByte());
        byte b = buff.getByte();
        res.moreDataFollowing = BooleanUtil.getValue(b, 0);
        res.errorStatus = BooleanUtil.getValue(b, 1);
        res.errorCode = buff.getBytes(2);
        res.id = buff.getUInt32();
        res.fileNameLength = buff.getByteToInt();
        res.fileIdentifier = buff.getString(1);
        res.blockType = EFileBlockType.from(buff.getString(2));
        res.blockNumber = Integer.parseInt(buff.getString(5));
        res.destinationFileSystem = EDestinationFileSystem.from(buff.getByte());
        return res;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StartUploadParameter)) {
            return false;
        }
        StartUploadParameter other = (StartUploadParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StartUploadParameter;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "StartUploadParameter()";
    }
}

