/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.s7.enums.EFunctionCode;
import com.github.xingshuangs.iot.protocol.s7.model.UploadParameter;
import com.github.xingshuangs.iot.utils.BooleanUtil;

public class StartUploadAckParameter
extends UploadParameter {
    private int blockLengthStringLength = 7;
    private int blockLength = 0;

    public StartUploadAckParameter() {
        this.functionCode = EFunctionCode.START_UPLOAD;
        this.errorCode = new byte[]{1, 0};
    }

    @Override
    public int byteArrayLength() {
        return 16;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(16).putByte(this.functionCode.getCode()).putByte((byte)(BooleanUtil.setBit(0, this.moreDataFollowing) | BooleanUtil.setBit(1, this.errorStatus))).putBytes(this.errorCode).putInteger(this.id).putByte(this.blockLengthStringLength).putString(String.format("%07d", this.blockLength)).getData();
    }

    public static StartUploadAckParameter fromBytes(byte[] data) {
        return StartUploadAckParameter.fromBytes(data, 0);
    }

    public static StartUploadAckParameter fromBytes(byte[] data, int offset) {
        if (data.length < 8) {
            throw new IndexOutOfBoundsException("StartUploadAckParameter, data length < 8");
        }
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        StartUploadAckParameter res = new StartUploadAckParameter();
        res.functionCode = EFunctionCode.from(buff.getByte());
        byte b = buff.getByte();
        res.moreDataFollowing = BooleanUtil.getValue(b, 0);
        res.errorStatus = BooleanUtil.getValue(b, 1);
        res.errorCode = buff.getBytes(2);
        res.id = buff.getUInt32();
        res.blockLengthStringLength = buff.getByteToInt();
        res.blockLength = Integer.parseInt(buff.getString(res.blockLengthStringLength));
        return res;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StartUploadAckParameter)) {
            return false;
        }
        StartUploadAckParameter other = (StartUploadAckParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getBlockLengthStringLength() != other.getBlockLengthStringLength()) {
            return false;
        }
        return this.getBlockLength() == other.getBlockLength();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StartUploadAckParameter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getBlockLengthStringLength();
        result = result * 59 + this.getBlockLength();
        return result;
    }

    public int getBlockLengthStringLength() {
        return this.blockLengthStringLength;
    }

    public int getBlockLength() {
        return this.blockLength;
    }

    public void setBlockLengthStringLength(int blockLengthStringLength) {
        this.blockLengthStringLength = blockLengthStringLength;
    }

    public void setBlockLength(int blockLength) {
        this.blockLength = blockLength;
    }

    @Override
    public String toString() {
        return "StartUploadAckParameter(blockLengthStringLength=" + this.getBlockLengthStringLength() + ", blockLength=" + this.getBlockLength() + ")";
    }
}

