/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.s7.enums.EFunctionCode;
import com.github.xingshuangs.iot.protocol.s7.model.Parameter;

public class SetupComParameter
extends Parameter
implements IObjectByteArray {
    public static final int BYTE_LENGTH = 8;
    private byte reserved = 0;
    private int maxAmqCaller = 1;
    private int maxAmqCallee = 1;
    private int pduLength = 0;

    @Override
    public int byteArrayLength() {
        return 8;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(8).putByte(this.functionCode.getCode()).putByte(this.reserved).putShort(this.maxAmqCaller).putShort(this.maxAmqCallee).putShort(this.pduLength).getData();
    }

    public static SetupComParameter fromBytes(byte[] data) {
        ByteReadBuff buff = new ByteReadBuff(data);
        SetupComParameter setupComParameter = new SetupComParameter();
        setupComParameter.functionCode = EFunctionCode.from(buff.getByte());
        setupComParameter.reserved = buff.getByte();
        setupComParameter.maxAmqCaller = buff.getUInt16();
        setupComParameter.maxAmqCallee = buff.getUInt16();
        setupComParameter.pduLength = buff.getUInt16();
        return setupComParameter;
    }

    public static SetupComParameter createDefault(int pduLength) {
        SetupComParameter parameter = new SetupComParameter();
        parameter.functionCode = EFunctionCode.SETUP_COMMUNICATION;
        parameter.reserved = 0;
        parameter.maxAmqCaller = 1;
        parameter.maxAmqCallee = 1;
        parameter.pduLength = pduLength;
        return parameter;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetupComParameter)) {
            return false;
        }
        SetupComParameter other = (SetupComParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getReserved() != other.getReserved()) {
            return false;
        }
        if (this.getMaxAmqCaller() != other.getMaxAmqCaller()) {
            return false;
        }
        if (this.getMaxAmqCallee() != other.getMaxAmqCallee()) {
            return false;
        }
        return this.getPduLength() == other.getPduLength();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SetupComParameter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getReserved();
        result = result * 59 + this.getMaxAmqCaller();
        result = result * 59 + this.getMaxAmqCallee();
        result = result * 59 + this.getPduLength();
        return result;
    }

    public byte getReserved() {
        return this.reserved;
    }

    public int getMaxAmqCaller() {
        return this.maxAmqCaller;
    }

    public int getMaxAmqCallee() {
        return this.maxAmqCallee;
    }

    public int getPduLength() {
        return this.pduLength;
    }

    public void setReserved(byte reserved) {
        this.reserved = reserved;
    }

    public void setMaxAmqCaller(int maxAmqCaller) {
        this.maxAmqCaller = maxAmqCaller;
    }

    public void setMaxAmqCallee(int maxAmqCallee) {
        this.maxAmqCallee = maxAmqCallee;
    }

    public void setPduLength(int pduLength) {
        this.pduLength = pduLength;
    }

    @Override
    public String toString() {
        return "SetupComParameter(reserved=" + this.getReserved() + ", maxAmqCaller=" + this.getMaxAmqCaller() + ", maxAmqCallee=" + this.getMaxAmqCallee() + ", pduLength=" + this.getPduLength() + ")";
    }
}

