/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.s7.enums.EReturnCode;

public class ReturnItem
implements IObjectByteArray {
    protected EReturnCode returnCode = EReturnCode.SUCCESS;

    @Override
    public int byteArrayLength() {
        return 1;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putByte(this.returnCode.getCode()).getData();
    }

    public static ReturnItem fromBytes(byte[] data) {
        ReturnItem returnItem = new ReturnItem();
        returnItem.returnCode = EReturnCode.from(data[0]);
        return returnItem;
    }

    public static ReturnItem createDefault(EReturnCode returnCode) {
        ReturnItem item = new ReturnItem();
        item.returnCode = returnCode;
        return item;
    }

    public EReturnCode getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(EReturnCode returnCode) {
        this.returnCode = returnCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReturnItem)) {
            return false;
        }
        ReturnItem other = (ReturnItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EReturnCode this$returnCode = this.getReturnCode();
        EReturnCode other$returnCode = other.getReturnCode();
        return !(this$returnCode == null ? other$returnCode != null : !((Object)((Object)this$returnCode)).equals((Object)other$returnCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReturnItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EReturnCode $returnCode = this.getReturnCode();
        result = result * 59 + ($returnCode == null ? 43 : ((Object)((Object)$returnCode)).hashCode());
        return result;
    }

    public String toString() {
        return "ReturnItem(returnCode=" + (Object)((Object)this.getReturnCode()) + ")";
    }
}

