/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.s7.enums.ENckArea;
import com.github.xingshuangs.iot.protocol.s7.enums.ENckModule;
import com.github.xingshuangs.iot.protocol.s7.enums.ESyntaxID;
import com.github.xingshuangs.iot.protocol.s7.model.RequestBaseItem;

public class RequestNckItem
extends RequestBaseItem {
    public static final int BYTE_LENGTH = 10;
    private ENckArea area = ENckArea.N_NCK;
    private int unit = 0;
    private int columnNumber = 0;
    private int lineNumber = 0;
    private ENckModule module = ENckModule.S;
    private int lineCount = 1;

    public RequestNckItem() {
        this.specificationType = (byte)18;
        this.lengthOfFollowing = 8;
        this.syntaxId = ESyntaxID.NCK;
    }

    public RequestNckItem(ENckArea area, int unit, int columnNumber, int lineNumber, ENckModule module, int lineCount) {
        this.specificationType = (byte)18;
        this.lengthOfFollowing = 8;
        this.syntaxId = ESyntaxID.NCK;
        this.area = area;
        this.unit = unit;
        this.columnNumber = columnNumber;
        this.lineNumber = lineNumber;
        this.module = module;
        this.lineCount = lineCount;
    }

    @Override
    public int byteArrayLength() {
        return 10;
    }

    @Override
    public byte[] toByteArray() {
        byte areaAndUint = (byte)(this.area.getCode() << 5 & 0xFFFFFFE0 | this.unit & 0x1F);
        return ByteWriteBuff.newInstance(10).putByte(this.specificationType).putByte(this.lengthOfFollowing).putByte(this.syntaxId.getCode()).putByte(areaAndUint).putShort(this.columnNumber).putShort(this.lineNumber).putByte(this.module.getCode()).putByte(this.lineCount).getData();
    }

    public RequestNckItem copy() {
        RequestNckItem requestItem = new RequestNckItem();
        requestItem.specificationType = this.specificationType;
        requestItem.lengthOfFollowing = this.lengthOfFollowing;
        requestItem.syntaxId = this.syntaxId;
        requestItem.area = this.area;
        requestItem.unit = this.unit;
        requestItem.columnNumber = this.columnNumber;
        requestItem.lineNumber = this.lineNumber;
        requestItem.module = this.module;
        requestItem.lineCount = this.lineCount;
        return requestItem;
    }

    public static RequestNckItem fromBytes(byte[] data) {
        return RequestNckItem.fromBytes(data, 0);
    }

    public static RequestNckItem fromBytes(byte[] data, int offset) {
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        RequestNckItem requestItem = new RequestNckItem();
        requestItem.specificationType = buff.getByte();
        requestItem.lengthOfFollowing = buff.getByteToInt();
        requestItem.syntaxId = ESyntaxID.from(buff.getByte());
        byte areaAndUnit = buff.getByte();
        requestItem.area = ENckArea.from((byte)((areaAndUnit & 0xFFFFFFE0) >> 5));
        requestItem.unit = areaAndUnit & 0x1F;
        requestItem.columnNumber = buff.getUInt16();
        requestItem.lineNumber = buff.getUInt16();
        requestItem.module = ENckModule.from(buff.getByte());
        requestItem.lineCount = buff.getByteToInt();
        return requestItem;
    }

    public static RequestNckItem createByParams(ENckArea area, int unit, int columnNumber, int lineNumber, ENckModule module, int lineCount) {
        RequestNckItem requestItem = new RequestNckItem();
        requestItem.area = area;
        requestItem.unit = unit;
        requestItem.columnNumber = columnNumber;
        requestItem.lineNumber = lineNumber;
        requestItem.module = module;
        requestItem.lineCount = lineCount;
        return requestItem;
    }

    public ENckArea getArea() {
        return this.area;
    }

    public int getUnit() {
        return this.unit;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public ENckModule getModule() {
        return this.module;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public void setArea(ENckArea area) {
        this.area = area;
    }

    public void setUnit(int unit) {
        this.unit = unit;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setModule(ENckModule module) {
        this.module = module;
    }

    public void setLineCount(int lineCount) {
        this.lineCount = lineCount;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestNckItem)) {
            return false;
        }
        RequestNckItem other = (RequestNckItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getUnit() != other.getUnit()) {
            return false;
        }
        if (this.getColumnNumber() != other.getColumnNumber()) {
            return false;
        }
        if (this.getLineNumber() != other.getLineNumber()) {
            return false;
        }
        if (this.getLineCount() != other.getLineCount()) {
            return false;
        }
        ENckArea this$area = this.getArea();
        ENckArea other$area = other.getArea();
        if (this$area == null ? other$area != null : !((Object)((Object)this$area)).equals((Object)other$area)) {
            return false;
        }
        ENckModule this$module = this.getModule();
        ENckModule other$module = other.getModule();
        return !(this$module == null ? other$module != null : !((Object)((Object)this$module)).equals((Object)other$module));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RequestNckItem;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getUnit();
        result = result * 59 + this.getColumnNumber();
        result = result * 59 + this.getLineNumber();
        result = result * 59 + this.getLineCount();
        ENckArea $area = this.getArea();
        result = result * 59 + ($area == null ? 43 : ((Object)((Object)$area)).hashCode());
        ENckModule $module = this.getModule();
        result = result * 59 + ($module == null ? 43 : ((Object)((Object)$module)).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RequestNckItem(area=" + (Object)((Object)this.getArea()) + ", unit=" + this.getUnit() + ", columnNumber=" + this.getColumnNumber() + ", lineNumber=" + this.getLineNumber() + ", module=" + (Object)((Object)this.getModule()) + ", lineCount=" + this.getLineCount() + ")";
    }
}

