/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.s7.enums.EFunctionCode;
import com.github.xingshuangs.iot.protocol.s7.enums.EMessageType;
import com.github.xingshuangs.iot.protocol.s7.model.DataItem;
import com.github.xingshuangs.iot.protocol.s7.model.Datum;
import com.github.xingshuangs.iot.protocol.s7.model.ReturnItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ReadWriteDatum
extends Datum {
    private final List<ReturnItem> returnItems = new ArrayList<ReturnItem>();

    @Override
    public int byteArrayLength() {
        if (this.returnItems.isEmpty()) {
            return 0;
        }
        int sum = 0;
        for (int i = 0; i < this.returnItems.size(); ++i) {
            int length = this.returnItems.get(i).byteArrayLength();
            sum += length;
            if (i == this.returnItems.size() - 1 || length % 2 != 1 || !(this.returnItems.get(i) instanceof DataItem)) continue;
            ++sum;
        }
        return sum;
    }

    @Override
    public byte[] toByteArray() {
        if (this.returnItems.isEmpty()) {
            return new byte[0];
        }
        ByteWriteBuff buff = ByteWriteBuff.newInstance(this.byteArrayLength());
        for (int i = 0; i < this.returnItems.size(); ++i) {
            int length = this.returnItems.get(i).byteArrayLength();
            buff.putBytes(this.returnItems.get(i).toByteArray());
            if (i == this.returnItems.size() - 1 || length % 2 != 1 || !(this.returnItems.get(i) instanceof DataItem)) continue;
            buff.putByte(0);
        }
        return buff.getData();
    }

    public void addItem(ReturnItem item) {
        this.returnItems.add(item);
    }

    public void addItem(Collection<? extends ReturnItem> items) {
        this.returnItems.addAll(items);
    }

    public static ReadWriteDatum fromBytes(byte[] data, EMessageType messageType, EFunctionCode functionCode) {
        ReadWriteDatum datum = new ReadWriteDatum();
        if (data.length == 0) {
            return datum;
        }
        int offset = 0;
        byte[] remain = data;
        while (true) {
            ReturnItem dataItem;
            if (EMessageType.ACK_DATA == messageType && EFunctionCode.WRITE_VARIABLE == functionCode) {
                dataItem = ReturnItem.fromBytes(remain);
                datum.returnItems.add(dataItem);
                offset += dataItem.byteArrayLength();
            } else {
                dataItem = DataItem.fromBytes(remain);
                datum.returnItems.add(dataItem);
                offset += dataItem.byteArrayLength();
                if (dataItem.byteArrayLength() % 2 == 1) {
                    ++offset;
                }
            }
            if (offset >= data.length) break;
            remain = Arrays.copyOfRange(data, offset, data.length);
        }
        return datum;
    }

    public static ReadWriteDatum createDatum(Collection<? extends ReturnItem> dataItems) {
        ReadWriteDatum datum = new ReadWriteDatum();
        datum.addItem(dataItems);
        return datum;
    }

    public List<ReturnItem> getReturnItems() {
        return this.returnItems;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReadWriteDatum)) {
            return false;
        }
        ReadWriteDatum other = (ReadWriteDatum)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ReturnItem> this$returnItems = this.getReturnItems();
        List<ReturnItem> other$returnItems = other.getReturnItems();
        return !(this$returnItems == null ? other$returnItems != null : !((Object)this$returnItems).equals(other$returnItems));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ReadWriteDatum;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ReturnItem> $returnItems = this.getReturnItems();
        result = result * 59 + ($returnItems == null ? 43 : ((Object)$returnItems).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ReadWriteDatum(returnItems=" + this.getReturnItems() + ")";
    }
}

