/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.s7.enums.EMessageType;
import java.util.concurrent.atomic.AtomicInteger;

public class Header
implements IObjectByteArray {
    private static final AtomicInteger index = new AtomicInteger();
    public static final int BYTE_LENGTH = 10;
    protected byte protocolId = (byte)50;
    protected EMessageType messageType = EMessageType.JOB;
    protected int reserved = 0;
    protected int pduReference = 0;
    protected int parameterLength = 0;
    protected int dataLength = 0;

    public static int getNewPduNumber() {
        int res = index.getAndIncrement();
        if (res >= 65536) {
            index.set(0);
            res = 0;
        }
        return res;
    }

    @Override
    public int byteArrayLength() {
        return 10;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(10).putByte(this.protocolId).putByte(this.messageType.getCode()).putShort(this.reserved).putShort(this.pduReference).putShort(this.parameterLength).putShort(this.dataLength).getData();
    }

    public static Header fromBytes(byte[] data) {
        if (data.length < 10) {
            throw new IndexOutOfBoundsException("header, data length < 10");
        }
        ByteReadBuff buff = new ByteReadBuff(data);
        Header header = new Header();
        header.protocolId = buff.getByte();
        header.messageType = EMessageType.from(buff.getByte());
        header.reserved = buff.getUInt16();
        header.pduReference = buff.getUInt16();
        header.parameterLength = buff.getUInt16();
        header.dataLength = buff.getUInt16();
        return header;
    }

    public static Header createDefault() {
        Header header = new Header();
        header.protocolId = (byte)50;
        header.messageType = EMessageType.JOB;
        header.reserved = 0;
        header.pduReference = Header.getNewPduNumber();
        header.parameterLength = 0;
        header.dataLength = 0;
        return header;
    }

    public byte getProtocolId() {
        return this.protocolId;
    }

    public EMessageType getMessageType() {
        return this.messageType;
    }

    public int getReserved() {
        return this.reserved;
    }

    public int getPduReference() {
        return this.pduReference;
    }

    public int getParameterLength() {
        return this.parameterLength;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setProtocolId(byte protocolId) {
        this.protocolId = protocolId;
    }

    public void setMessageType(EMessageType messageType) {
        this.messageType = messageType;
    }

    public void setReserved(int reserved) {
        this.reserved = reserved;
    }

    public void setPduReference(int pduReference) {
        this.pduReference = pduReference;
    }

    public void setParameterLength(int parameterLength) {
        this.parameterLength = parameterLength;
    }

    public void setDataLength(int dataLength) {
        this.dataLength = dataLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Header)) {
            return false;
        }
        Header other = (Header)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getProtocolId() != other.getProtocolId()) {
            return false;
        }
        if (this.getReserved() != other.getReserved()) {
            return false;
        }
        if (this.getPduReference() != other.getPduReference()) {
            return false;
        }
        if (this.getParameterLength() != other.getParameterLength()) {
            return false;
        }
        if (this.getDataLength() != other.getDataLength()) {
            return false;
        }
        EMessageType this$messageType = this.getMessageType();
        EMessageType other$messageType = other.getMessageType();
        return !(this$messageType == null ? other$messageType != null : !((Object)((Object)this$messageType)).equals((Object)other$messageType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Header;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getProtocolId();
        result = result * 59 + this.getReserved();
        result = result * 59 + this.getPduReference();
        result = result * 59 + this.getParameterLength();
        result = result * 59 + this.getDataLength();
        EMessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : ((Object)((Object)$messageType)).hashCode());
        return result;
    }

    public String toString() {
        return "Header(protocolId=" + this.getProtocolId() + ", messageType=" + (Object)((Object)this.getMessageType()) + ", reserved=" + this.getReserved() + ", pduReference=" + this.getPduReference() + ", parameterLength=" + this.getParameterLength() + ", dataLength=" + this.getDataLength() + ")";
    }
}

