/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.enums;

import java.util.HashMap;
import java.util.Map;

public enum EFunctionCode {
    CPU_SERVICES(0),
    READ_VARIABLE(4),
    WRITE_VARIABLE(5),
    START_DOWNLOAD(-6),
    DOWNLOAD(-5),
    END_DOWNLOAD(-4),
    START_UPLOAD(29),
    UPLOAD(30),
    END_UPLOAD(31),
    PLC_CONTROL(40),
    PLC_STOP(41),
    SETUP_COMMUNICATION(-16);

    private static Map<Byte, EFunctionCode> map;
    private final byte code;

    public static EFunctionCode from(byte data) {
        if (map == null) {
            map = new HashMap<Byte, EFunctionCode>();
            for (EFunctionCode item : EFunctionCode.values()) {
                map.put(item.code, item);
            }
        }
        return map.get(data);
    }

    private EFunctionCode(byte code) {
        this.code = code;
    }

    public byte getCode() {
        return this.code;
    }
}

