/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model.sdp.attribute;

import com.github.xingshuangs.iot.exceptions.RtspCommException;

public class RtspSdpMediaAttrRtpMap {
    private Integer payloadNumber;
    private String payloadFormat;
    private Integer clockFrequency;
    private Integer soundTrackNumber;

    public static RtspSdpMediaAttrRtpMap fromString(String src) {
        if (src == null || src.equals("")) {
            throw new IllegalArgumentException("MediaAttrRtpMap data error");
        }
        RtspSdpMediaAttrRtpMap rtpMap = new RtspSdpMediaAttrRtpMap();
        int i = src.indexOf(" ");
        if (i == -1) {
            throw new RtspCommException("RtspSdpMediaAttrRtpMap data error");
        }
        rtpMap.payloadNumber = Integer.parseInt(src.substring(0, i));
        String sub = src.substring(i + 1).trim();
        String[] split = sub.split("/");
        if (split.length > 0) {
            rtpMap.payloadFormat = split[0];
        }
        if (split.length > 1) {
            rtpMap.clockFrequency = Integer.parseInt(split[1]);
        }
        if (split.length > 2) {
            rtpMap.soundTrackNumber = Integer.parseInt(split[2]);
        }
        return rtpMap;
    }

    public Integer getPayloadNumber() {
        return this.payloadNumber;
    }

    public String getPayloadFormat() {
        return this.payloadFormat;
    }

    public Integer getClockFrequency() {
        return this.clockFrequency;
    }

    public Integer getSoundTrackNumber() {
        return this.soundTrackNumber;
    }

    public void setPayloadNumber(Integer payloadNumber) {
        this.payloadNumber = payloadNumber;
    }

    public void setPayloadFormat(String payloadFormat) {
        this.payloadFormat = payloadFormat;
    }

    public void setClockFrequency(Integer clockFrequency) {
        this.clockFrequency = clockFrequency;
    }

    public void setSoundTrackNumber(Integer soundTrackNumber) {
        this.soundTrackNumber = soundTrackNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtspSdpMediaAttrRtpMap)) {
            return false;
        }
        RtspSdpMediaAttrRtpMap other = (RtspSdpMediaAttrRtpMap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$payloadNumber = this.getPayloadNumber();
        Integer other$payloadNumber = other.getPayloadNumber();
        if (this$payloadNumber == null ? other$payloadNumber != null : !((Object)this$payloadNumber).equals(other$payloadNumber)) {
            return false;
        }
        Integer this$clockFrequency = this.getClockFrequency();
        Integer other$clockFrequency = other.getClockFrequency();
        if (this$clockFrequency == null ? other$clockFrequency != null : !((Object)this$clockFrequency).equals(other$clockFrequency)) {
            return false;
        }
        Integer this$soundTrackNumber = this.getSoundTrackNumber();
        Integer other$soundTrackNumber = other.getSoundTrackNumber();
        if (this$soundTrackNumber == null ? other$soundTrackNumber != null : !((Object)this$soundTrackNumber).equals(other$soundTrackNumber)) {
            return false;
        }
        String this$payloadFormat = this.getPayloadFormat();
        String other$payloadFormat = other.getPayloadFormat();
        return !(this$payloadFormat == null ? other$payloadFormat != null : !this$payloadFormat.equals(other$payloadFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtspSdpMediaAttrRtpMap;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $payloadNumber = this.getPayloadNumber();
        result = result * 59 + ($payloadNumber == null ? 43 : ((Object)$payloadNumber).hashCode());
        Integer $clockFrequency = this.getClockFrequency();
        result = result * 59 + ($clockFrequency == null ? 43 : ((Object)$clockFrequency).hashCode());
        Integer $soundTrackNumber = this.getSoundTrackNumber();
        result = result * 59 + ($soundTrackNumber == null ? 43 : ((Object)$soundTrackNumber).hashCode());
        String $payloadFormat = this.getPayloadFormat();
        result = result * 59 + ($payloadFormat == null ? 43 : $payloadFormat.hashCode());
        return result;
    }

    public String toString() {
        return "RtspSdpMediaAttrRtpMap(payloadNumber=" + this.getPayloadNumber() + ", payloadFormat=" + this.getPayloadFormat() + ", clockFrequency=" + this.getClockFrequency() + ", soundTrackNumber=" + this.getSoundTrackNumber() + ")";
    }
}

