/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model.sdp;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.exceptions.RtspCommException;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.SeqParameterSet;
import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.RtspSdp;
import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.RtspSdpMedia;
import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.attribute.RtspSdpMediaAttrDimension;
import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.attribute.RtspSdpMediaAttrFmtp;
import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.attribute.RtspSdpMediaAttrRtpMap;
import com.github.xingshuangs.iot.utils.HexUtil;
import java.util.Arrays;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtspTrackInfo {
    private static final Logger log = LoggerFactory.getLogger(RtspTrackInfo.class);
    private int id;
    private String type;
    private String codec;
    private int timescale;
    private int duration;
    private int width;
    private int height;
    private byte[] sps;
    private byte[] pps;

    public static RtspTrackInfo createTrackInfo(RtspSdp sdp) {
        Optional<RtspSdpMedia> optional = sdp.getMedias().stream().filter(x -> x.getMediaDesc().getType().equals("video")).findFirst();
        if (!optional.isPresent()) {
            throw new RtspCommException("No SDP related to video exists");
        }
        RtspSdpMedia media = optional.get();
        RtspTrackInfo trackInfo = new RtspTrackInfo();
        trackInfo.id = media.getAttributeControl().getTrackID();
        trackInfo.type = "video";
        RtspSdpMediaAttrRtpMap rtpMap = media.getAttributeRtpMap();
        trackInfo.timescale = rtpMap.getClockFrequency();
        trackInfo.duration = rtpMap.getClockFrequency();
        if ("H265".equalsIgnoreCase(rtpMap.getPayloadFormat())) {
            throw new RtspCommException("The H265 protocol is not currently supported. You can set the camera to H264");
        }
        RtspSdpMediaAttrDimension dimension = media.getAttributeDimension();
        trackInfo.width = dimension == null ? 1920 : dimension.getWidth();
        trackInfo.height = dimension == null ? 1080 : dimension.getHeight();
        RtspSdpMediaAttrFmtp fmtp = media.getAttributeFmtp();
        trackInfo.sps = fmtp.getSps();
        trackInfo.pps = fmtp.getPps();
        if (trackInfo.sps == null || trackInfo.sps.length < 4) {
            log.warn("sps is missing from SDP");
            return trackInfo;
        }
        SeqParameterSet sps = SeqParameterSet.createSPS(trackInfo.sps);
        trackInfo.width = sps.getWidth();
        trackInfo.height = sps.getHeight();
        ByteReadBuff buff = new ByteReadBuff(trackInfo.sps);
        byte[] bytes = buff.getBytes(1, 3);
        trackInfo.codec = "avc1." + HexUtil.toHexString(bytes, "", false);
        return trackInfo;
    }

    public int getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getCodec() {
        return this.codec;
    }

    public int getTimescale() {
        return this.timescale;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getSps() {
        return this.sps;
    }

    public byte[] getPps() {
        return this.pps;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setCodec(String codec) {
        this.codec = codec;
    }

    public void setTimescale(int timescale) {
        this.timescale = timescale;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setSps(byte[] sps) {
        this.sps = sps;
    }

    public void setPps(byte[] pps) {
        this.pps = pps;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtspTrackInfo)) {
            return false;
        }
        RtspTrackInfo other = (RtspTrackInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getTimescale() != other.getTimescale()) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$codec = this.getCodec();
        String other$codec = other.getCodec();
        if (this$codec == null ? other$codec != null : !this$codec.equals(other$codec)) {
            return false;
        }
        if (!Arrays.equals(this.getSps(), other.getSps())) {
            return false;
        }
        return Arrays.equals(this.getPps(), other.getPps());
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtspTrackInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getTimescale();
        result = result * 59 + this.getDuration();
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $codec = this.getCodec();
        result = result * 59 + ($codec == null ? 43 : $codec.hashCode());
        result = result * 59 + Arrays.hashCode(this.getSps());
        result = result * 59 + Arrays.hashCode(this.getPps());
        return result;
    }

    public String toString() {
        return "RtspTrackInfo(id=" + this.getId() + ", type=" + this.getType() + ", codec=" + this.getCodec() + ", timescale=" + this.getTimescale() + ", duration=" + this.getDuration() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", sps=" + Arrays.toString(this.getSps()) + ", pps=" + Arrays.toString(this.getPps()) + ")";
    }
}

