/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model.sdp;

import com.github.xingshuangs.iot.exceptions.RtspCommException;

public class RtspSdpMediaDesc {
    private String type;
    private Integer port;
    private String protocol;
    private Integer payloadFormatNumber;

    public static RtspSdpMediaDesc fromString(String src) {
        if (src == null || src.equals("")) {
            throw new IllegalArgumentException("The SDP failed to parse some data sources of MediaDesc");
        }
        RtspSdpMediaDesc desc = new RtspSdpMediaDesc();
        String[] split = src.split(" ");
        if (split.length != 4) {
            throw new RtspCommException("RtspSdpMediaDesc data is incorrect and cannot be parsed");
        }
        desc.type = split[0];
        desc.port = Integer.parseInt(split[1]);
        desc.protocol = split[2];
        desc.payloadFormatNumber = Integer.parseInt(split[3]);
        return desc;
    }

    public String getType() {
        return this.type;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Integer getPayloadFormatNumber() {
        return this.payloadFormatNumber;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setPayloadFormatNumber(Integer payloadFormatNumber) {
        this.payloadFormatNumber = payloadFormatNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtspSdpMediaDesc)) {
            return false;
        }
        RtspSdpMediaDesc other = (RtspSdpMediaDesc)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Integer this$payloadFormatNumber = this.getPayloadFormatNumber();
        Integer other$payloadFormatNumber = other.getPayloadFormatNumber();
        if (this$payloadFormatNumber == null ? other$payloadFormatNumber != null : !((Object)this$payloadFormatNumber).equals(other$payloadFormatNumber)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        return !(this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtspSdpMediaDesc;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Integer $payloadFormatNumber = this.getPayloadFormatNumber();
        result = result * 59 + ($payloadFormatNumber == null ? 43 : ((Object)$payloadFormatNumber).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        return result;
    }

    public String toString() {
        return "RtspSdpMediaDesc(type=" + this.getType() + ", port=" + this.getPort() + ", protocol=" + this.getProtocol() + ", payloadFormatNumber=" + this.getPayloadFormatNumber() + ")";
    }
}

