/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model.interleaved;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RtspInterleaved
implements IObjectByteArray {
    public static final byte VERSION = 36;
    private byte dollarSign = (byte)36;
    private int channelId = 0;
    private int length = 0;
    private byte[] payload = new byte[0];

    @Override
    public int byteArrayLength() {
        return 4 + this.payload.length;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putByte(this.dollarSign).putByte(this.channelId).putInteger(this.length).putBytes(this.payload).getData();
    }

    public static List<RtspInterleaved> listFromBytes(byte[] data) {
        RtspInterleaved rtspInterleaved;
        ArrayList<RtspInterleaved> res = new ArrayList<RtspInterleaved>();
        for (int offset = 0; offset < data.length; offset += rtspInterleaved.byteArrayLength()) {
            rtspInterleaved = RtspInterleaved.fromBytes(data, offset);
            res.add(rtspInterleaved);
        }
        return res;
    }

    public static RtspInterleaved fromBytes(byte[] data) {
        return RtspInterleaved.fromBytes(data, 0);
    }

    public static RtspInterleaved fromBytes(byte[] data, int offset) {
        if (data.length < 4) {
            throw new IndexOutOfBoundsException("RtspInterleaved, data length < 4");
        }
        if (data[offset] != 36) {
            throw new IllegalArgumentException("The versions of the packets are different, the first byte is not 0x24");
        }
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        RtspInterleaved res = new RtspInterleaved();
        res.dollarSign = buff.getByte();
        res.channelId = buff.getByteToInt();
        res.length = buff.getUInt16();
        res.payload = buff.getBytes(res.length);
        return res;
    }

    public byte getDollarSign() {
        return this.dollarSign;
    }

    public int getChannelId() {
        return this.channelId;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setDollarSign(byte dollarSign) {
        this.dollarSign = dollarSign;
    }

    public void setChannelId(int channelId) {
        this.channelId = channelId;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtspInterleaved)) {
            return false;
        }
        RtspInterleaved other = (RtspInterleaved)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDollarSign() != other.getDollarSign()) {
            return false;
        }
        if (this.getChannelId() != other.getChannelId()) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        return Arrays.equals(this.getPayload(), other.getPayload());
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtspInterleaved;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDollarSign();
        result = result * 59 + this.getChannelId();
        result = result * 59 + this.getLength();
        result = result * 59 + Arrays.hashCode(this.getPayload());
        return result;
    }

    public String toString() {
        return "RtspInterleaved(dollarSign=" + this.getDollarSign() + ", channelId=" + this.getChannelId() + ", length=" + this.getLength() + ", payload=" + Arrays.toString(this.getPayload()) + ")";
    }
}

