/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model.base;

import com.github.xingshuangs.iot.exceptions.RtspCommException;
import com.github.xingshuangs.iot.protocol.rtsp.model.base.RtspTransport;
import java.util.ArrayList;
import java.util.Map;

public class RtspInterleavedTransport
extends RtspTransport {
    private Integer interleaved1 = 0;
    private Integer interleaved2 = 1;

    public RtspInterleavedTransport() {
    }

    public RtspInterleavedTransport(Integer interleaved1, Integer interleaved2) {
        this.protocol = "RTP/AVP/TCP";
        this.castMode = "unicast";
        this.interleaved1 = interleaved1;
        this.interleaved2 = interleaved2;
    }

    public static RtspInterleavedTransport fromString(String src) {
        if (src == null || src.equals("")) {
            throw new IllegalArgumentException("RtspTransport, src is null or empty");
        }
        RtspInterleavedTransport transport = new RtspInterleavedTransport();
        String[] split = src.split(";");
        transport.protocol = split[0];
        transport.castMode = split[1];
        Map<String, String> map = transport.getMap(split);
        if (map.containsKey("interleaved")) {
            String clientPort1 = map.get("interleaved").trim();
            int clientPortIndex = clientPort1.indexOf("-");
            transport.interleaved1 = Integer.parseInt(clientPort1.substring(0, clientPortIndex));
            transport.interleaved2 = Integer.parseInt(clientPort1.substring(clientPortIndex + 1));
        }
        if (map.containsKey("ssrc")) {
            transport.ssrc = map.get("ssrc").trim();
        }
        if (map.containsKey("mode")) {
            transport.mode = map.get("mode").replace("\"", "").trim();
        }
        return transport;
    }

    @Override
    public String toString() {
        if (this.protocol == null || this.protocol.equals("")) {
            throw new RtspCommException("protocol of RtspTransport is null or empty");
        }
        if (this.castMode == null || this.castMode.equals("")) {
            throw new RtspCommException("castMode of RtspTransport is null or empty");
        }
        ArrayList<String> res = new ArrayList<String>();
        res.add(this.protocol);
        res.add(this.castMode);
        res.add(String.format("interleaved=%d-%d", this.interleaved1, this.interleaved2));
        if (this.ssrc != null && !this.ssrc.equals("")) {
            res.add(String.format("ssrc=%s", this.ssrc));
        }
        if (this.mode != null && !this.mode.equals("")) {
            res.add(String.format("mode=\"%s\"", this.mode));
        }
        return String.join((CharSequence)";", res);
    }

    public Integer getInterleaved1() {
        return this.interleaved1;
    }

    public Integer getInterleaved2() {
        return this.interleaved2;
    }

    public void setInterleaved1(Integer interleaved1) {
        this.interleaved1 = interleaved1;
    }

    public void setInterleaved2(Integer interleaved2) {
        this.interleaved2 = interleaved2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtspInterleavedTransport)) {
            return false;
        }
        RtspInterleavedTransport other = (RtspInterleavedTransport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$interleaved1 = this.getInterleaved1();
        Integer other$interleaved1 = other.getInterleaved1();
        if (this$interleaved1 == null ? other$interleaved1 != null : !((Object)this$interleaved1).equals(other$interleaved1)) {
            return false;
        }
        Integer this$interleaved2 = this.getInterleaved2();
        Integer other$interleaved2 = other.getInterleaved2();
        return !(this$interleaved2 == null ? other$interleaved2 != null : !((Object)this$interleaved2).equals(other$interleaved2));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RtspInterleavedTransport;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $interleaved1 = this.getInterleaved1();
        result = result * 59 + ($interleaved1 == null ? 43 : ((Object)$interleaved1).hashCode());
        Integer $interleaved2 = this.getInterleaved2();
        result = result * 59 + ($interleaved2 == null ? 43 : ((Object)$interleaved2).hashCode());
        return result;
    }
}

