/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model;

import com.github.xingshuangs.iot.exceptions.RtspCommException;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspMessageResponse;
import com.github.xingshuangs.iot.protocol.rtsp.model.base.RtspRtpInfo;
import com.github.xingshuangs.iot.protocol.rtsp.model.base.RtspSessionInfo;
import com.github.xingshuangs.iot.utils.StringSpUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class RtspPlayResponse
extends RtspMessageResponse {
    private List<RtspRtpInfo> rtpInfo = new ArrayList<RtspRtpInfo>();
    private RtspSessionInfo sessionInfo;

    public static RtspPlayResponse fromHeaderString(String src) {
        if (src == null || src.equals("")) {
            throw new RtspCommException("src is null or empty in RtspPlayResponse");
        }
        RtspPlayResponse response = new RtspPlayResponse();
        Map<String, String> map = response.parseHeaderAndReturnMap(src);
        if (map.containsKey("RTP-Info")) {
            List<String> list = StringSpUtil.splitOneStepByLine(map.get("RTP-Info").trim(), ",");
            response.rtpInfo = list.stream().map(RtspRtpInfo::fromString).collect(Collectors.toList());
        }
        if (map.containsKey("Session")) {
            response.sessionInfo = RtspSessionInfo.fromString(map.get("Session").trim());
            response.session = response.sessionInfo.getSessionId();
        }
        return response;
    }

    public List<RtspRtpInfo> getRtpInfo() {
        return this.rtpInfo;
    }

    public RtspSessionInfo getSessionInfo() {
        return this.sessionInfo;
    }
}

