/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model;

import com.github.xingshuangs.iot.protocol.rtsp.authentication.AbstractAuthenticator;
import com.github.xingshuangs.iot.protocol.rtsp.enums.ERtspMethod;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspMessage;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class RtspMessageRequest
extends RtspMessage {
    protected final ERtspMethod method;
    public static final String USER_AGENT_VALUE = "IOT-COMMUNICATION";
    protected final URI uri;
    protected AbstractAuthenticator authenticator;

    public RtspMessageRequest(ERtspMethod method, URI uri) {
        this("RTSP/1.0", new HashMap<String, String>(), method, uri, "", null);
    }

    public RtspMessageRequest(ERtspMethod method, URI uri, String session) {
        this("RTSP/1.0", new HashMap<String, String>(), method, uri, session, null);
    }

    public RtspMessageRequest(ERtspMethod method, URI uri, AbstractAuthenticator authenticator) {
        this("RTSP/1.0", new HashMap<String, String>(), method, uri, "", authenticator);
    }

    public RtspMessageRequest(ERtspMethod method, URI uri, String session, AbstractAuthenticator authenticator) {
        this("RTSP/1.0", new HashMap<String, String>(), method, uri, session, authenticator);
    }

    public RtspMessageRequest(String version, Map<String, String> headers, ERtspMethod method, URI uri, String session, AbstractAuthenticator authenticator) {
        super(version, headers);
        this.method = method;
        this.uri = uri;
        this.session = session;
        this.authenticator = authenticator;
        this.cSeq = RtspMessage.getUint16Number();
    }

    @Override
    public String toObjectString() {
        StringBuilder sb = new StringBuilder();
        this.addRequestLine(sb);
        this.addGeneralHeader(sb);
        this.addCommonRequestHeader(sb);
        this.addRequestHeader(sb);
        this.addEntityHeader(sb);
        sb.append("\r\n");
        this.addMessageBody(sb);
        return sb.toString();
    }

    private void addRequestLine(StringBuilder sb) {
        sb.append(this.method.getCode()).append(" ").append(this.uri.toString()).append(" ").append(this.version).append("\r\n");
    }

    private void addGeneralHeader(StringBuilder sb) {
        sb.append("CSeq").append(": ").append(this.cSeq).append("\r\n");
    }

    private void addCommonRequestHeader(StringBuilder sb) {
        if (this.authenticator != null) {
            sb.append("Authorization").append(": ").append(this.authenticator.createResponse()).append("\r\n");
        }
        sb.append("User-Agent").append(": ").append(USER_AGENT_VALUE).append("\r\n");
        if (this.session != null && !this.session.equals("")) {
            sb.append("Session").append(": ").append(this.session).append("\r\n");
        }
        this.headers.forEach((key, value) -> sb.append((String)key).append(": ").append((String)value).append("\r\n"));
    }

    protected void addRequestHeader(StringBuilder sb) {
    }

    protected void addEntityHeader(StringBuilder sb) {
    }

    protected void addMessageBody(StringBuilder sb) {
    }

    public ERtspMethod getMethod() {
        return this.method;
    }

    public URI getUri() {
        return this.uri;
    }

    public AbstractAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(AbstractAuthenticator authenticator) {
        this.authenticator = authenticator;
    }
}

