/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model;

import com.github.xingshuangs.iot.exceptions.RtspCommException;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspMessageResponse;
import com.github.xingshuangs.iot.protocol.rtsp.model.base.RtspSessionInfo;
import com.github.xingshuangs.iot.utils.StringSpUtil;
import java.util.LinkedHashMap;
import java.util.Map;

public final class RtspGetParameterResponse
extends RtspMessageResponse {
    private final Map<String, String> parameters = new LinkedHashMap<String, String>();
    private RtspSessionInfo sessionInfo;

    public static RtspGetParameterResponse fromHeaderString(String src) {
        if (src == null || src.equals("")) {
            throw new RtspCommException("src is null or empty in RtspGetParameterResponse");
        }
        RtspGetParameterResponse response = new RtspGetParameterResponse();
        Map<String, String> map = response.parseHeaderAndReturnMap(src);
        if (map.containsKey("Session")) {
            response.sessionInfo = RtspSessionInfo.fromString(map.get("Session").trim());
            response.session = response.sessionInfo.getSessionId();
        }
        return response;
    }

    @Override
    public void addBodyFromString(String src) {
        Map<String, String> map = StringSpUtil.splitTwoStepByLine(src, "\r\n", ":");
        this.getParameters().putAll(map);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public RtspSessionInfo getSessionInfo() {
        return this.sessionInfo;
    }
}

