/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtp.service;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.exceptions.RtpCommException;
import com.github.xingshuangs.iot.protocol.rtp.enums.EH264NaluType;
import com.github.xingshuangs.iot.protocol.rtp.model.RtpPackage;
import com.github.xingshuangs.iot.protocol.rtp.model.frame.H264VideoFrame;
import com.github.xingshuangs.iot.protocol.rtp.model.frame.RawFrame;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluBase;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluBuilder;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluFuA;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluSingle;
import com.github.xingshuangs.iot.protocol.rtp.service.IPayloadParser;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H264VideoParser
implements IPayloadParser {
    private static final Logger log = LoggerFactory.getLogger(H264VideoParser.class);
    private final Integer payloadNumber;
    private long baseTimestamp = 0L;
    private Consumer<RawFrame> frameHandle;
    private final List<H264NaluFuA> buffers = new ArrayList<H264NaluFuA>();

    public H264VideoParser(Integer payloadNumber) {
        this.payloadNumber = payloadNumber;
    }

    private void resetBuffers() {
        this.buffers.clear();
    }

    private H264VideoFrame doBuffers(long timestamp) {
        if (this.buffers.isEmpty()) {
            throw new RtpCommException("the number of buffers is 0");
        }
        H264NaluFuA naluFuA = this.buffers.get(0);
        int sum = this.buffers.stream().mapToInt(x -> x.getPayload().length).sum();
        ByteWriteBuff buff = new ByteWriteBuff(sum);
        this.buffers.forEach(x -> buff.putBytes(x.getPayload()));
        this.buffers.clear();
        H264NaluSingle single = new H264NaluSingle();
        single.getHeader().setForbiddenZeroBit(naluFuA.getHeader().isForbiddenZeroBit());
        single.getHeader().setNri(naluFuA.getHeader().getNri());
        single.getHeader().setType(naluFuA.getFuHeader().getType());
        single.setPayload(buff.getData());
        return new H264VideoFrame(single.getHeader().getType(), timestamp - this.baseTimestamp, single.toByteArray());
    }

    @Override
    public void processPackage(RtpPackage rtp) {
        if (rtp.getHeader().getPayloadType() != this.payloadNumber.intValue()) {
            log.warn("payload numbers are inconsistent, expect[{}], actual[{}]", (Object)this.payloadNumber, (Object)rtp.getHeader().getPayloadType());
            return;
        }
        if (this.baseTimestamp == 0L) {
            this.baseTimestamp = rtp.getHeader().getTimestamp();
        }
        H264NaluBase h264Nalu = H264NaluBuilder.parsePackage(rtp.getPayload());
        EH264NaluType naluType = h264Nalu.getHeader().getType();
        RawFrame frame = null;
        switch (naluType) {
            case SEI: 
            case PPS: 
            case SPS: 
            case AUD: 
            case NON_IDR_SLICE: 
            case IDR_SLICE: {
                H264NaluSingle naluSingle = (H264NaluSingle)h264Nalu;
                frame = new H264VideoFrame(naluType, rtp.getHeader().getTimestamp() - this.baseTimestamp, naluSingle.toByteArray());
                break;
            }
            case FU_A: {
                H264NaluFuA naluFuA = (H264NaluFuA)h264Nalu;
                if (naluFuA.getFuHeader().isStart()) {
                    this.resetBuffers();
                }
                this.buffers.add(naluFuA);
                if (!naluFuA.getFuHeader().isEnd()) break;
                frame = this.doBuffers(rtp.getHeader().getTimestamp());
                break;
            }
            default: {
                log.error("RTP parsing unknown data type [{}], timestamp [{}]", (Object)naluType, (Object)rtp.getHeader().getTimestamp());
            }
        }
        if (this.frameHandle == null || frame == null) {
            return;
        }
        if (frame.getFrameSegment().length > 0) {
            try {
                this.frameHandle.accept(frame);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        } else {
            log.warn("There is a frame of data, the load is empty, [{}], [{}]", (Object)frame.getTimestamp(), (Object)((H264VideoFrame)frame).getNaluType());
        }
    }

    @Override
    public void onFrameHandle(Consumer<RawFrame> frameHandle) {
        this.frameHandle = frameHandle;
    }
}

