/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtp.model.payload;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluBase;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluHeader;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluStapSingle;
import java.util.ArrayList;
import java.util.List;

public class H264NaluStapB
extends H264NaluBase {
    private int decodingOrderNumber;
    private final List<H264NaluStapSingle> naluSingles = new ArrayList<H264NaluStapSingle>();

    @Override
    public int byteArrayLength() {
        int sum = this.header.byteArrayLength();
        sum += 2;
        for (H264NaluStapSingle item : this.naluSingles) {
            sum += item.byteArrayLength();
        }
        return sum;
    }

    @Override
    public byte[] toByteArray() {
        ByteWriteBuff buff = ByteWriteBuff.newInstance(this.byteArrayLength());
        buff.putBytes(this.header.toByteArray());
        buff.putShort(this.decodingOrderNumber);
        for (H264NaluStapSingle item : this.naluSingles) {
            buff.putBytes(item.toByteArray());
        }
        return buff.getData();
    }

    public static H264NaluStapB fromBytes(byte[] data) {
        return H264NaluStapB.fromBytes(data, 0);
    }

    public static H264NaluStapB fromBytes(byte[] data, int offset) {
        if (data.length < 1) {
            throw new IndexOutOfBoundsException("H264NaluStapSingle, data length < 1");
        }
        int index = offset;
        H264NaluStapB res = new H264NaluStapB();
        res.header = H264NaluHeader.fromBytes(data, index);
        res.decodingOrderNumber = ByteReadBuff.newInstance(data, index += res.header.byteArrayLength()).getUInt16();
        index += 2;
        while (index < data.length) {
            H264NaluStapSingle tmp = H264NaluStapSingle.fromBytes(data, index);
            res.naluSingles.add(tmp);
            index += tmp.byteArrayLength();
        }
        return res;
    }
}

