/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtp.model.payload;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;

public class ExpGolomb {
    private final ByteReadBuff readBuff;
    private int bitIndex;
    private byte currentByte;

    public ExpGolomb(byte[] data) {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("data");
        }
        this.readBuff = new ByteReadBuff(data);
        this.bitIndex = 0;
        this.currentByte = this.readBuff.getByte();
    }

    private void updateNext() {
        this.bitIndex = 0;
        this.currentByte = this.readBuff.getByte();
    }

    public int read1Bit() {
        if (this.bitIndex == 8) {
            this.updateNext();
        }
        int res = this.currentByte >> 7 - this.bitIndex & 1;
        ++this.bitIndex;
        return res;
    }

    public long readNBit(int size) {
        if (size > 32) {
            throw new IllegalArgumentException("size > 32");
        }
        long res = 0L;
        for (int i = 0; i < size; ++i) {
            res <<= 1;
            res |= (long)this.read1Bit();
        }
        return res;
    }

    public void skipBit(int size) {
        this.readNBit(size);
    }

    public int skipLZ() {
        int count = 0;
        while (this.read1Bit() == 0) {
            ++count;
        }
        return count;
    }

    public void skipUE() {
        int count = this.skipLZ();
        this.readNBit(1 + count);
    }

    public void skipSE() {
        int count = this.skipLZ();
        this.readNBit(1 + count);
    }

    public void skipScalingList(int count) {
        int lastScale = 8;
        int nextScale = 8;
        for (int i = 0; i < count; ++i) {
            if (nextScale != 0) {
                int deltaScale = this.readSE();
                nextScale = (lastScale + deltaScale + 256) % 256;
            }
            lastScale = nextScale == 0 ? lastScale : nextScale;
        }
    }

    public boolean readBoolean() {
        return this.read1Bit() == 1;
    }

    public int readUE() {
        int count = this.skipLZ();
        return (int)((long)((1 << count) - 1) + this.readNBit(count));
    }

    public int readSE() {
        int value = this.readUE();
        int sign = ((value & 1) << 1) - 1;
        return ((value >> 1) + (value & 1)) * sign;
    }

    public ByteReadBuff getReadBuff() {
        return this.readBuff;
    }

    public int getBitIndex() {
        return this.bitIndex;
    }

    public byte getCurrentByte() {
        return this.currentByte;
    }
}

