/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtp.enums;

import java.util.HashMap;
import java.util.Map;

public enum EH264NaluType {
    NONE(0),
    NON_IDR_SLICE(1),
    DPA(2),
    DPB(3),
    DPC(4),
    IDR_SLICE(5),
    SEI(6),
    SPS(7),
    PPS(8),
    AUD(9),
    END_OF_SEQUENCE(10),
    END_OF_STREAM(11),
    FILLER_DATA(12),
    STAP_A(24),
    STAP_B(25),
    MTAP16(26),
    MTAP24(27),
    FU_A(28),
    FU_B(29);

    private static Map<Integer, EH264NaluType> map;
    private final int code;

    public static EH264NaluType from(int data) {
        if (map == null) {
            map = new HashMap<Integer, EH264NaluType>();
            for (EH264NaluType item : EH264NaluType.values()) {
                map.put(item.code, item);
            }
        }
        return map.get(data);
    }

    private EH264NaluType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }
}

