/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtcp.service;

import com.github.xingshuangs.iot.protocol.rtcp.enums.ERtcpSdesItemType;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpBasePackage;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpBye;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpReceiverReport;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpReportBlock;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpSdesChunk;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpSdesItem;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpSdesReport;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpSenderReport;
import com.github.xingshuangs.iot.protocol.rtp.model.RtpPackage;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtcpDataStatistics {
    private static final Logger log = LoggerFactory.getLogger(RtcpDataStatistics.class);
    private long sourceId = System.currentTimeMillis();
    private int highestSequenceNumber = 0;
    private int packetsReceivedSinceLastReset = 0;
    private int packetsLostSinceLastReset = 0;
    private int cumulativePacketLost = 0;
    private int sequenceNumberCycles = 0;
    private long sampleTimestampSum = 0L;
    private long lastRtpTimestamp = 0L;
    private long lastRtpSsrc = 0L;
    private long lastNtpTimeSenderReportReceived = 0L;
    private long lastTimeRtcpReportReceived = 0L;
    private long lastLocalTimeReceiveRtp = 0L;

    public void processRtpPackage(RtpPackage rtp, Consumer<byte[]> send) {
        if (this.lastRtpSsrc > 0L) {
            this.sampleTimestampSum += rtp.getHeader().getTimestamp() - this.lastRtpTimestamp;
            int delta = rtp.getHeader().getSequenceNumber() - this.highestSequenceNumber;
            if (delta > 1) {
                this.cumulativePacketLost += delta - 1;
                this.packetsLostSinceLastReset += delta - 1;
            }
            if (this.cumulativePacketLost > 0x7FFFFF) {
                this.cumulativePacketLost = 0x7FFFFF;
            }
            if (rtp.getHeader().getSequenceNumber() < this.highestSequenceNumber) {
                ++this.sequenceNumberCycles;
            }
        }
        ++this.packetsReceivedSinceLastReset;
        this.highestSequenceNumber = rtp.getHeader().getSequenceNumber();
        this.lastRtpSsrc = rtp.getHeader().getSsrc();
        this.lastRtpTimestamp = rtp.getHeader().getTimestamp();
        if (this.lastLocalTimeReceiveRtp == 0L) {
            this.lastLocalTimeReceiveRtp = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - this.lastLocalTimeReceiveRtp > 5000L) {
            byte[] receiverAndByteContent = this.createReceiverAndSdesContent();
            send.accept(receiverAndByteContent);
            this.lastLocalTimeReceiveRtp = System.currentTimeMillis();
        }
    }

    public void resetState() {
        this.packetsLostSinceLastReset = 0;
        this.packetsReceivedSinceLastReset = 0;
    }

    public void processRtcpPackage(List<RtcpBasePackage> basePackages) {
        for (RtcpBasePackage rtcp : basePackages) {
            log.debug("RTCP receives [{}] data\uff0c{}", (Object)rtcp.getHeader().getPackageType(), (Object)rtcp);
            if (!(rtcp instanceof RtcpSenderReport)) continue;
            this.lastNtpTimeSenderReportReceived = ((RtcpSenderReport)rtcp).getSenderInfo().getMswTimestamp();
            this.lastTimeRtcpReportReceived = System.currentTimeMillis();
        }
    }

    public RtcpReceiverReport createReceiverReport() {
        int fractionLost = 0;
        if (this.packetsReceivedSinceLastReset != 0) {
            fractionLost = this.packetsLostSinceLastReset * 256 / this.packetsReceivedSinceLastReset;
        }
        long extHighestSequenceNumberReceived = (long)this.sequenceNumberCycles << 16 | (long)this.highestSequenceNumber;
        long delaySinceLastTimeSenderReportReceived = 0L;
        if (this.lastTimeRtcpReportReceived > 0L) {
            delaySinceLastTimeSenderReportReceived = (System.currentTimeMillis() - this.lastTimeRtcpReportReceived) / 1000L * 65536L;
        }
        RtcpReceiverReport receiverReport = new RtcpReceiverReport(this.sourceId);
        RtcpReportBlock reportBlock = new RtcpReportBlock();
        reportBlock.setSourceId(this.lastRtpSsrc);
        reportBlock.setFractionLost(fractionLost);
        reportBlock.setCumulativePacketLost(this.cumulativePacketLost);
        reportBlock.setExtHighestSequenceNumberReceived(extHighestSequenceNumberReceived);
        reportBlock.setJitter(0L);
        reportBlock.setLastNtpTimeSenderReportReceived(this.lastNtpTimeSenderReportReceived);
        reportBlock.setDelaySinceLastTimeSenderReportReceived(delaySinceLastTimeSenderReportReceived);
        receiverReport.addRtcpReportBlock(reportBlock);
        return receiverReport;
    }

    public RtcpSdesReport createSdesReport() {
        RtcpSdesReport sdesReport = new RtcpSdesReport();
        RtcpSdesChunk chunk = new RtcpSdesChunk(this.sourceId);
        RtcpSdesItem item = new RtcpSdesItem();
        item.setType(ERtcpSdesItemType.CNAME);
        item.setText("iot-communication");
        item.setLength(17);
        chunk.addRtcpSdesItem(item);
        sdesReport.addRtcpSdesChunk(chunk);
        return sdesReport;
    }

    public RtcpBye createByte() {
        return new RtcpBye(this.sourceId);
    }

    public byte[] createReceiverAndSdesContent() {
        RtcpReceiverReport receiverReport = this.createReceiverReport();
        RtcpSdesReport sdesReport = this.createSdesReport();
        byte[] res = new byte[receiverReport.byteArrayLength() + sdesReport.byteArrayLength()];
        System.arraycopy(receiverReport.toByteArray(), 0, res, 0, receiverReport.byteArrayLength());
        System.arraycopy(sdesReport.toByteArray(), 0, res, receiverReport.byteArrayLength(), sdesReport.byteArrayLength());
        return res;
    }

    public byte[] createReceiverAndByteContent() {
        RtcpReceiverReport receiverReport = this.createReceiverReport();
        RtcpBye aByte = this.createByte();
        log.debug("RTCP sends [{}], [{}] data", (Object)receiverReport.getHeader().getPackageType(), (Object)aByte.getHeader().getPackageType());
        byte[] res = new byte[receiverReport.byteArrayLength() + aByte.byteArrayLength()];
        System.arraycopy(receiverReport.toByteArray(), 0, res, 0, receiverReport.byteArrayLength());
        System.arraycopy(aByte.toByteArray(), 0, res, receiverReport.byteArrayLength(), aByte.byteArrayLength());
        return res;
    }

    public long getSourceId() {
        return this.sourceId;
    }

    public int getHighestSequenceNumber() {
        return this.highestSequenceNumber;
    }

    public int getPacketsReceivedSinceLastReset() {
        return this.packetsReceivedSinceLastReset;
    }

    public int getPacketsLostSinceLastReset() {
        return this.packetsLostSinceLastReset;
    }

    public int getCumulativePacketLost() {
        return this.cumulativePacketLost;
    }

    public int getSequenceNumberCycles() {
        return this.sequenceNumberCycles;
    }

    public long getSampleTimestampSum() {
        return this.sampleTimestampSum;
    }

    public long getLastRtpTimestamp() {
        return this.lastRtpTimestamp;
    }

    public long getLastRtpSsrc() {
        return this.lastRtpSsrc;
    }

    public long getLastNtpTimeSenderReportReceived() {
        return this.lastNtpTimeSenderReportReceived;
    }

    public long getLastTimeRtcpReportReceived() {
        return this.lastTimeRtcpReportReceived;
    }

    public long getLastLocalTimeReceiveRtp() {
        return this.lastLocalTimeReceiveRtp;
    }

    public void setSourceId(long sourceId) {
        this.sourceId = sourceId;
    }

    public void setHighestSequenceNumber(int highestSequenceNumber) {
        this.highestSequenceNumber = highestSequenceNumber;
    }

    public void setPacketsReceivedSinceLastReset(int packetsReceivedSinceLastReset) {
        this.packetsReceivedSinceLastReset = packetsReceivedSinceLastReset;
    }

    public void setPacketsLostSinceLastReset(int packetsLostSinceLastReset) {
        this.packetsLostSinceLastReset = packetsLostSinceLastReset;
    }

    public void setCumulativePacketLost(int cumulativePacketLost) {
        this.cumulativePacketLost = cumulativePacketLost;
    }

    public void setSequenceNumberCycles(int sequenceNumberCycles) {
        this.sequenceNumberCycles = sequenceNumberCycles;
    }

    public void setSampleTimestampSum(long sampleTimestampSum) {
        this.sampleTimestampSum = sampleTimestampSum;
    }

    public void setLastRtpTimestamp(long lastRtpTimestamp) {
        this.lastRtpTimestamp = lastRtpTimestamp;
    }

    public void setLastRtpSsrc(long lastRtpSsrc) {
        this.lastRtpSsrc = lastRtpSsrc;
    }

    public void setLastNtpTimeSenderReportReceived(long lastNtpTimeSenderReportReceived) {
        this.lastNtpTimeSenderReportReceived = lastNtpTimeSenderReportReceived;
    }

    public void setLastTimeRtcpReportReceived(long lastTimeRtcpReportReceived) {
        this.lastTimeRtcpReportReceived = lastTimeRtcpReportReceived;
    }

    public void setLastLocalTimeReceiveRtp(long lastLocalTimeReceiveRtp) {
        this.lastLocalTimeReceiveRtp = lastLocalTimeReceiveRtp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtcpDataStatistics)) {
            return false;
        }
        RtcpDataStatistics other = (RtcpDataStatistics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSourceId() != other.getSourceId()) {
            return false;
        }
        if (this.getHighestSequenceNumber() != other.getHighestSequenceNumber()) {
            return false;
        }
        if (this.getPacketsReceivedSinceLastReset() != other.getPacketsReceivedSinceLastReset()) {
            return false;
        }
        if (this.getPacketsLostSinceLastReset() != other.getPacketsLostSinceLastReset()) {
            return false;
        }
        if (this.getCumulativePacketLost() != other.getCumulativePacketLost()) {
            return false;
        }
        if (this.getSequenceNumberCycles() != other.getSequenceNumberCycles()) {
            return false;
        }
        if (this.getSampleTimestampSum() != other.getSampleTimestampSum()) {
            return false;
        }
        if (this.getLastRtpTimestamp() != other.getLastRtpTimestamp()) {
            return false;
        }
        if (this.getLastRtpSsrc() != other.getLastRtpSsrc()) {
            return false;
        }
        if (this.getLastNtpTimeSenderReportReceived() != other.getLastNtpTimeSenderReportReceived()) {
            return false;
        }
        if (this.getLastTimeRtcpReportReceived() != other.getLastTimeRtcpReportReceived()) {
            return false;
        }
        return this.getLastLocalTimeReceiveRtp() == other.getLastLocalTimeReceiveRtp();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtcpDataStatistics;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $sourceId = this.getSourceId();
        result = result * 59 + (int)($sourceId >>> 32 ^ $sourceId);
        result = result * 59 + this.getHighestSequenceNumber();
        result = result * 59 + this.getPacketsReceivedSinceLastReset();
        result = result * 59 + this.getPacketsLostSinceLastReset();
        result = result * 59 + this.getCumulativePacketLost();
        result = result * 59 + this.getSequenceNumberCycles();
        long $sampleTimestampSum = this.getSampleTimestampSum();
        result = result * 59 + (int)($sampleTimestampSum >>> 32 ^ $sampleTimestampSum);
        long $lastRtpTimestamp = this.getLastRtpTimestamp();
        result = result * 59 + (int)($lastRtpTimestamp >>> 32 ^ $lastRtpTimestamp);
        long $lastRtpSsrc = this.getLastRtpSsrc();
        result = result * 59 + (int)($lastRtpSsrc >>> 32 ^ $lastRtpSsrc);
        long $lastNtpTimeSenderReportReceived = this.getLastNtpTimeSenderReportReceived();
        result = result * 59 + (int)($lastNtpTimeSenderReportReceived >>> 32 ^ $lastNtpTimeSenderReportReceived);
        long $lastTimeRtcpReportReceived = this.getLastTimeRtcpReportReceived();
        result = result * 59 + (int)($lastTimeRtcpReportReceived >>> 32 ^ $lastTimeRtcpReportReceived);
        long $lastLocalTimeReceiveRtp = this.getLastLocalTimeReceiveRtp();
        result = result * 59 + (int)($lastLocalTimeReceiveRtp >>> 32 ^ $lastLocalTimeReceiveRtp);
        return result;
    }

    public String toString() {
        return "RtcpDataStatistics(sourceId=" + this.getSourceId() + ", highestSequenceNumber=" + this.getHighestSequenceNumber() + ", packetsReceivedSinceLastReset=" + this.getPacketsReceivedSinceLastReset() + ", packetsLostSinceLastReset=" + this.getPacketsLostSinceLastReset() + ", cumulativePacketLost=" + this.getCumulativePacketLost() + ", sequenceNumberCycles=" + this.getSequenceNumberCycles() + ", sampleTimestampSum=" + this.getSampleTimestampSum() + ", lastRtpTimestamp=" + this.getLastRtpTimestamp() + ", lastRtpSsrc=" + this.getLastRtpSsrc() + ", lastNtpTimeSenderReportReceived=" + this.getLastNtpTimeSenderReportReceived() + ", lastTimeRtcpReportReceived=" + this.getLastTimeRtcpReportReceived() + ", lastLocalTimeReceiveRtp=" + this.getLastLocalTimeReceiveRtp() + ")";
    }
}

