/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtcp.model;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.utils.IntegerUtil;

public class RtcpReportBlock
implements IObjectByteArray {
    private long sourceId;
    private int fractionLost;
    private int cumulativePacketLost;
    private long extHighestSequenceNumberReceived;
    private long jitter;
    private long lastNtpTimeSenderReportReceived;
    private long delaySinceLastTimeSenderReportReceived;

    @Override
    public int byteArrayLength() {
        return 24;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(24).putInteger(this.sourceId).putByte(this.fractionLost).putBytes(IntegerUtil.toCustomByteArray(this.cumulativePacketLost, 1, 3)).putInteger(this.extHighestSequenceNumberReceived).putInteger(this.jitter).putInteger(this.lastNtpTimeSenderReportReceived).putInteger(this.delaySinceLastTimeSenderReportReceived).getData();
    }

    public static RtcpReportBlock fromBytes(byte[] data) {
        return RtcpReportBlock.fromBytes(data, 0);
    }

    public static RtcpReportBlock fromBytes(byte[] data, int offset) {
        if (data.length < 24) {
            throw new IndexOutOfBoundsException("RtcpSdesChunk, data length < 24");
        }
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        RtcpReportBlock res = new RtcpReportBlock();
        res.sourceId = buff.getUInt32();
        res.fractionLost = buff.getByteToInt();
        res.cumulativePacketLost = IntegerUtil.toInt32In3Bytes(buff.getBytes(3), 0);
        res.extHighestSequenceNumberReceived = buff.getUInt32();
        res.jitter = buff.getUInt32();
        res.lastNtpTimeSenderReportReceived = buff.getUInt32();
        res.delaySinceLastTimeSenderReportReceived = buff.getUInt32();
        return res;
    }

    public long getSourceId() {
        return this.sourceId;
    }

    public int getFractionLost() {
        return this.fractionLost;
    }

    public int getCumulativePacketLost() {
        return this.cumulativePacketLost;
    }

    public long getExtHighestSequenceNumberReceived() {
        return this.extHighestSequenceNumberReceived;
    }

    public long getJitter() {
        return this.jitter;
    }

    public long getLastNtpTimeSenderReportReceived() {
        return this.lastNtpTimeSenderReportReceived;
    }

    public long getDelaySinceLastTimeSenderReportReceived() {
        return this.delaySinceLastTimeSenderReportReceived;
    }

    public void setSourceId(long sourceId) {
        this.sourceId = sourceId;
    }

    public void setFractionLost(int fractionLost) {
        this.fractionLost = fractionLost;
    }

    public void setCumulativePacketLost(int cumulativePacketLost) {
        this.cumulativePacketLost = cumulativePacketLost;
    }

    public void setExtHighestSequenceNumberReceived(long extHighestSequenceNumberReceived) {
        this.extHighestSequenceNumberReceived = extHighestSequenceNumberReceived;
    }

    public void setJitter(long jitter) {
        this.jitter = jitter;
    }

    public void setLastNtpTimeSenderReportReceived(long lastNtpTimeSenderReportReceived) {
        this.lastNtpTimeSenderReportReceived = lastNtpTimeSenderReportReceived;
    }

    public void setDelaySinceLastTimeSenderReportReceived(long delaySinceLastTimeSenderReportReceived) {
        this.delaySinceLastTimeSenderReportReceived = delaySinceLastTimeSenderReportReceived;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtcpReportBlock)) {
            return false;
        }
        RtcpReportBlock other = (RtcpReportBlock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSourceId() != other.getSourceId()) {
            return false;
        }
        if (this.getFractionLost() != other.getFractionLost()) {
            return false;
        }
        if (this.getCumulativePacketLost() != other.getCumulativePacketLost()) {
            return false;
        }
        if (this.getExtHighestSequenceNumberReceived() != other.getExtHighestSequenceNumberReceived()) {
            return false;
        }
        if (this.getJitter() != other.getJitter()) {
            return false;
        }
        if (this.getLastNtpTimeSenderReportReceived() != other.getLastNtpTimeSenderReportReceived()) {
            return false;
        }
        return this.getDelaySinceLastTimeSenderReportReceived() == other.getDelaySinceLastTimeSenderReportReceived();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtcpReportBlock;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $sourceId = this.getSourceId();
        result = result * 59 + (int)($sourceId >>> 32 ^ $sourceId);
        result = result * 59 + this.getFractionLost();
        result = result * 59 + this.getCumulativePacketLost();
        long $extHighestSequenceNumberReceived = this.getExtHighestSequenceNumberReceived();
        result = result * 59 + (int)($extHighestSequenceNumberReceived >>> 32 ^ $extHighestSequenceNumberReceived);
        long $jitter = this.getJitter();
        result = result * 59 + (int)($jitter >>> 32 ^ $jitter);
        long $lastNtpTimeSenderReportReceived = this.getLastNtpTimeSenderReportReceived();
        result = result * 59 + (int)($lastNtpTimeSenderReportReceived >>> 32 ^ $lastNtpTimeSenderReportReceived);
        long $delaySinceLastTimeSenderReportReceived = this.getDelaySinceLastTimeSenderReportReceived();
        result = result * 59 + (int)($delaySinceLastTimeSenderReportReceived >>> 32 ^ $delaySinceLastTimeSenderReportReceived);
        return result;
    }

    public String toString() {
        return "RtcpReportBlock(sourceId=" + this.getSourceId() + ", fractionLost=" + this.getFractionLost() + ", cumulativePacketLost=" + this.getCumulativePacketLost() + ", extHighestSequenceNumberReceived=" + this.getExtHighestSequenceNumberReceived() + ", jitter=" + this.getJitter() + ", lastNtpTimeSenderReportReceived=" + this.getLastNtpTimeSenderReportReceived() + ", delaySinceLastTimeSenderReportReceived=" + this.getDelaySinceLastTimeSenderReportReceived() + ")";
    }
}

