/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtcp.model;

import com.github.xingshuangs.iot.exceptions.RtcpCommException;
import com.github.xingshuangs.iot.protocol.rtcp.enums.ERtcpPackageType;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpApp;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpBasePackage;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpBye;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpReceiverReport;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpSdesReport;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpSenderReport;
import java.util.ArrayList;
import java.util.List;

public class RtcpPackageBuilder {
    private RtcpPackageBuilder() {
    }

    public static List<RtcpBasePackage> fromBytes(byte[] data) {
        return RtcpPackageBuilder.fromBytes(data, 0);
    }

    public static List<RtcpBasePackage> fromBytes(byte[] data, int offset) {
        RtcpBasePackage basePackage;
        ArrayList<RtcpBasePackage> list = new ArrayList<RtcpBasePackage>();
        for (int off = offset; data.length > off; off += basePackage.byteArrayLength()) {
            basePackage = RtcpPackageBuilder.parsePackage(data, off);
            list.add(basePackage);
        }
        return list;
    }

    public static RtcpBasePackage parsePackage(byte[] data, int offset) {
        ERtcpPackageType type = ERtcpPackageType.from(data[1 + offset]);
        switch (type) {
            case RR: {
                return RtcpReceiverReport.fromBytes(data, offset);
            }
            case SR: {
                return RtcpSenderReport.fromBytes(data, offset);
            }
            case SDES: {
                return RtcpSdesReport.fromBytes(data, offset);
            }
            case BYE: {
                return RtcpBye.fromBytes(data, offset);
            }
            case APP: {
                return RtcpApp.fromBytes(data, offset);
            }
        }
        throw new RtcpCommException("unrecognized type");
    }
}

