/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.mp4.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.mp4.enums.EMp4Type;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4Box;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4SampleData;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4SampleFlag;
import java.util.List;

public class Mp4TrunBox
extends Mp4Box {
    private final int version;
    private final byte[] flags;
    private final int offset;
    private final List<Mp4SampleData> samples;

    public Mp4TrunBox(List<Mp4SampleData> samples) {
        this.mp4Type = EMp4Type.TRUN;
        this.version = 0;
        this.flags = new byte[]{0, 15, 1};
        this.offset = 84 + 16 * samples.size() + 12 + samples.size() + 8;
        this.samples = samples;
    }

    @Override
    public int byteArrayLength() {
        return 20 + 16 * this.samples.size();
    }

    @Override
    public byte[] toByteArray() {
        int size = this.byteArrayLength();
        int length = this.samples.size();
        ByteWriteBuff buff = ByteWriteBuff.newInstance(size).putInteger(size).putBytes(this.mp4Type.getByteArray()).putByte(this.version).putBytes(this.flags).putInteger(length).putInteger(this.offset);
        for (Mp4SampleData sample : this.samples) {
            Mp4SampleFlag flag = sample.getFlags();
            buff.putInteger(sample.getDuration()).putInteger(sample.getSize()).putByte(flag.getIsLeading() << 2 | flag.getDependedOn()).putByte(flag.getIsDependedOn() << 6 | flag.getHasRedundancy() << 4 | flag.getPaddingValue() << 1 | flag.getIsNonSync()).putByte((flag.getDegradPrio() & 0xFFFFFFF0) << 8).putByte(flag.getDegradPrio() & 0xF).putInteger(sample.getCts());
        }
        return buff.getData();
    }
}

